<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

require_once "bp_options.php";
function bpLog($contents)
{
    $file = dirname(__FILE__) . "/bplog.txt";
    file_put_contents($file, date("m-d H:i:s") . ": ", FILE_APPEND);
    if (is_array($contents)) {
        $contents = var_export($contents, true);
    } else {
        if (is_object($contents)) {
            $contents = json_encode($contents);
        }
    }
    file_put_contents($file, $contents . "\n", FILE_APPEND);
}
function bpCurl($url, $apiKey, $post = false)
{
    global $bpOptions;
    $curl = curl_init($url);
    $length = 0;
    if ($post) {
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
        $length = strlen($post);
    }
    $uname = base64_encode($apiKey);
    $header = ["Content-Type: application/json", "Content-Length: " . $length, "Authorization: Basic " . $uname];
    curl_setopt($curl, CURLOPT_PORT, 443);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
    curl_setopt($curl, CURLOPT_TIMEOUT, 10);
    curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 1);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_FORBID_REUSE, 1);
    curl_setopt($curl, CURLOPT_FRESH_CONNECT, 1);
    $responseString = curl_exec($curl);
    if (!$responseString) {
        $response = ["error" => curl_error($curl)];
    } else {
        $response = json_decode($responseString, true);
        if (!$response) {
            $response = ["error" => "invalid json: " . $responseString];
        }
    }
    curl_close($curl);
    return $response;
}
function bpCreateInvoice($orderId, $price, $posData, $options = [])
{
    global $bpOptions;
    $options = array_merge($bpOptions, $options);
    $options["posData"] = "{\"posData\": \"" . $posData . "\"";
    if ($bpOptions["verifyPos"]) {
        $options["posData"] .= ", \"hash\": \"" . crypt($posData, $options["apiKey"]) . "\"";
    }
    $options["posData"] .= "}";
    $options["orderID"] = $orderId;
    $options["price"] = $price;
    $postOptions = ["orderID", "itemDesc", "itemCode", "notificationEmail", "notificationURL", "redirectURL", "posData", "price", "currency", "physical", "fullNotifications", "transactionSpeed", "buyerName", "buyerAddress1", "buyerAddress2", "buyerCity", "buyerState", "buyerZip", "buyerEmail", "buyerPhone"];
    foreach ($postOptions as $o) {
        if (array_key_exists($o, $options)) {
            $post[$o] = $options[$o];
        }
    }
    $post = json_encode($post);
    $response = bpcurl("https://bitpay.com/api/invoice/", $options["apiKey"], $post);
    return $response;
}
function bpVerifyNotification($apiKey = false)
{
    global $bpOptions;
    if (!$apiKey) {
        $apiKey = $bpOptions["apiKey"];
    }
    $post = file_get_contents("php://input");
    if (!$post) {
        return "No post data";
    }
    $json = json_decode($post, true);
    if (is_string($json)) {
        return $json;
    }
    if (!array_key_exists("posData", $json)) {
        return "no posData";
    }
    $posData = json_decode($json["posData"], true);
    if ($bpOptions["verifyPos"] && $posData["hash"] != crypt($posData["posData"], $apiKey)) {
        return "authentication failed (bad hash)";
    }
    $json["posData"] = $posData["posData"];
    return $json;
}
function bpGetInvoice($invoiceId, $apiKey = false)
{
    global $bpOptions;
    if (!$apiKey) {
        $apiKey = $bpOptions["apiKey"];
    }
    $response = bpcurl("https://bitpay.com/api/invoice/" . $invoiceId, $apiKey);
    if (is_string($response)) {
        return $response;
    }
    $response["posData"] = json_decode($response["posData"], true);
    return $response;
}

?>