<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

defined("DEFINE_MY_ACCESS") or exit("<h1 style=\"color: #C00; text-align: center;\"><strong>Restricted Access</strong></h1>");
function binancepay_config()
{
    $configarray = ["name" => ["Type" => "System", "Value" => "Binance Pay (https://merchant.binance.com/)"], "api_key" => ["Name" => "API Key", "Type" => "text", "Size" => "120", "Description" => "API Key found at https://merchant.binance.com/en/dashboard/developers"], "secret_key" => ["Name" => "Secret Key", "Type" => "text", "Size" => "55", "Description" => "Secret Key found at https://merchant.binance.com/en/dashboard/developers"], "merchant_id" => ["Name" => "Merchant ID", "Type" => "text", "Size" => "55", "Description" => "Secret Key found at https://merchant.binance.com/en/dashboard/profile"]];
    return $configarray;
}
function binancepay_link($params)
{
    include_once ROOTDIR . "/includes/gateway.fun.php";
    include_once ROOTDIR . "/includes/invoice.fun.php";
    global $config;
    global $lng_languag;
    global $paybp;
    global $bppaymentsuccess;
    if (strtoupper($params["curcode"]) !== "USD") {
        return "ERROR:: USD Currency Supported";
    }
    if ($bppaymentsuccess) {
        unset($entityBody);
        $entityBody["merchantId"] = $params["merchant_id"];
        $entityBody["merchantTradeNo"] = $bppaymentsuccess;
        $req = bp_call_api("https://bpay.binanceapi.com/binancepay/openapi/order/query", $entityBody, $params["api_key"], $params["secret_key"]);
        $_res = json_decode($req, true);
        if ($_res["status"] === "SUCCESS") {
            $_order_status = $_res["data"]["status"];
            if ($_order_status === "PAID") {
                $_totalFee = $_res["data"]["totalFee"];
                $_transactionId = $_res["data"]["transactionId"];
                $_invoice_id = (int) trim(explode("DHRU", $_res["data"]["merchantTradeNo"])[0]);
                addPayment($_invoice_id, $_transactionId, $_totalFee, 0, "binancepay", true);
                $_refresh_url = $params["returnurl"] . "?paymentsuccess=true";
                header("Location: " . $_refresh_url);
                return "Redirecting to payment page...<script>location.href = '" . $_refresh_url . "'</script>";
            }
        }
    }
    if ($paybp) {
        unset($entityBody);
        $entityBody["merchantId"] = $params["merchant_id"];
        $entityBody["merchantTradeNo"] = $params["invoiceid"] . "DHRU" . time();
        $entityBody["tradeType"] = "WEB";
        $entityBody["totalFee"] = $params["amount"];
        $entityBody["currency"] = "USDT";
        $entityBody["productType"] = "Digital Goods";
        $entityBody["productName"] = $params["description"];
        $entityBody["returnUrl"] = $params["returnurl"] . "?paymentsuccess=true&bppaymentsuccess=" . $entityBody["merchantTradeNo"];
        $entityBody["cancelUrl"] = $params["returnurl"] . "?paymentfail=true";
        $req = bp_call_api("https://bpay.binanceapi.com/binancepay/openapi/order", $entityBody, $params["api_key"], $params["secret_key"]);
        $_res = json_decode($req, true);
        if ($_res["status"] === "SUCCESS") {
            $OrderURL = $_res["data"]["checkoutUrl"];
            header("Location: " . $OrderURL);
            return "Redirecting to payment page...<script>location.href = '" . $OrderURL . "'</script>";
        }
        return "ERROR : " . $_res["errorMessage"];
    }
    return "<form  action='' method='post'>\n            <input type='submit' class='btn btn-primary paymentbtn' name='paybp' value='Pay Now' />\n            </form>";
}
function bp_call_api($url, $data, $api_key, $secret_key)
{
    $_entityBody = json_encode($data);
    $length = 32;
    $headers["content-type"] = "application/json";
    $headers["Binancepay-Nonce"] = substr(str_shuffle(str_repeat($x = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", ceil($length / strlen($x)))), 1, $length);
    $headers["Binancepay-Timestamp"] = time() * 1000;
    $headers["BinancePay-Certificate-SN"] = $api_key;
    $payload = $headers["Binancepay-Timestamp"] . "\n" . $headers["Binancepay-Nonce"] . "\n" . $_entityBody . "\n";
    $headers["BinancePay-Signature"] = strtoupper(hash_hmac("sha512", $payload, $secret_key));
    foreach ($headers as $k => $v) {
        $_headers[] = $k . ": " . $v;
    }
    $curl = curl_init();
    curl_setopt_array($curl, [CURLOPT_URL => $url, CURLOPT_RETURNTRANSFER => true, CURLOPT_ENCODING => "", CURLOPT_MAXREDIRS => 10, CURLOPT_TIMEOUT => 0, CURLOPT_FOLLOWLOCATION => true, CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1, CURLOPT_CUSTOMREQUEST => "POST", CURLOPT_POSTFIELDS => $_entityBody, CURLOPT_HTTPHEADER => $_headers]);
    $response = curl_exec($curl);
    curl_close($curl);
    return $response;
}

?>