<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

/**
 * BlackBerry Mep Calculator
 */
class BlackBerry
{
    private static $MEP_list = ["MEP-04103-001" => [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], "MEP-04103-002" => [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], "MEP-04103-004" => [120, 104, 114, 212, 112, 122, 103, 4, 27, 185, 12, 32, 192, 24, 172, 193], "MEP-04104-003" => [233, 0, 177, 226, 4, 201, 2, 25, 242, 77, 3, 20, 114, 151, 66, 194], "MEP-04104-004" => [233, 0, 177, 226, 4, 201, 2, 25, 242, 77, 3, 20, 114, 151, 66, 194], "MEP-04104-005" => [76, 151, 218, 52, 91, 76, 51, 121, 103, 99, 162, 78, 231, 20, 59, 237], "MEP-04104-006" => [21, 224, 133, 161, 74, 216, 181, 177, 147, 71, 226, 227, 239, 53, 181, 74], "MEP-04104-007" => [108, 162, 179, 125, 64, 7, 207, 160, 111, 173, 112, 182, 83, 97, 232, 226], "MEP-04104-008" => [206, 232, 150, 46, 10, 41, 96, 180, 98, 112, 49, 160, 240, 211, 129, 85], "MEP-04546-001" => [130, 24, 81, 215, 227, 114, 148, 116, 205, 255, 162, 191, 111, 21, 183, 211], "MEP-04598-003" => [153, 19, 78, 238, 129, 99, 211, 187, 139, 150, 220, 145, 89, 86, 131, 247], "MEP-04598-004" => [142, 228, 197, 49, 254, 47, 175, 210, 176, 160, 5, 181, 217, 53, 24, 181], "MEP-04598-005" => [168, 215, 126, 3, 30, 149, 79, 92, 84, 197, 165, 123, 170, 131, 12, 77], "MEP-04626-001" => [133, 161, 186, 121, 130, 108, 100, 174, 123, 11, 4, 112, 153, 121, 150, 40], "MEP-04626-002" => [133, 161, 186, 121, 130, 108, 100, 174, 123, 11, 4, 112, 153, 121, 150, 40], "MEP-04938-001" => [63, 4, 174, 82, 133, 138, 164, 79, 64, 192, 184, 106, 110, 112, 200, 195], "MEP-04938-002" => [63, 4, 174, 82, 133, 138, 164, 79, 64, 192, 184, 106, 110, 112, 200, 195], "MEP-05277-001" => [245, 218, 162, 112, 180, 215, 128, 7, 150, 135, 104, 195, 100, 169, 137, 198], "MEP-05277-002" => [99, 80, 179, 18, 69, 243, 173, 75, 111, 128, 151, 171, 67, 25, 194, 226], "MEP-05277-004" => [2, 67, 148, 100, 152, 34, 120, 41, 210, 98, 96, 132, 98, 129, 143, 176], "MEP-05277-005" => [218, 204, 28, 124, 40, 175, 19, 10, 171, 149, 197, 176, 224, 65, 12, 242], "MEP-06041-001" => [27, 99, 100, 98, 19, 217, 15, 231, 244, 77, 123, 131, 251, 176, 108, 253], "MEP-06041-003" => [239, 91, 241, 16, 55, 71, 156, 36, 121, 112, 211, 45, 78, 230, 234, 42], "MEP-06041-004" => [196, 214, 86, 22, 8, 227, 231, 236, 224, 114, 255, 200, 40, 2, 115, 153], "MEP-06041-005" => [18, 117, 71, 234, 211, 197, 53, 97, 122, 225, 0, 193, 61, 161, 6, 84], "MEP-06041-006" => [236, 113, 80, 150, 211, 158, 36, 226, 38, 101, 12, 226, 148, 22, 57, 107], "MEP-06041-007" => [93, 42, 225, 183, 212, 38, 1, 5, 23, 116, 178, 228, 161, 229, 185, 21], "MEP-06041-008" => [253, 166, 78, 170, 98, 133, 21, 14, 248, 148, 29, 151, 50, 196, 184, 148], "MEP-06041-009" => [92, 116, 12, 108, 110, 153, 171, 240, 48, 125, 56, 80, 230, 14, 129, 55], "MEP-06041-010" => [38, 199, 152, 45, 157, 163, 228, 178, 111, 159, 106, 254, 139, 224, 105, 9], "MEP-06041-011" => [115, 219, 149, 241, 43, 23, 101, 161, 30, 232, 131, 117, 165, 39, 253, 67], "MEP-06041-012" => [234, 130, 196, 162, 23, 23, 84, 160, 98, 174, 54, 191, 14, 163, 23, 250], "MEP-06041-013" => [188, 224, 77, 169, 159, 123, 153, 227, 243, 124, 28, 142, 241, 101, 146, 250], "MEP-06068-001" => [76, 112, 233, 218, 156, 69, 221, 236, 138, 67, 64, 230, 195, 196, 24, 207], "MEP-06068-002" => [103, 126, 139, 251, 48, 80, 78, 205, 176, 197, 175, 192, 88, 181, 80, 213], "MEP-06259-002" => [170, 93, 44, 219, 46, 224, 147, 103, 241, 110, 164, 59, 65, 137, 8, 221], "MEP-06259-003" => [25, 104, 139, 81, 169, 143, 206, 253, 161, 91, 45, 242, 37, 201, 70, 37], "MEP-06423-001" => [176, 127, 141, 216, 168, 239, 40, 70, 35, 255, 173, 26, 24, 37, 105, 235], "MEP-06424-001" => [133, 68, 142, 202, 183, 213, 192, 20, 207, 144, 40, 12, 169, 98, 52, 192], "MEP-06424-002" => [206, 240, 237, 230, 14, 150, 160, 190, 219, 217, 140, 235, 162, 249, 197, 203], "MEP-06529-001" => [213, 222, 183, 113, 118, 58, 58, 4, 248, 183, 70, 233, 129, 58, 202, 43], "MEP-06529-002" => [143, 206, 240, 132, 198, 4, 206, 123, 169, 61, 65, 110, 35, 162, 224, 80], "MEP-06530-001" => [50, 30, 135, 45, 237, 140, 167, 53, 255, 156, 197, 70, 115, 147, 53, 162], "MEP-06530-002" => [143, 206, 240, 132, 198, 4, 206, 123, 169, 61, 65, 110, 35, 162, 224, 80], "MEP-06810-002" => [202, 97, 24, 40, 30, 17, 247, 169, 130, 36, 152, 11, 123, 188, 114, 249], "MEP-06810-003" => [53, 238, 183, 76, 227, 176, 97, 149, 236, 27, 31, 86, 210, 46, 244, 31], "MEP-06811-003" => [40, 204, 251, 110, 70, 64, 147, 222, 57, 152, 190, 29, 244, 3, 110, 69], "MEP-06812-001" => [242, 147, 229, 59, 206, 172, 66, 155, 155, 136, 230, 128, 142, 177, 39, 151], "MEP-06812-003" => [218, 168, 93, 98, 148, 194, 64, 95, 202, 201, 85, 194, 73, 99, 255, 44], "MEP-06812-004" => [40, 88, 35, 16, 184, 200, 57, 97, 10, 32, 146, 110, 21, 80, 128, 136], "MEP-06813-001" => [9, 199, 56, 203, 9, 12, 68, 193, 248, 92, 216, 167, 18, 206, 196, 118], "MEP-06813-002" => [212, 231, 102, 239, 105, 26, 5, 93, 228, 219, 129, 111, 56, 16, 16, 238], "MEP-06814-001" => [238, 58, 80, 185, 235, 254, 112, 213, 196, 36, 247, 89, 17, 141, 188, 2], "MEP-06814-002" => [238, 58, 80, 185, 235, 254, 112, 213, 196, 36, 247, 89, 17, 141, 188, 2], "MEP-06814-004" => [169, 147, 134, 181, 191, 1, 243, 19, 120, 32, 186, 139, 157, 41, 215, 197], "MEP-06814-005" => [194, 66, 212, 191, 107, 67, 232, 181, 246, 132, 252, 194, 210, 92, 57, 29], "MEP-06849-001" => [209, 61, 191, 167, 120, 57, 202, 226, 84, 170, 119, 100, 151, 43, 216, 208], "MEP-06849-002" => [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], "MEP-06893-001" => [96, 137, 111, 185, 197, 236, 31, 101, 218, 132, 131, 224, 8, 64, 70, 217], "MEP-06899-001" => [94, 12, 33, 203, 211, 39, 235, 188, 50, 164, 31, 221, 176, 80, 249, 82], "MEP-06899-002" => [162, 192, 144, 50, 3, 98, 96, 31, 14, 49, 175, 245, 249, 119, 234, 194], "MEP-07321-002" => [167, 132, 212, 119, 159, 75, 198, 216, 75, 128, 87, 35, 158, 120, 244, 253], "MEP-07484-001" => [201, 188, 186, 246, 17, 179, 187, 4, 249, 48, 96, 233, 167, 36, 218, 103], "MEP-07484-002" => [19, 146, 15, 131, 110, 34, 95, 35, 234, 164, 49, 237, 135, 79, 174, 63], "MEP-07484-003" => [179, 171, 113, 172, 89, 184, 67, 245, 52, 31, 165, 80, 187, 247, 13, 187], "MEP-07484-004" => [103, 206, 7, 144, 87, 111, 40, 28, 100, 182, 151, 249, 88, 56, 10, 105], "MEP-07484-005" => [138, 213, 188, 35, 95, 246, 2, 31, 197, 29, 11, 85, 96, 186, 176, 25], "MEP-07484-006" => [141, 156, 239, 170, 208, 131, 83, 249, 73, 26, 62, 133, 166, 174, 14, 91], "MEP-07484-007" => [95, 145, 253, 155, 183, 230, 127, 198, 184, 33, 6, 4, 53, 185, 155, 71], "MEP-07705-002" => [33, 8, 180, 184, 66, 209, 79, 66, 156, 245, 130, 100, 134, 72, 243, 97], "MEP-07705-003" => [102, 215, 106, 251, 192, 16, 32, 230, 130, 242, 204, 179, 188, 178, 123, 185], "MEP-07722-001" => [201, 59, 78, 213, 66, 38, 2, 197, 34, 140, 226, 91, 189, 219, 113, 149], "MEP-07722-002" => [79, 55, 121, 131, 135, 62, 6, 112, 119, 134, 238, 207, 206, 65, 216, 20], "MEP-07722-003" => [136, 22, 245, 90, 58, 186, 133, 213, 131, 241, 154, 79, 118, 70, 167, 239], "MEP-07723-001" => [12, 1, 211, 109, 232, 78, 180, 3, 207, 228, 41, 70, 51, 218, 215, 205], "MEP-07723-003" => [195, 127, 154, 124, 76, 83, 141, 196, 127, 14, 184, 19, 39, 161, 157, 208], "MEP-07723-004" => [248, 29, 152, 233, 211, 62, 177, 5, 100, 212, 146, 224, 170, 253, 33, 28], "MEP-07723-005" => [47, 67, 59, 197, 108, 94, 158, 251, 77, 254, 228, 197, 99, 13, 214, 130], "MEP-07723-006" => [211, 12, 217, 21, 12, 213, 64, 40, 119, 114, 16, 254, 55, 198, 50, 167], "MEP-07723-007" => [166, 183, 98, 160, 185, 72, 255, 220, 201, 94, 24, 119, 142, 58, 16, 223], "MEP-07754-001" => [123, 112, 130, 59, 14, 119, 102, 231, 226, 140, 7, 183, 112, 51, 95, 183], "MEP-08209-001" => [185, 199, 205, 147, 240, 85, 5, 162, 94, 154, 103, 58, 109, 174, 75, 194], "MEP-08209-002" => [248, 98, 6, 22, 186, 245, 48, 62, 71, 252, 29, 150, 175, 207, 213, 113], "MEP-08209-003" => [80, 174, 157, 68, 159, 157, 211, 249, 5, 227, 188, 196, 7, 163, 89, 190], "MEP-08209-004" => [173, 229, 157, 164, 131, 131, 146, 49, 28, 233, 16, 5, 1, 35, 156, 103], "MEP-08318-001" => [209, 7, 27, 182, 254, 87, 29, 195, 25, 110, 230, 136, 213, 245, 4, 117], "MEP-08395-001" => [251, 143, 60, 33, 64, 75, 168, 48, 1, 133, 193, 24, 214, 46, 204, 177], "MEP-08448-001" => [226, 250, 171, 215, 194, 223, 193, 12, 243, 126, 164, 42, 47, 8, 107, 51], "MEP-08448-002" => [245, 110, 234, 114, 155, 182, 225, 36, 78, 252, 132, 238, 108, 209, 57, 37], "MEP-08589-001" => [140, 172, 158, 211, 96, 95, 74, 7, 128, 117, 77, 225, 180, 70, 23, 186], "MEP-08881-001" => [140, 136, 20, 105, 216, 53, 131, 245, 194, 175, 8, 36, 21, 10, 241, 23], "MEP-08882-001" => [182, 235, 201, 92, 251, 92, 137, 205, 171, 117, 165, 99, 43, 77, 63, 48], "MEP-08918-001" => [125, 23, 92, 216, 140, 195, 236, 106, 142, 213, 24, 52, 27, 190, 96, 176], "MEP-09004-001" => [176, 127, 141, 216, 168, 239, 40, 70, 35, 255, 173, 26, 24, 37, 105, 235], "MEP-09070-001" => [35, 155, 193, 172, 158, 41, 81, 59, 250, 253, 85, 158, 77, 116, 166, 98], "MEP-09149-001" => [40, 45, 234, 17, 194, 64, 164, 254, 62, 194, 118, 82, 218, 55, 184, 161], "MEP-09292-001" => [252, 108, 68, 229, 142, 161, 235, 217, 202, 10, 162, 51, 10, 240, 231, 155], "MEP-09292-002" => [69, 141, 233, 215, 89, 42, 84, 206, 12, 220, 32, 155, 214, 160, 7, 178], "MEP-09292-003" => [182, 219, 186, 232, 222, 21, 124, 102, 74, 128, 5, 129, 177, 79, 152, 139], "MEP-09292-004" => [237, 52, 143, 188, 188, 1, 186, 169, 179, 109, 203, 181, 179, 133, 116, 74], "MEP-09292-005" => [81, 24, 247, 161, 39, 239, 183, 144, 94, 16, 137, 125, 135, 251, 168, 34], "MEP-09292-006" => [21, 147, 199, 171, 16, 131, 190, 137, 205, 39, 179, 208, 129, 184, 22, 21], "MEP-09292-008" => [71, 34, 216, 1, 99, 58, 17, 229, 219, 40, 159, 175, 26, 109, 64, 0], "MEP-09293-001" => [32, 209, 207, 95, 25, 124, 36, 67, 18, 142, 211, 187, 178, 83, 64, 95], "MEP-09625-001" => [252, 4, 191, 49, 227, 32, 183, 155, 215, 163, 227, 132, 28, 230, 198, 138], "MEP-09625-002" => [160, 136, 35, 109, 102, 116, 50, 7, 242, 125, 155, 60, 98, 216, 50, 15], "MEP-09667-001" => [8, 29, 182, 40, 129, 112, 107, 225, 111, 174, 230, 27, 246, 80, 63, 64], "MEP-09690-001" => [250, 63, 230, 222, 66, 127, 105, 87, 159, 87, 205, 205, 153, 154, 61, 21], "MEP-09747-001" => [241, 27, 180, 209, 117, 45, 204, 105, 108, 58, 87, 145, 161, 227, 82, 28], "MEP-09783-002" => [187, 139, 13, 40, 236, 26, 36, 226, 138, 76, 40, 68, 49, 73, 94, 192], "MEP-09783-003" => [192, 38, 136, 151, 84, 81, 165, 189, 74, 44, 211, 199, 114, 246, 17, 190], "MEP-09821-001" => [179, 220, 246, 108, 194, 218, 31, 0, 177, 211, 226, 9, 166, 173, 172, 223], "MEP-09821-002" => [206, 206, 122, 36, 146, 228, 104, 160, 143, 254, 92, 107, 216, 55, 152, 208], "MEP-09821-003" => [98, 147, 90, 4, 43, 62, 231, 92, 184, 136, 143, 53, 117, 240, 109, 162], "MEP-09917-001" => [241, 234, 64, 55, 218, 224, 30, 225, 93, 197, 106, 97, 88, 215, 150, 185], "MEP-09938-001" => [48, 128, 243, 90, 196, 33, 45, 236, 101, 4, 18, 210, 103, 107, 49, 125], "MEP-10073-001" => [114, 81, 172, 179, 146, 34, 118, 80, 100, 211, 79, 232, 71, 137, 40, 133], "MEP-10129-001" => [124, 50, 91, 126, 207, 21, 30, 52, 32, 72, 46, 243, 3, 122, 102, 159], "MEP-10129-002" => [125, 123, 55, 243, 5, 227, 184, 159, 146, 82, 129, 61, 143, 118, 46, 26], "MEP-10129-003" => [154, 202, 248, 253, 158, 43, 48, 106, 92, 227, 251, 188, 48, 49, 68, 144], "MEP-10129-004" => [212, 49, 200, 205, 255, 192, 127, 24, 222, 194, 17, 61, 24, 68, 156, 206], "MEP-10129-005" => [203, 187, 1, 149, 31, 69, 39, 215, 166, 152, 17, 55, 86, 62, 196, 157], "MEP-11016-001" => [183, 91, 76, 156, 0, 74, 137, 13, 45, 249, 197, 70, 248, 148, 22, 168], "MEP-11139-001" => [123, 60, 85, 168, 36, 184, 193, 14, 86, 165, 171, 38, 144, 236, 127, 138], "MEP-11139-002" => [22, 92, 166, 69, 97, 194, 18, 39, 9, 50, 166, 222, 138, 154, 144, 46], "MEP-11139-003" => [190, 227, 242, 131, 166, 10, 214, 119, 31, 168, 201, 228, 116, 43, 242, 124], "MEP-11139-004" => [37, 21, 170, 226, 104, 186, 249, 152, 133, 196, 157, 211, 190, 193, 26, 143], "MEP-11139-005" => [100, 160, 225, 163, 122, 198, 161, 202, 178, 226, 228, 203, 134, 47, 95, 209], "MEP-11139-006" => [233, 37, 154, 65, 101, 237, 88, 208, 100, 41, 171, 217, 54, 145, 150, 50], "MEP-11246-001" => [91, 3, 139, 135, 151, 101, 84, 11, 45, 232, 254, 26, 213, 79, 173, 156], "MEP-11246-002" => [178, 210, 54, 251, 150, 210, 250, 54, 74, 99, 228, 57, 42, 95, 113, 89], "MEP-11414-001" => [183, 40, 34, 23, 155, 242, 131, 166, 197, 35, 95, 221, 53, 63, 214, 99], "MEP-11414-002" => [8, 238, 111, 14, 113, 76, 38, 63, 42, 233, 45, 59, 68, 117, 162, 173], "MEP-11534-002" => [187, 100, 14, 94, 19, 217, 49, 236, 168, 118, 206, 173, 112, 249, 201, 8], "MEP-11534-004" => [141, 166, 224, 19, 95, 180, 68, 35, 128, 188, 117, 79, 198, 211, 70, 36], "MEP-11534-005" => [181, 171, 63, 114, 222, 61, 58, 120, 51, 135, 158, 202, 140, 80, 154, 104], "MEP-11534-006" => [201, 97, 219, 199, 147, 232, 69, 176, 129, 125, 215, 42, 224, 17, 145, 82], "MEP-11534-007" => [25, 88, 226, 129, 14, 146, 249, 95, 182, 133, 254, 225, 179, 123, 121, 66], "MEP-11534-008" => [88, 250, 180, 244, 192, 254, 63, 175, 99, 151, 156, 203, 2, 74, 36, 164], "MEP-12186-001" => [208, 3, 110, 33, 77, 117, 88, 80, 105, 149, 209, 207, 191, 118, 242, 95], "MEP-12209-003" => [205, 21, 100, 231, 144, 100, 203, 26, 140, 195, 3, 193, 156, 238, 238, 78], "MEP-12209-004" => [123, 227, 123, 32, 9, 169, 120, 32, 147, 74, 198, 245, 103, 13, 221, 246], "MEP-12209-006" => [173, 18, 122, 184, 76, 85, 178, 69, 242, 201, 105, 94, 48, 139, 255, 188], "MEP-12209-007" => [148, 194, 66, 85, 250, 17, 125, 37, 119, 185, 88, 226, 147, 28, 104, 229], "MEP-12209-008" => [123, 67, 23, 26, 234, 199, 204, 144, 141, 102, 54, 215, 166, 211, 0, 146], "MEP-12488-001" => [168, 116, 128, 130, 98, 191, 152, 217, 184, 159, 58, 37, 60, 86, 164, 151], "MEP-12565-001" => [119, 18, 44, 80, 183, 194, 57, 33, 166, 247, 240, 197, 123, 184, 221, 38], "MEP-12579-001" => [160, 138, 223, 250, 236, 31, 103, 110, 113, 187, 232, 254, 111, 175, 113, 8], "MEP-12579-002" => [112, 109, 177, 161, 174, 145, 26, 174, 183, 155, 25, 201, 25, 126, 83, 67], "MEP-12599-003" => [134, 147, 173, 200, 25, 32, 89, 219, 157, 182, 60, 128, 9, 89, 224, 57], "MEP-12622-002" => [254, 58, 56, 8, 37, 219, 228, 76, 218, 172, 109, 214, 209, 155, 197, 126], "MEP-12907-002" => [203, 167, 206, 135, 182, 67, 38, 211, 214, 204, 54, 196, 84, 201, 134, 167], "MEP-12978-001" => [90, 124, 67, 37, 119, 28, 111, 95, 62, 130, 236, 198, 89, 50, 19, 36], "MEP-12980-001" => [90, 237, 152, 205, 35, 108, 93, 37, 156, 107, 48, 31, 163, 105, 7, 83], "MEP-12980-002" => [93, 199, 193, 202, 106, 87, 170, 162, 64, 156, 38, 196, 255, 216, 73, 15], "MEP-13188-001" => [169, 106, 160, 23, 94, 165, 55, 226, 93, 232, 242, 118, 25, 130, 165, 168], "MEP-13188-002" => [246, 144, 45, 49, 181, 107, 118, 204, 180, 162, 109, 255, 133, 165, 162, 119], "MEP-13188-006" => [160, 223, 62, 192, 150, 227, 2, 228, 227, 129, 166, 155, 56, 160, 126, 205], "MEP-13188-007" => [235, 226, 83, 32, 196, 83, 152, 146, 169, 145, 202, 99, 22, 148, 73, 14], "MEP-13188-008" => [26, 207, 82, 221, 37, 21, 194, 97, 57, 77, 72, 95, 168, 136, 102, 246], "MEP-13188-010" => [49, 88, 54, 21, 118, 125, 243, 236, 63, 21, 4, 219, 140, 213, 129, 45], "MEP-13710-001" => [243, 57, 1, 253, 119, 25, 196, 244, 98, 187, 251, 136, 166, 194, 19, 108], "MEP-13928-001" => [146, 75, 169, 203, 37, 115, 127, 20, 203, 102, 46, 174, 59, 96, 204, 204], "MEP-13928-002" => [143, 53, 3, 152, 253, 253, 68, 160, 43, 85, 170, 241, 46, 98, 246, 34], "MEP-13988-001" => [173, 255, 235, 200, 50, 67, 114, 177, 26, 26, 28, 10, 253, 26, 15, 47], "MEP-13990-001" => [253, 122, 164, 139, 140, 70, 111, 90, 230, 65, 223, 118, 222, 11, 40, 191], "MEP-14052-001" => [37, 207, 136, 228, 13, 109, 247, 211, 116, 113, 114, 49, 108, 235, 217, 195], "MEP-14052-002" => [194, 170, 1, 176, 26, 134, 34, 114, 97, 194, 239, 22, 249, 243, 31, 105], "MEP-14074-001" => [145, 213, 237, 58, 101, 112, 127, 130, 70, 145, 135, 141, 7, 84, 83, 126], "MEP-14074-002" => [104, 197, 111, 31, 151, 254, 107, 135, 85, 53, 253, 190, 114, 52, 95, 170], "MEP-14074-003" => [92, 250, 119, 122, 161, 198, 20, 237, 43, 6, 241, 218, 155, 167, 73, 65], "MEP-14074-004" => [72, 194, 173, 81, 250, 224, 255, 255, 133, 171, 57, 163, 61, 217, 75, 3], "MEP-14150-001" => [186, 190, 76, 125, 118, 247, 156, 102, 100, 192, 254, 103, 156, 85, 67, 87], "MEP-14260-001" => [147, 137, 182, 116, 48, 197, 107, 50, 246, 219, 116, 147, 136, 22, 53, 130], "MEP-14260-002" => [54, 39, 243, 212, 48, 4, 159, 185, 170, 218, 249, 243, 142, 176, 252, 213], "MEP-14896-001" => [254, 59, 182, 199, 120, 16, 194, 134, 127, 29, 2, 83, 63, 38, 75, 222], "MEP-14896-002" => [104, 217, 180, 54, 148, 223, 110, 171, 45, 50, 145, 50, 102, 131, 88, 146], "MEP-14896-003" => [51, 113, 142, 23, 173, 35, 2, 81, 158, 37, 144, 8, 63, 208, 236, 32], "MEP-14896-004" => [126, 170, 1, 46, 61, 79, 230, 94, 145, 59, 70, 54, 94, 30, 43, 169], "MEP-14896-005" => [110, 113, 13, 160, 1, 94, 236, 196, 138, 149, 225, 27, 177, 16, 0, 176], "MEP-15159-001" => [91, 230, 237, 128, 12, 236, 9, 25, 155, 13, 144, 20, 93, 61, 0, 6], "MEP-15159-002" => [91, 141, 149, 211, 222, 218, 129, 199, 187, 167, 151, 124, 131, 53, 241, 35], "MEP-15326-001" => [101, 5, 147, 81, 154, 30, 96, 252, 228, 198, 30, 82, 152, 65, 201, 93], "MEP-15326-002" => [211, 164, 228, 86, 10, 169, 2, 110, 70, 109, 90, 5, 64, 55, 61, 38], "MEP-15343-001" => [130, 28, 219, 156, 74, 83, 150, 214, 9, 146, 24, 198, 108, 210, 57, 22], "MEP-16272-002" => [17, 135, 243, 21, 224, 127, 208, 75, 120, 198, 182, 201, 17, 58, 18, 191], "MEP-16272-003" => [233, 55, 178, 216, 155, 80, 60, 201, 188, 0, 117, 180, 46, 26, 183, 153], "MEP-16272-005" => [73, 132, 55, 203, 189, 155, 93, 26, 131, 22, 29, 64, 247, 121, 193, 47], "MEP-16352-001" => [37, 122, 231, 153, 247, 40, 71, 115, 18, 33, 137, 171, 174, 5, 154, 71], "MEP-16419-001" => [42, 53, 87, 44, 238, 218, 23, 163, 189, 79, 186, 42, 138, 35, 101, 143], "MEP-16472-001" => [64, 216, 177, 251, 76, 73, 65, 131, 102, 158, 26, 109, 98, 28, 119, 120], "MEP-16826-001" => [164, 110, 10, 177, 6, 187, 77, 79, 185, 250, 252, 195, 230, 190, 232, 89], "MEP-17232-001" => [247, 114, 26, 89, 157, 243, 81, 191, 112, 154, 133, 90, 154, 5, 196, 122], "MEP-17490-001" => [11, 99, 160, 128, 210, 185, 83, 229, 26, 3, 25, 131, 203, 11, 74, 99], "MEP-17568-002" => [119, 72, 191, 112, 227, 205, 45, 95, 253, 1, 199, 243, 149, 31, 105, 92], "MEP-18601-001" => [2, 64, 242, 62, 144, 3, 237, 62, 14, 178, 60, 59, 128, 213, 141, 225], "MEP-18637-001" => [147, 15, 213, 128, 203, 212, 181, 123, 176, 212, 71, 55, 168, 187, 107, 78], "MEP-18637-001c" => [147, 15, 213, 128, 203, 212, 181, 123, 176, 212, 71, 55, 168, 187, 107, 78], "MEP-19322-003" => [118, 253, 113, 56, 110, 245, 203, 160, 155, 137, 52, 135, 75, 69, 211, 93], "MEP-19877-001" => [145, 252, 59, 230, 8, 232, 89, 126, 57, 119, 203, 150, 206, 194, 124, 68], "MEP-20099-002" => [109, 109, 117, 91, 160, 149, 0, 66, 89, 79, 105, 185, 212, 138, 87, 104], "MEP-20099-004" => [25, 55, 197, 135, 66, 132, 67, 104, 255, 238, 77, 20, 167, 155, 131, 246], "MEP-20099-009" => [50, 121, 45, 70, 134, 235, 9, 250, 212, 30, 88, 36, 208, 214, 218, 169], "MEP-20166-001" => [78, 139, 252, 19, 138, 138, 109, 236, 255, 193, 111, 62, 221, 74, 196, 166], "MEP-20454-001" => [167, 142, 83, 124, 76, 12, 110, 169, 183, 1, 164, 230, 134, 35, 36, 57], "MEP-20669-001" => [197, 74, 134, 79, 237, 64, 130, 233, 252, 238, 203, 237, 116, 121, 104, 5], "MEP-21545-001" => [44, 21, 41, 104, 148, 29, 106, 21, 100, 161, 15, 232, 68, 16, 161, 50], "MEP-21878-001" => [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], "MEP-22793-001" => [95, 170, 171, 167, 82, 173, 0, 28, 228, 67, 122, 103, 171, 229, 65, 221], "MEP-23361-001" => [215, 209, 71, 156, 133, 164, 165, 0, 226, 27, 39, 1, 86, 70, 113, 228], "MEP-24124-001" => [68, 52, 149, 128, 188, 223, 118, 39, 41, 79, 68, 81, 124, 47, 199, 7], "MEP-24409-002" => [158, 112, 120, 208, 187, 68, 183, 4, 115, 54, 208, 100, 17, 140, 10, 225], "MEP-24660-001" => [85, 39, 120, 249, 231, 199, 67, 164, 27, 11, 237, 126, 4, 192, 29, 34], "MEP-24660-003" => [236, 243, 243, 73, 242, 125, 31, 241, 212, 77, 2, 125, 116, 27, 106, 111], "MEP-24667-001" => [203, 204, 153, 143, 138, 179, 138, 164, 211, 103, 220, 9, 41, 51, 184, 34], "MEP-24667-002" => [143, 191, 103, 176, 136, 36, 20, 5, 35, 56, 215, 76, 97, 56, 3, 100], "MEP-24667-003" => [154, 104, 179, 123, 250, 58, 200, 125, 79, 120, 33, 103, 164, 187, 251, 103], "MEP-24667-004" => [217, 201, 28, 134, 31, 140, 234, 195, 120, 209, 140, 40, 56, 15, 68, 147], "MEP-24723-001" => [68, 37, 118, 189, 133, 122, 152, 165, 241, 80, 9, 12, 185, 201, 97, 29], "MEP-24723-002" => [127, 221, 125, 59, 110, 196, 117, 2, 178, 139, 25, 148, 175, 19, 64, 59], "MEP-26594-001" => [98, 51, 222, 252, 254, 225, 227, 226, 231, 248, 207, 230, 209, 100, 255, 53], "MEP-26900-003" => [36, 219, 41, 13, 31, 145, 103, 22, 135, 164, 250, 43, 240, 230, 167, 120], "MEP-27488-001" => [30, 143, 87, 89, 212, 8, 147, 150, 54, 194, 194, 133, 135, 15, 20, 67], "MEP-27501-003" => [67, 235, 252, 200, 138, 169, 44, 109, 195, 209, 201, 162, 119, 190, 83, 198], "MEP-28240-002" => [196, 6, 232, 13, 254, 82, 84, 23, 17, 188, 6, 108, 141, 136, 178, 190], "MEP-28364-001" => [98, 42, 117, 130, 136, 178, 39, 155, 23, 1, 96, 182, 93, 49, 168, 41], "MEP-28555-001" => [164, 81, 192, 188, 183, 251, 165, 173, 189, 136, 161, 25, 139, 76, 124, 217], "MEP-29080-002" => [247, 137, 109, 141, 136, 113, 137, 225, 199, 44, 30, 250, 59, 194, 99, 139], "MEP-29318-001" => [28, 42, 31, 53, 208, 245, 220, 100, 52, 176, 126, 227, 199, 91, 8, 242], "MEP-30218-001" => [218, 48, 145, 222, 205, 62, 242, 14, 44, 20, 77, 153, 225, 177, 37, 189], "MEP-30218-002" => [131, 118, 105, 153, 77, 27, 7, 49, 125, 1, 120, 231, 103, 130, 150, 243], "MEP-30638-001" => [110, 14, 55, 105, 140, 94, 189, 103, 161, 34, 181, 209, 200, 228, 122, 195], "MEP-30669-001" => [234, 4, 19, 189, 186, 192, 69, 31, 76, 197, 253, 83, 231, 12, 186, 64], "MEP-31845-001" => [233, 134, 9, 49, 196, 112, 139, 3, 42, 49, 203, 60, 213, 205, 105, 14], "MEP-31845-002" => [225, 8, 54, 149, 167, 196, 204, 251, 98, 80, 250, 193, 166, 192, 69, 105], "MEP-33006-002" => [225, 1, 234, 132, 153, 33, 144, 7, 9, 51, 14, 226, 59, 203, 115, 201], "MEP-34723-001" => [134, 253, 54, 71, 253, 58, 109, 244, 86, 249, 108, 54, 164, 79, 254, 136], "MEP-34870-001" => [124, 78, 132, 103, 192, 80, 116, 102, 31, 54, 126, 134, 217, 65, 152, 159], "MEP-34870-002" => [32, 86, 28, 138, 37, 159, 164, 207, 31, 221, 245, 92, 219, 148, 76, 165], "MEP-39371-001" => [240, 27, 222, 55, 121, 81, 139, 62, 209, 38, 209, 128, 158, 241, 242, 235], "MEP-40488-002" => [195, 207, 181, 213, 51, 139, 29, 241, 173, 119, 187, 13, 3, 98, 181, 20], "MEP-40954-001" => [46, 161, 235, 27, 40, 14, 212, 67, 116, 91, 188, 227, 193, 150, 193, 181], "MEP-41261-001" => [175, 209, 20, 121, 189, 90, 253, 10, 211, 168, 150, 118, 41, 86, 111, 179], "MEP-41468-001" => [224, 56, 190, 36, 52, 255, 186, 94, 8, 64, 176, 94, 227, 82, 191, 57], "MEP-42490-002" => [126, 248, 204, 80, 180, 70, 71, 15, 1, 153, 50, 11, 36, 236, 36, 140], "MEP-42517-001" => [223, 204, 20, 251, 172, 249, 88, 23, 225, 140, 189, 245, 49, 69, 155, 164], "MEP-06041-016" => [101, 239, 228, 114, 71, 136, 153, 72, 62, 252, 209, 195, 180, 138, 17, 233], "MEP-06041-017" => [87, 73, 160, 30, 217, 203, 161, 226, 41, 180, 219, 34, 64, 170, 108, 65], "MEP-17568-003" => [154, 35, 28, 44, 213, 214, 169, 101, 126, 55, 77, 155, 22, 250, 234, 30], "MEP-09292-009" => [237, 52, 143, 188, 188, 1, 186, 169, 179, 109, 203, 181, 179, 133, 116, 74], "MEP-10129-006" => [142, 18, 16, 233, 209, 120, 171, 37, 73, 239, 139, 226, 234, 35, 40, 46], "MEP-29318-002" => [184, 223, 197, 248, 12, 44, 149, 158, 195, 128, 173, 49, 179, 164, 79, 74], "MEP-42490-001" => [20, 55, 181, 26, 228, 163, 203, 189, 251, 244, 223, 135, 211, 206, 148, 33], "MEP-46976-002" => [215, 246, 168, 34, 164, 0, 161, 49, 163, 195, 151, 62, 161, 169, 108, 174], "MEP-09917-003" => [203, 181, 82, 13, 118, 46, 231, 147, 142, 45, 40, 71, 152, 3, 74, 214], "MEP-12209-010" => [209, 29, 90, 91, 46, 240, 194, 130, 59, 164, 83, 114, 220, 221, 43, 15], "MEP-11534-009" => [105, 163, 98, 237, 205, 68, 35, 6, 121, 27, 186, 140, 147, 47, 71, 119], "MEP-40488-004" => [74, 81, 8, 83, 19, 110, 186, 115, 77, 32, 150, 80, 47, 104, 170, 219], "MEP-14896-006" => [38, 48, 206, 159, 235, 41, 156, 13, 207, 93, 122, 30, 229, 226, 59, 13], "MEP-11534-010" => [195, 133, 119, 139, 156, 140, 167, 81, 117, 205, 195, 70, 242, 223, 115, 92], "MEP-27501-001" => [123, 243, 119, 99, 209, 19, 48, 78, 213, 192, 38, 244, 127, 114, 129, 38], "MEP-09292-007" => [153, 194, 14, 78, 102, 184, 172, 169, 86, 0, 195, 56, 29, 99, 95, 176], "MEP-12599-004" => [189, 61, 176, 201, 182, 136, 213, 206, 107, 8, 170, 99, 159, 98, 233, 219], "MEP-12907-003" => [123, 192, 187, 129, 46, 185, 97, 115, 234, 188, 87, 221, 9, 191, 124, 243], "MEP-17568-004" => [180, 7, 68, 178, 4, 18, 61, 217, 31, 139, 66, 4, 230, 111, 56, 25], "MEP-24660-002" => [76, 23, 238, 83, 193, 31, 97, 6, 36, 86, 212, 75, 50, 120, 125, 56], "MEP-26490-001" => [224, 27, 106, 73, 19, 203, 81, 76, 15, 219, 235, 208, 41, 253, 18, 162], "MEP-26900-001" => [246, 197, 130, 207, 133, 96, 124, 204, 28, 251, 12, 186, 133, 224, 176, 215], "MEP-27501-002" => [170, 150, 172, 166, 79, 176, 18, 155, 129, 214, 162, 196, 228, 140, 14, 195], "MEP-27559-001" => [17, 188, 216, 42, 107, 207, 99, 53, 55, 172, 250, 176, 184, 159, 153, 186], "MEP-27561-001" => [122, 167, 193, 193, 5, 176, 109, 48, 245, 55, 192, 69, 169, 94, 137, 91], "MEP-29080-001" => [35, 40, 33, 173, 188, 93, 22, 241, 4, 7, 118, 16, 88, 141, 92, 67], "MEP-40488-001" => [80, 150, 191, 213, 160, 115, 77, 33, 129, 167, 117, 24, 254, 177, 238, 33], "MEP-46976-001" => [166, 215, 154, 62, 96, 26, 122, 41, 87, 142, 119, 132, 77, 91, 231, 46], "MEP-29080-003" => [250, 95, 158, 194, 200, 41, 129, 101, 193, 219, 122, 83, 24, 201, 205, 233]];
    private function __construct()
    {
    }
    public static function calculate($IMEI, $MEP)
    {
        if (!isset(self::$MEP_list[$MEP])) {
            return false;
        }
        $prPass = self::_createPrivatePass($MEP);
        $result = [];
        $result["IMEI"] = $IMEI;
        $result["MEP"] = $MEP;
        $result["MEP2"] = self::_hash2code(self::_my_Sha1($IMEI, $prPass, 1), $MEP, 1);
        $result["MEP4"] = self::_hash2code(self::_my_Sha1($IMEI, $prPass, 3), $MEP, 3);
        return $result;
    }
    public static function getMepList()
    {
        return array_keys(self::$MEP_list);
    }
    private static function _createPrivatePass($MEP)
    {
        $key = [22, 39, 153, 194, 200, 153, 184, 201, 222, 237, 119, 162, 98, 210, 102, 94];
        $result = [];
        for ($i = 0; $i <= 15; $i++) {
            $result[$i] = self::$MEP_list[$MEP][$i] ^ $key[$i];
        }
        return $result;
    }
    private static function _my_Sha1($imei_i, $prPass, $mepNumber)
    {
        $kopad = array_fill(0, 64, 0);
        $kipad = array_fill(0, 64, 0);
        $pPass = array_fill(0, 64, 0);
        for ($i = 0; $i <= 15; $i++) {
            $pPass[$i] = $prPass[$i];
        }
        for ($i = 0; $i <= 14; $i++) {
            $imei[$i] = ord($imei_i[$i]);
        }
        $imei[15] = $mepNumber;
        for ($i = 0; $i <= 63; $i++) {
            $kopad[$i] = $pPass[$i] ^ 92;
            $kipad[$i] = $pPass[$i] ^ 54;
        }
        $kipad = implode("", array_map("chr", $kipad));
        $kopad = implode("", array_map("chr", $kopad));
        $imei = implode("", array_map("chr", $imei));
        $ctx = hash_init("sha1");
        hash_update($ctx, $kipad);
        hash_update($ctx, $imei);
        $digest = hash_final($ctx, true);
        $ctx = hash_init("sha1");
        hash_update($ctx, $kopad);
        hash_update($ctx, $digest);
        $out = hash_final($ctx, true);
        return array_map("ord", str_explode($out));
    }
    private static function _MEPS_8digits($MEP, $mepNumber)
    {
        if ($mepNumber == 1) {
            return in_array($MEP, ["MEP-04626-001", "MEP-04626-002", "MEP-06259-003", "MEP-07321-002", "MEP-07723-001", "MEP-08589-001", "MEP-08881-001", "MEP-08882-001", "MEP-09292-001", "MEP-10073-001", "MEP-15326-002", "MEP-18601-001", "MEP-19877-001", "MEP-22793-001", "MEP-23361-001", "MEP-24660-001", "MEP-24660-003", "MEP-27501-003", "MEP-30218-001", "MEP-30218-002", "MEP-31845-001", "MEP-31845-002"]);
        }
        if ($mepNumber == 3) {
            return in_array($MEP, ["MEP-07321-002", "MEP-24660-003", "MEP-27501-003"]);
        }
        return false;
    }
    private static function _hash2code($hash, $MEP, $mepNumber)
    {
        $buf = "";
        if (self::_MEPS_8digits($MEP, $mepNumber)) {
            $size = 7;
        } else {
            $size = 15;
        }
        for ($i = 0; $i <= $size; $i++) {
            $buf .= $hash[$i] % 10;
        }
        return $buf;
    }
}

?>