<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

defined("DEFINE_MY_ACCESS") || exit("<h1 style=\"color: #C00; text-align: center;\"><strong>Restricted Access</strong></h1>");
class ServicePrice
{
    private $serviceid = NULL;
    private $systemcurrency = NULL;
    private $differentcurrency = NULL;
    private $currencyarr = NULL;
    private $autopricing = NULL;
    private $serviceapi = NULL;
    private $serviceapiid = NULL;
    private $serviceapitypeid = NULL;
    private $apicredit = NULL;
    private $apicredit_base = NULL;
    private $apicurrency = NULL;
    public $pricingfrom = NULL;
    public function __construct($serviceid)
    {
        $this->serviceid = $serviceid;
        $ServiceDetail = mysqli_fetch_assoc(dquery("select id,useasserver,API,autoapi,API_ID,API_TYPEID\n        from tbl_services_imei where id='" . $this->serviceid . "'"));
        if (!$ServiceDetail["id"]) {
            return false;
        }
        $this->autopricing = $ServiceDetail["autoapi"];
        $this->serviceapi = $ServiceDetail["API"];
        $this->serviceapiid = $ServiceDetail["API_ID"];
        $this->serviceapitypeid = $ServiceDetail["API_TYPEID"];
        $this->pricingfrom = "base";
        $CurrencyArr = [];
        $Currency = getAllCurrency("id");
        foreach ($Currency as $currencyid => $curdetail) {
            $CurrencyArr[$currencyid] = $curdetail["rate"];
        }
        $this->currencyarr = $CurrencyArr;
        if ($this->autopricing && $this->serviceapi && $this->serviceapiid) {
            $apiprice = mysqli_fetch_assoc(dquery("select credits from tbl_apiserversservices\n            where gateway='" . $this->serviceapi . "' and id='" . $this->serviceapiid . "'\n             and type_id='" . $this->serviceapitypeid . "'\n             and `type`='Tool'\n             and useasserver='" . $ServiceDetail["useasserver"] . "'"));
            $this->apicredit_base = $apiprice["credits"];
            $apicurrency = mysqli_fetch_assoc(dquery("select value from tbl_apiservers\n            where gateway='" . $this->serviceapi . "' and setting='currency'"));
            $CurrencyCode = getAllCurrency("code");
            $apicurrencyid = $CurrencyCode[$apicurrency["value"]]["id"];
            $this->apicurrency = $apicurrencyid;
            if ($this->apicurrency != $_SESSION["system_default_currency"]["id"]) {
                $this->apicredit = round($this->apicredit_base / $Currency[$this->apicurrency]["rate"], 3);
            } else {
                $this->apicredit = $this->apicredit_base;
            }
        }
        $this->differentcurrency = false;
        $this->systemcurrency = $_SESSION["system_default_currency"]["id"];
    }
    public function getResellersUserPrice($resellerid, $price, $servicetype, $increase, $increaseby)
    {
        $storeprice = mysqli_fetch_assoc(dquery("select * from tbl_store_pricing\n            where resellerid='" . $resellerid . "' and serviceid='" . $this->serviceid . "'\n            and servicetype='" . $servicetype . "'"));
        if ($storeprice["increaseby"] == "Percent") {
            $price = $price + round($price * $storeprice["increase"] / 100, 3);
        } else {
            if ($storeprice["increaseby"] == "Fixed") {
                $price = $price + $storeprice["increase"];
            } else {
                if ($increaseby == "Percent") {
                    $price = $price + round($price * $increase / 100, 3);
                } else {
                    if ($increaseby == "Fixed") {
                        $price = $price + $increase;
                    }
                }
            }
        }
        return $price;
    }
    public function getServicePricing($currencyid, $qnt = 1, $clientgroupid = "", $customerid = "")
    {
        if ($customerid) {
            $uq = mysqli_fetch_assoc(dquery("select price from tbl_discount_imei where user_id='" . $customerid . "'\n            and service_id='" . $this->serviceid . "'"));
            if (0 < strlen($uq["price"])) {
                $this->pricingfrom = "Users Custom";
                return $uq["price"];
            }
        }
        if ($this->autopricing && $this->apicredit) {
            $pricingqntid = $this->GetPricingQntIDAPI($qnt);
        } else {
            $pricingqntid = $this->GetPricingQntID($qnt);
        }
        if (!$clientgroupid) {
            $clientgroupid = "base";
        } else {
            $this->pricingfrom = "Client Group";
        }
        $PriceArr = $this->getServicePricingArr();
        return $PriceArr[$pricingqntid][$clientgroupid][$currencyid]["price"];
    }
    public function getAllPricingByClient($currencyid, $clientgroupid = "base")
    {
        $serviceArr = $this->getServicePricingArr();
        $Return = [];
        foreach ($serviceArr as $qntrangeid => $pricing) {
            $Return[$qntrangeid] = $serviceArr[$qntrangeid][$clientgroupid][$currencyid]["price"];
        }
        return $Return;
    }
    public function getServicePricingArr()
    {
        if ($this->autopricing && $this->apicredit) {
            return $this->getAutoServicePricingArr();
        }
        return $this->getManualServicePricingArr();
    }
    public function apiMargin($amount, $increase, $increaseby)
    {
        if ($increaseby == "Percentage") {
            $amount = $amount + round($amount * $increase / 100, 3);
        } else {
            if ($increaseby == "Fixed") {
                $amount = $amount + $increase;
            }
        }
        return $amount;
    }
    public function getAutoServicePricingArr()
    {
        $qc = dquery("select * from tbl_group_api_price \n            where service_id='" . $this->serviceid . "'");
        $GroupArr = [];
        $q = dquery("select id from tbl_client_group");
        while ($r = mysqli_fetch_assoc($q)) {
            $GroupArr[$r["id"]] = $r["id"];
        }
        array_push($GroupArr, "base", "retail");
        $PricingQntarr = [];
        while ($rc = mysqli_fetch_assoc($qc)) {
            $RETURN[$rc["pricingqntid"]][$rc["group_id"]][$this->systemcurrency]["price"] = $this->apiMargin($this->apicredit, $rc["price"], $rc["increaseby"]);
            $PricingQntarr[$rc["pricingqntid"]] = $rc["pricingqntid"];
        }
        $defaultautoprice = "";
        foreach ($GroupArr as $groupid) {
            if (!$RETURN[0][$groupid]) {
                $APIpricing = mysqli_fetch_assoc(dquery("select value from tbl_apiservers\nWHERE gateway='" . $this->serviceapi . "' and setting='priceincrease'"));
                if ($APIpricing["value"]) {
                    $defaultautoprice = json_decode($APIpricing["value"], true);
                    if ($defaultautoprice) {
                        foreach ($GroupArr as $groupid) {
                            if (!$RETURN[0][$groupid] && $defaultautoprice[$groupid]["price"] && $defaultautoprice[$groupid]["increaseby"]) {
                                $RETURN[0][$groupid][$this->systemcurrency]["price"] = $this->apiMargin($this->apicredit, $defaultautoprice[$groupid]["price"], $defaultautoprice[$groupid]["increaseby"]);
                                $PricingQntarr[0] = 0;
                            }
                        }
                    }
                    foreach ($PricingQntarr as $pricingqntid) {
                        foreach ($GroupArr as $groupid) {
                            foreach ($this->currencyarr as $currencyid => $currate) {
                                if (!$RETURN[$pricingqntid][$groupid][$currencyid]["price"]) {
                                    $baseprice = 0;
                                    if ($RETURN[$pricingqntid][$groupid][$this->systemcurrency]["price"]) {
                                        $baseprice = $RETURN[$pricingqntid][$groupid][$this->systemcurrency]["price"];
                                        $baseprice = round($baseprice * $currate, 3);
                                    } else {
                                        if ($RETURN[$pricingqntid]["base"][$currencyid]) {
                                            $baseprice = $RETURN[$pricingqntid]["base"][$currencyid]["price"];
                                        } else {
                                            $baseprice = $RETURN[$pricingqntid]["base"][$this->systemcurrency]["price"];
                                            $baseprice = round($baseprice * $currate, 3);
                                        }
                                    }
                                    $RETURN[$pricingqntid][$groupid][$currencyid]["price"] = $baseprice;
                                }
                            }
                        }
                    }
                    return $RETURN;
                }
            }
        }
    }
    public function getManualServicePricingArr()
    {
        $qc = dquery("select * from tbl_service_pricing \n            where serviceid='" . $this->serviceid . "'");
        $GroupArr = [];
        $q = dquery("select id from tbl_client_group");
        while ($r = mysqli_fetch_assoc($q)) {
            $GroupArr[$r["id"]] = $r["id"];
        }
        array_push($GroupArr, "base", "retail");
        $PricingQntarr = [];
        while ($rc = mysqli_fetch_assoc($qc)) {
            $RETURN[$rc["pricingqntid"]][$rc["groupid"]][$rc["currencyid"]]["price"] = $rc["price"];
            $PricingQntarr[$rc["pricingqntid"]] = $rc["pricingqntid"];
        }
        foreach ($PricingQntarr as $pricingqntid) {
            foreach ($GroupArr as $groupid) {
                foreach ($this->currencyarr as $currencyid => $currate) {
                    if (!$RETURN[$pricingqntid][$groupid][$currencyid]["price"]) {
                        $baseprice = 0;
                        if ($RETURN[$pricingqntid][$groupid][$this->systemcurrency]["price"]) {
                            $baseprice = $RETURN[$pricingqntid][$groupid][$this->systemcurrency]["price"];
                            $baseprice = round($baseprice * $currate, 3);
                        } else {
                            if ($RETURN[$pricingqntid]["base"][$currencyid]) {
                                $baseprice = $RETURN[$pricingqntid]["base"][$currencyid]["price"];
                            } else {
                                $baseprice = $RETURN[$pricingqntid]["base"][$this->systemcurrency]["price"];
                                $baseprice = round($baseprice * $currate, 3);
                            }
                        }
                        $RETURN[$pricingqntid][$groupid][$currencyid]["price"] = $baseprice;
                    }
                }
            }
        }
        return $RETURN;
    }
    public function GetPricingQntIDAPI($qnt)
    {
        $qp = mysqli_fetch_assoc(dquery("select pricingqntid from tbl_pricing_qnt\n      where pricingqntid in (select distinct(pricingqntid)\n      from tbl_group_api_price where service_id='" . $this->serviceid . "')\n      and `end`>='" . $qnt . "' and `start`<='" . $qnt . "' ORDER BY `end` asc limit 1"));
        if ($qp["pricingqntid"]) {
            return $qp["pricingqntid"];
        }
        return 0;
    }
    public function GetPricingQntID($qnt)
    {
        $qp = mysqli_fetch_assoc(dquery("select pricingqntid from tbl_pricing_qnt\n      where pricingqntid in (select distinct(pricingqntid)\n      from tbl_service_pricing where serviceid='" . $this->serviceid . "')\n      and end>='" . $qnt . "' and `start`<='" . $qnt . "' ORDER BY end asc limit 1"));
        if ($qp["pricingqntid"]) {
            return $qp["pricingqntid"];
        }
        return 0;
    }
    public function getServicePrice()
    {
    }
    public function GetPricingByClientGroup($clientgroupid)
    {
    }
}
function getOrdersIMEINew($status = "pending", $serviceId = "", $uid = "", $orderid = "", $verify = "", $md5 = true, $servicetype = false, $supplierid = "", $searchvalue = "")
{
    global $smarty;
    global $pagelimit;
    global $next;
    global $lng_languag;
    global $mysqli_errors;
    global $config;
    global $searchbulk;
    global $from;
    global $precision;
    global $to;
    $_WHERE = "WHERE";
    $where = "";
    include_once ROOTDIR . "/includes/customfield.fun.inc.php";
    if ($verify != "") {
        if ($verify == "ALL") {
            $where = " (`verified`='1' OR `verified`='2') AND ";
        } else {
            if ($verify == 1) {
                $where = " (`verified`='1') AND ";
            } else {
                if ($verify == 2) {
                    $where = " (`verified`='2') AND ";
                }
            }
        }
        $status = "replied";
    }
    if ($status == "accepted") {
        $where .= " (`user_can_c`='1' or `user_can_c`='8' )";
    } else {
        if ($status == "pending") {
            $where .= " (`user_can_c`='0' OR `user_can_c`='1' )";
        } else {
            if ($status == "available") {
                $where .= "`user_can_c`='4'";
            } else {
                if ($status == "rejected") {
                    $where .= "`user_can_c`='3'";
                } else {
                    if ($status == "replied") {
                        if ($verify != "") {
                            $where .= " (`user_can_c`='4' OR `user_can_c`='3')";
                        } else {
                            $where .= " (`user_can_c`='4' )";
                        }
                    } else {
                        if ($status == "all") {
                            $where .= " (`user_can_c`!=5 and  `user_can_c`!=6)";
                        }
                    }
                }
            }
        }
    }
    if ($uid) {
        $And = "AND (`user_id`='" . $uid . "')";
    }
    $FILTER = "ORDER BY `order_id` DESC";
    if ($searchvalue) {
        $ib = explode("\n", $searchvalue);
        foreach ($ib as $is) {
            if (trim($is)) {
                $tmsp = explode(",", $is);
                foreach ($tmsp as $bcs) {
                    if (trim($bcs)) {
                        $imeis[] = "'" . trim($bcs) . "'";
                    }
                }
            }
        }
        $FILTER = " ORDER BY FIELD(imei," . implode(",", $imeis) . ")";
        $filters = implode(",", $imeis);
        $where .= " and imei in (" . $filters . ")";
        $next = 0;
    }
    if ($orderid) {
        $orderid = descape($orderid);
        if ($md5) {
            if ($where != "") {
                $where .= " AND MD5(order_id)='" . $orderid . "'";
            } else {
                $where .= " MD5(order_id)='" . $orderid . "'";
            }
        } else {
            if ($where != "") {
                $where .= " AND order_id='" . $orderid . "'";
            } else {
                $where .= " order_id='" . $orderid . "'";
            }
        }
    }
    if ($serviceId) {
        $serviceId = descape($serviceId);
        if ($where != "") {
            $where .= " AND MD5(service_id)='" . $serviceId . "'";
        } else {
            $where .= "  MD5(service_id)='" . $serviceId . "'";
        }
    }
    if ($searchvalue) {
        $searchvalue = descape($searchvalue);
        if ($where != "") {
            $where .= " AND ( `order_id` LIKE '" . $searchvalue . "%' OR `imei` LIKE '" . $searchvalue . "%' OR `comments` LIKE '" . $searchvalue . "%' )";
        } else {
            $where .= " ( `order_id` LIKE '" . $searchvalue . "%' OR `imei` LIKE '" . $searchvalue . "%' OR `comments` LIKE '" . $searchvalue . "%' )";
        }
    }
    if ($searchbulk) {
        $searchvalueRes = [];
        $where = " 1=1 ";
        if ($searchvalue) {
            $searchvalue = explode("\\n", $searchvalue);
            foreach ($searchvalue as $k => $v) {
                if (trim(preg_replace("/[^0-9]/i", "", $v)) != "") {
                    $searchvalueRes[$k] = preg_replace("/[^0-9]/i", "", $v);
                }
            }
            $searchvalue = trim(implode(",", $searchvalueRes), ",");
            $where .= " AND imei in (" . $searchvalue . ")";
        }
        if ($from && $to) {
            if (deregi("/", $from)) {
                $myDateTime = DateTime::createFromFormat("d/m/Y", $from);
                $from = $myDateTime->format("Y-m-d");
                $myDateTime = DateTime::createFromFormat("d/m/Y", $to);
                $to = $myDateTime->format("Y-m-d");
            }
            $where .= " and (date between '" . $from . "' and '" . $to . "')";
        }
    }
    if ($servicetype) {
        if ($servicetype == 2) {
            $where .= " and `server`=1";
        } else {
            $where .= " and `server`=0";
        }
    }
    if ($supplierid) {
        $where .= " and reply_by_sup='" . $supplierid . "'";
    }
    $query = "SELECT order_id,imei,date,tbl_order_imei.time as time,note,\n    comments, tbl_order_imei.credit,reply_time,discount,user_can_c,reply,reply_time,\n    model_id,provider_id,network_id, verified,tbl_order_imei.mep,provider_c_id,\n    tbl_order_imei.PIN,tbl_order_imei.KBH,tbl_order_imei.PRD,tbl_order_imei.Type,\n    tbl_order_imei.Reference,tbl_order_imei.Locks,reply_date, encnum,\n    tbl_order_imei.SN ,tbl_order_imei.SecRO,apilogreferenceid,server,\n    tbl_order_imei.qnt, service_name as service,retail_name,\n    avgdeliverytime,usercan_cancel ,useasserver,verifiable,verificationdays \n    FROM `tbl_order_imei` LEFT JOIN tbl_services_imei\n    ON tbl_order_imei.service_id=tbl_services_imei.id " . $_WHERE . " " . $where . " " . $And . " \n    " . $FILTER . " LIMIT " . $next . "," . $pagelimit;
    if ($mysqli_errors) {
        echo $query . "<hr />";
    }
    generatePaginate($query);
    $result = dquery($query);
    $tot_result = mysqli_num_rows($result);
    while ($row = mysqli_fetch_assoc($result)) {
        if ($config["tooltip"]) {
            $_orderDtl[$row["order_id"]]["order_id"] = "<a href='vieworder.php?action=imei&id=" . $row["order_id"] . "'  class='jTip' id='orderid_" . $row["order_id"] . "' name='" . $lng_languag["orderid"] . " #" . $row["order_id"] . " '>" . $row["order_id"] . "</a>";
        } else {
            $_orderDtl[$row["order_id"]]["order_id"] = "<a  href='javascript:void(0)' onclick=\"window.open('vieworder.php?action=imei&id=" . $row["order_id"] . "', 'vieworder','width=600,height=700,menubar=yes,status=yes')\" >" . $row["order_id"] . "</a>";
        }
        $_orderDtl[$row["order_id"]]["service"] = $row["service"];
        if (CLIENT && $row["retail_name"] && $row["retail_shop"]) {
            $_orderDtl[$row["order_id"]]["service"] = $row["retail_name"];
        }
        $_orderDtl[$row["order_id"]]["credit"] = round($row["credit"], $precision);
        $_orderDtl[$row["order_id"]]["discount"] = round($row["discount"], $precision);
        $_orderDtl[$row["order_id"]]["time"] = $row["time"];
        $_orderDtl[$row["order_id"]]["times"] = time();
        $_orderDtl[$row["order_id"]]["date"] = $row["date"];
        $_orderDtl[$row["order_id"]]["avgdeliverytime"] = $row["time"] + $row["avgdeliverytime"];
        $_orderDtl[$row["order_id"]]["service_id"] = $row["service_id"];
        $_orderDtl[$row["order_id"]]["imei"] = $row["imei"];
        $_orderDtl[$row["order_id"]]["placedfrom"] = $row["placedfrom"];
        $_orderDtl[$row["order_id"]]["qnt"] = $row["qnt"];
        $_orderDtl[$row["order_id"]]["server"] = $row["server"];
        $_orderDtl[$row["order_id"]]["verified"] = $row["verified"];
        $_orderDtl[$row["order_id"]]["apilogreferenceid"] = $row["apilogreferenceid"];
        $_orderDtl[$row["order_id"]]["retail_shop"] = $row["retail_shop"];
        $_orderDtl[$row["order_id"]]["pin"] = $row["PIN"];
        $_orderDtl[$row["order_id"]]["user_can_c"] = $row["user_can_c"] == 8 ? 1 : $row["user_can_c"];
        $_orderDtl[$row["order_id"]]["kbh"] = $row["KBH"];
        $_orderDtl[$row["order_id"]]["prd"] = $row["PRD"];
        $_orderDtl[$row["order_id"]]["sn"] = $row["SN"];
        $_orderDtl[$row["order_id"]]["secro"] = $row["SecRO"];
        $_orderDtl[$row["order_id"]]["ebay"] = $row["ebay"];
        $_orderDtl[$row["order_id"]]["type"] = $row["Type"];
        if ($config["encryptedorderid"]) {
            $_orderDtl[$row["order_id"]]["encnum"] = $row["encnum"] ? $row["encnum"] : $row["order_id"];
        } else {
            $_orderDtl[$row["order_id"]]["encnum"] = $row["order_id"];
        }
        $_orderDtl[$row["order_id"]]["response_email"] = $row["response_email"];
        $_orderDtl[$row["order_id"]]["reference"] = $row["Reference"];
        $_orderDtl[$row["order_id"]]["locks"] = $row["Locks"];
        $_orderDtl[$row["order_id"]]["reply_by_sup"] = $row["reply_by_sup"];
        $_orderDtl[$row["order_id"]]["reply_by"]["adminid"] = $row["reply_by_admin"];
        $_orderDtl[$row["order_id"]]["reply_by"]["supplierid"] = $row["reply_by_sup"];
        $_orderDtl[$row["order_id"]]["action"] = NULL;
        $_orderDtl[$row["order_id"]]["reply_time"] = date("Y-m-d h:i A", $row["reply_time"]);
        $_orderDtl[$row["order_id"]]["reply_times"] = $row["reply_time"];
        $_orderDtl[$row["order_id"]]["customfields"] = getCustomFields("serviceimei", $row["service_id"], $row["order_id"], "on");
        if ($row["user_can_c"] == 0) {
            $_orderDtl[$row["order_id"]]["reply"] = $lng_languag["pending"];
            $_orderDtl[$row["order_id"]]["status"] = "<span class='textblue'>" . $lng_languag["waitingaction"] . "</span>";
            $_orderDtl[$row["order_id"]]["status_code"] = "0";
            $time_diff = ceil((time() - $row["time"]) / 60);
            if ($row["usercan_cancel"] && $time_diff <= $config["usercan_cancel_order_within_min"] && $config["config_self_cancel"]) {
                if ($row["useasserver"]) {
                    $_orderDtl[$row["order_id"]]["action"] = "<form method='post' action='orders.php?action=newserver&status=all'>\n                <input type='hidden' name='cancelorderid' value='" . md5($row["order_id"]) . "'>\n                <input type='submit' name='cancel' class='btn btn-light btncancelorder link' value='" . $lng_languag["cancel"] . "'></form>";
                } else {
                    $_orderDtl[$row["order_id"]]["action"] = "<form method='post' action='orders.php?action=imei&status=all'>\n                <input type='hidden' name='cancelorderid' value='" . md5($row["order_id"]) . "'>\n                <input type='submit' name='cancel' class='btn btn-light btncancelorder link' value='" . $lng_languag["cancel"] . "'></form>";
                }
            } else {
                $_orderDtl[$row["order_id"]]["action"] = $lng_languag["locked"];
            }
        } else {
            if ($row["user_can_c"] == 1 || $row["user_can_c"] == 8) {
                $_orderDtl[$row["order_id"]]["reply"] = $lng_languag["inprocess"];
                $_orderDtl[$row["order_id"]]["status"] = "<span class='textyellow'>" . $lng_languag["inprocess"] . "</span>";
                $_orderDtl[$row["order_id"]]["status_code"] = "1";
                $_orderDtl[$row["order_id"]]["action"] = $lng_languag["locked"];
            } else {
                $_orderDtl[$row["order_id"]]["reply"] = $row["reply"];
                if ($row["user_can_c"] == 3) {
                    $_orderDtl[$row["order_id"]]["status"] = "<span class='textred'>" . $lng_languag["rejected"] . "</span>";
                    $_orderDtl[$row["order_id"]]["status_code"] = "3";
                } else {
                    if ($row["user_can_c"] == 4) {
                        $_orderDtl[$row["order_id"]]["status"] = "<span class='textgreen'>" . $lng_languag["success"] . "</span>";
                        $_orderDtl[$row["order_id"]]["status_code"] = "4";
                    }
                }
                if ($row["verified"] == 0 && $row["verifiable"] && $row["user_can_c"] == 4) {
                    $time_diff = round((time() - $row["reply_time"]) / 60);
                    if (0 < $row["verificationdays"]) {
                        $config["usercan_verify_order_within_min"] = $row["verificationdays"] * 24 * 60;
                    }
                    if ($time_diff <= $config["usercan_verify_order_within_min"] || $config["usercan_verify_order_within_min"] == "") {
                        if ($servicetype == 2) {
                            $_orderDtl[$row["order_id"]]["actionnew"] = "<a data-target=\"#modalverification\" data-toggle=\"modal\" \n             href=\"widget/verify.php?action=newserver&id=" . md5($row["order_id"]) . "\">" . $lng_languag["verify"] . "</a>";
                        } else {
                            $differtime = $config["usercan_verify_order_within_min"] - $time_diff;
                            $timeday = MintoDays($differtime);
                            $_orderDtl[$row["order_id"]]["actionnew"] = "<a data-target=\"#modalverification\" data-toggle=\"modal\" \n             href=\"widget/verify.php?action=imei&id=" . md5($row["order_id"]) . "\">" . $timeday . " to " . $lng_languag["verify"] . "</a>";
                        }
                        $_orderDtl[$row["order_id"]]["action"] = "<form method='post' action='orders.php?" . $_SERVER["QUERY_STRING"] . "'>\n        <input type='hidden' name='verification' value='" . md5($row["order_id"]) . "'>\n        <input type='submit' name='cancel' class='btncancelorder link' value='" . $lng_languag["verify"] . "'></form>";
                    } else {
                        $_orderDtl[$row["order_id"]]["action"] = "-";
                    }
                } else {
                    if ($row["verified"] == 1) {
                        $_orderDtl[$row["order_id"]]["action"] = $lng_languag["inprocess"];
                    } else {
                        if ($row["verified"] == 2) {
                            $_orderDtl[$row["order_id"]]["action"] = $lng_languag["verified"];
                        } else {
                            $_orderDtl[$row["order_id"]]["action"] = "-";
                        }
                    }
                }
            }
        }
        if ($status == "pending") {
            $_orderDtl[$row["order_id"]]["cancel"] = "<a href=''>" . $lng_languag["cancel"] . "</a>";
        }
        if ($orderid) {
            foreach ($row as $key => $alldetail) {
                $_orderDtl[md5($row["order_id"])]["allfield"][$key] = $alldetail;
            }
        }
    }
    return $_orderDtl;
}
function getOrdersIMEI($status = "pending", $serviceId = "", $uid = "", $orderid = "", $verify = "", $md5 = true, $servicetype = false, $supplierid = "", $searchvalue = "", $server = "", $originalorderid = "")
{
    global $smarty;
    global $pagelimit;
    global $next;
    global $lng_languag;
    global $mysqli_errors;
    global $config;
    global $searchbulk;
    global $from;
    global $precision;
    global $to;
    $_WHERE = "WHERE";
    $where = "";
    if ($verify != "") {
        if ($verify == "ALL") {
            $where = " (`verified`='1' OR `verified`='2') AND ";
        } else {
            if ($verify == 1) {
                $where = " (`verified`='1') AND ";
            } else {
                if ($verify == 2) {
                    $where = " (`verified`='2') AND ";
                }
            }
        }
        $status = "replied";
    }
    if ($status == "accepted") {
        $where .= " (`user_can_c`='1' or `user_can_c`='8' )";
    } else {
        if ($status == "pending") {
            $where .= " (`user_can_c`='0' OR `user_can_c`='1' )";
        } else {
            if ($status == "available") {
                $where .= "`user_can_c`='4'";
            } else {
                if ($status == "rejected") {
                    $where .= "`user_can_c`='3'";
                } else {
                    if ($status == "replied") {
                        if ($verify != "") {
                            $where .= " (`user_can_c`='4' OR `user_can_c`='3')";
                        } else {
                            $where .= " (`user_can_c`='4' )";
                        }
                    } else {
                        if ($status == "all") {
                            $where .= " (`user_can_c`!=5 and  `user_can_c`!=6)";
                        }
                    }
                }
            }
        }
    }
    if ($uid) {
        $And = "AND (`user_id`='" . $uid . "')";
    }
    if ($originalorderid) {
        $originalorderid = descape($originalorderid);
        $where .= " (order_id)='" . $originalorderid . "'";
    }
    if ($orderid) {
        $orderid = descape($orderid);
        if ($md5) {
            if ($where != "") {
                $where .= " AND MD5(order_id)='" . $orderid . "'";
            } else {
                $where .= " MD5(order_id)='" . $orderid . "'";
            }
        } else {
            if ($where != "") {
                $where .= " AND order_id='" . $orderid . "'";
            } else {
                $where .= " order_id='" . $orderid . "'";
            }
        }
        $adminid = mysqli_fetch_assoc(dquery("select id from tbl_admin \nwhere group_id=1 limit 1"));
    }
    if ($serviceId) {
        $serviceId = descape($serviceId);
        if ($where != "") {
            $where .= " AND MD5(service_id)='" . $serviceId . "'";
        } else {
            $where .= "  MD5(service_id)='" . $serviceId . "'";
        }
    }
    $FILTER = "ORDER BY `order_id` DESC";
    if ($searchvalue) {
        $ib = explode("\n", trim($searchvalue));
        $searchvalue = descape($searchvalue);
        if ($where != "") {
            $where .= " AND ( `order_id` LIKE '" . $searchvalue . "%' OR `imei` LIKE '" . $searchvalue . "%' OR `comments` LIKE '" . $searchvalue . "%' )";
        } else {
            $where .= " ( `order_id` LIKE '" . $searchvalue . "%' OR `imei` LIKE '" . $searchvalue . "%' OR `comments` LIKE '" . $searchvalue . "%' )";
        }
        foreach ($ib as $is) {
            if (trim($is)) {
                $tmsp = explode(",", $is);
                foreach ($tmsp as $bcs) {
                    if (trim($bcs)) {
                        $imeis[] = "'" . trim($bcs) . "'";
                    }
                }
            }
        }
        $FILTER = " ORDER BY FIELD(imei," . implode(",", $imeis) . ")";
        $next = 0;
    }
    if ($searchbulk) {
        $where = " 1=1 ";
        if ($searchvalue) {
            $searchvalue = explode("\\r\\n", $searchvalue);
            $searchvaluef = [];
            foreach ($searchvalue as $k => $v) {
                if (preg_replace("/[^0-9a-zA-Z#]/i", "", $v)) {
                    $searchvaluef[$k] = trim(preg_replace("/[^0-9a-zA-Z#]/i", "", $v));
                }
            }
            $searchvalue = implode("','", $searchvaluef);
            $where .= " AND imei in ('" . $searchvalue . "')";
        }
        if ($from && $to) {
            if (deregi("/", $from)) {
                $myDateTime = DateTime::createFromFormat("d/m/Y", $from);
                $from = $myDateTime->format("Y-m-d");
                $myDateTime = DateTime::createFromFormat("d/m/Y", $to);
                $to = $myDateTime->format("Y-m-d");
            }
            $where .= " and (date between '" . $from . "' and '" . $to . "')";
        }
    }
    if ($servicetype) {
        if ($servicetype) {
            $where .= " and `server`='" . $servicetype . "'";
        } else {
            $where .= " and `server`=0";
        }
    } else {
        if ($server == "0" || $server == 1 || $server == 2) {
            $where .= " and `server`='" . $server . "'";
        }
    }
    if ($supplierid) {
        $where .= " and reply_by_sup='" . $supplierid . "'";
    }
    if (CLIENT) {
        $query = "SELECT *,\n    (SELECT GROUP_CONCAT(concat(fieldname,'=>',value) separator '<br />') from tbl_customfieldsvalues\n    where servicetype=IF(tbl_order_imei.server=2,'remote',IF(tbl_order_imei.server=1,'server','imei'))\n    and relid=tbl_order_imei.order_id) as field\n     FROM `tbl_order_imei` " . $_WHERE . " " . $where . " " . $And . " \n        " . $FILTER . " LIMIT " . $next . "," . $pagelimit;
    } else {
        $query = "SELECT *,IF(\n    (select value from tbl_apiservers where gateway=`ORDERAPI` and setting='customname')!='',\n    concat((select value from tbl_apiservers where gateway=`ORDERAPI` and setting='customname'),' [',\n    (select value from tbl_apiservers where gateway=`ORDERAPI` and setting='name'),']'\n    ),(select value from tbl_apiservers where gateway=`ORDERAPI` and setting='name') \n    ) as apiname,\n    (SELECT GROUP_CONCAT(concat(fieldname,'=>',value) separator '<br />') from tbl_customfieldsvalues\n    where servicetype=IF(tbl_order_imei.server=2,'remote',IF(tbl_order_imei.server=1,'server','imei'))\n    and relid=tbl_order_imei.order_id) as field\n     FROM `tbl_order_imei` " . $_WHERE . " " . $where . " " . $And . " \n        " . $FILTER . " LIMIT " . $next . "," . $pagelimit;
    }
    if ($mysqli_errors) {
        echo $query . "<hr />";
    }
    generatePaginate($query);
    $result = dquery($query);
    $tot_result = mysqli_num_rows($result);
    while ($row = mysqli_fetch_assoc($result)) {
        if ($config["tooltip"]) {
            $_orderDtl[$row["order_id"]]["order_id"] = "<a href='" . _url("vieworder/action/imei/id/" . $row[order_id]) . "'  class='jTip' id='orderid_" . $row["order_id"] . "' name='" . $lng_languag["orderid"] . " #" . $row["order_id"] . " ' >" . $row["order_id"] . "</a>";
        } else {
            $_orderDtl[$row["order_id"]]["order_id"] = "<a  HREF='javascript:void(0)' onclick=\"window.open('" . _url("vieworder/action/imei/id/" . $row[order_id]) . "', 'vieworder','width=600,height=700,menubar=yes,status=yes')\" >" . $row["order_id"] . "</a>";
        }
        $service = mysqli_fetch_assoc(dquery("SELECT * FROM `tbl_services_imei` WHERE `id`=" . $row["service_id"]));
        $_orderDtl[$row["order_id"]]["service"] = $service["service_name"];
        if (CLIENT && $service["retail_name"] && $row["retail_shop"]) {
            $_orderDtl[$row["order_id"]]["service"] = $service["retail_name"];
        }
        $user = mysqli_fetch_assoc(dquery("SELECT `username`,(SELECT prefix FROM tbl_currencies WHERE id=tblUsers.default_currency) as cur\n        ,(SELECT code FROM tbl_currencies WHERE id=tblUsers.default_currency) as code\n             FROM `tblUsers` WHERE `id`=" . $row["user_id"]));
        $_orderDtl[$row["order_id"]]["username"] = $user["username"];
        $_orderDtl[$row["order_id"]]["prefix"] = $user["cur"];
        $_orderDtl[$row["order_id"]]["code"] = $user["code"];
        $_orderDtl[$row["order_id"]]["pricefrom"] = $row["pricefrom"];
        $_orderDtl[$row["order_id"]]["points"] = $row["points"];
        $_orderDtl[$row["order_id"]]["acceptedtime"] = $row["acceptedtime"];
        $_orderDtl[$row["order_id"]]["service_details"] = $service;
        $_orderDtl[$row["order_id"]]["credit"] = round($row["credit"], $precision);
        $_orderDtl[$row["order_id"]]["display_credit"] = formatCurrency(round($row["credit"] - $row["discount"], $precision), "", "", 1);
        $_orderDtl[$row["order_id"]]["discount"] = round($row["discount"], $precision);
        $_orderDtl[$row["order_id"]]["time"] = $row["time"];
        $_orderDtl[$row["order_id"]]["apierror"] = $row["apierror"];
        $_orderDtl[$row["order_id"]]["times"] = time();
        $_orderDtl[$row["order_id"]]["field"] = $row["field"];
        $_orderDtl[$row["order_id"]]["date"] = $row["date"];
        $_orderDtl[$row["order_id"]]["avgdeliverytime"] = $row["time"] + $service["avgdeliverytime"];
        $_orderDtl[$row["order_id"]]["service_id"] = $row["service_id"];
        $_orderDtl[$row["order_id"]]["imei"] = $row["imei"];
        $_orderDtl[$row["order_id"]]["apiname"] = $row["apiname"];
        $_orderDtl[$row["order_id"]]["placedfrom"] = $row["ex_oid"] ? "API" : $row["placedfrom"];
        $_orderDtl[$row["order_id"]]["qnt"] = $row["qnt"];
        $_orderDtl[$row["order_id"]]["server"] = $row["server"];
        $_orderDtl[$row["order_id"]]["reply_time"] = date("Y-m-d h:i A", $row["reply_time"]);
        $_orderDtl[$row["order_id"]]["reply_times"] = $row["reply_time"];
        $_orderDtl[$row["order_id"]]["verified"] = $row["verified"];
        $_orderDtl[$row["order_id"]]["apilogreferenceid"] = $row["ex_oid"];
        if ($row["model_id"]) {
            $serv = mysqli_fetch_assoc(dquery("SELECT `Name`,`B_ID` FROM `tbl_mobile` WHERE `ID`='" . $row["model_id"] . "' "));
            $_orderDtl[$row["order_id"]]["model_id"] = $row["model_id"];
            $_orderDtl[$row["order_id"]]["model"] = $serv["Name"];
            $serv1 = mysqli_fetch_assoc(dquery("SELECT `Name` FROM `tbl_model_brand` WHERE `ID`='" . $serv["B_ID"] . "' "));
            $_orderDtl[$row["order_id"]]["brand_id"] = $serv["B_ID"];
            $_orderDtl[$row["order_id"]]["brand"] = $serv1["Name"];
        }
        if ($row["provider_id"]) {
            $serv = mysqli_fetch_assoc(dquery("SELECT `Name` FROM `tbl_provider` WHERE `ID`='" . $row["provider_id"] . "' "));
            $_orderDtl[$row["order_id"]]["provider_id"] = $row["provider_id"];
            $_orderDtl[$row["order_id"]]["provider"] = $serv["Name"];
        }
        if ($row["provider_c_id"]) {
            $serv = mysqli_fetch_assoc(dquery("SELECT `Name`,`ID` FROM `tbl_provider_country` WHERE `ID`='" . $row["provider_c_id"] . "' "));
            $_orderDtl[$row["order_id"]]["providercountry_id"] = $serv["ID"];
            $_orderDtl[$row["order_id"]]["providercountry"] = $serv["Name"];
        }
        if ($row["mep"]) {
            $serv = mysqli_fetch_assoc(dquery("SELECT `mep` FROM \n            `tbl_mep` WHERE `id`='" . $row["mep"] . "' "));
            $_orderDtl[$row["order_id"]]["mep"] = $serv["mep"];
            $_orderDtl[$row["order_id"]]["mep_id"] = $row["mep"];
        }
        $_orderDtl[$row["order_id"]]["retail_shop"] = $row["retail_shop"];
        $_orderDtl[$row["order_id"]]["pin"] = $row["PIN"];
        $_orderDtl[$row["order_id"]]["user_can_c"] = $row["user_can_c"] == 8 ? 1 : $row["user_can_c"];
        $_orderDtl[$row["order_id"]]["kbh"] = $row["KBH"];
        $_orderDtl[$row["order_id"]]["prd"] = $row["PRD"];
        $_orderDtl[$row["order_id"]]["sn"] = $row["SN"];
        $_orderDtl[$row["order_id"]]["secro"] = $row["SecRO"];
        $_orderDtl[$row["order_id"]]["seo"] = _url("widget/vieworder/imei/id/" . $row["order_id"]);
        $_orderDtl[$row["order_id"]]["ebay"] = $row["ebay"];
        $_orderDtl[$row["order_id"]]["type"] = $row["Type"];
        if ($config["encryptedorderid"]) {
            $_orderDtl[$row["order_id"]]["encnum"] = $row["encnum"] ? $row["encnum"] : $row["order_id"];
        } else {
            $_orderDtl[$row["order_id"]]["encnum"] = $row["order_id"];
        }
        $_orderDtl[$row["order_id"]]["response_email"] = $row["response_email"];
        $_orderDtl[$row["order_id"]]["reference"] = $row["Reference"];
        $_orderDtl[$row["order_id"]]["locks"] = $row["Locks"];
        $_orderDtl[$row["order_id"]]["comments"] = $row["comments"];
        $_orderDtl[$row["order_id"]]["reply_by_sup"] = $row["reply_by_sup"];
        $_orderDtl[$row["order_id"]]["reply_by"]["adminid"] = $row["reply_by_admin"];
        $_orderDtl[$row["order_id"]]["reply_by"]["supplierid"] = $row["reply_by_sup"];
        $_orderDtl[$row["order_id"]]["reply_by"]["verfiedadminid"] = $row["verified_by_admin"];
        $_orderDtl[$row["order_id"]]["reply_by"]["verfiedsupid"] = $row["verified_by_sup"];
        if ($adminid["id"] && $orderid && !$row["reply_by_admin"]) {
            $_orderDtl[$row["order_id"]]["reply_by"]["adminid"] = $adminid["id"];
        }
        $_orderDtl[$row["order_id"]]["action"] = NULL;
        include_once ROOTDIR . "/includes/customfield.fun.inc.php";
        $_orderDtl[$row["order_id"]]["customfields"] = getCustomFields("serviceimei", $service["id"], $row["order_id"], "on");
        if ($row["user_can_c"] == 0) {
            $_orderDtl[$row["order_id"]]["reply"] = $lng_languag["pending"];
            $_orderDtl[$row["order_id"]]["status"] = "<span class='textblue'>" . $lng_languag["waitingaction"] . "</span>";
            $_orderDtl[$row["order_id"]]["status_code"] = "0";
            $time_diff = ceil((time() - $row["time"]) / 60);
            if ($service["usercan_cancel"] && $time_diff <= $config["usercan_cancel_order_within_min"] && $config["config_self_cancel"]) {
                if ($service["useasserver"]) {
                    $_orderDtl[$row["order_id"]]["action"] = "<form method='post' action='" . _url("orders/action/newserver/status/all") . "'>\n                    <input type='hidden' name='cancelorderid' value='" . md5($row["order_id"]) . "'>\n                    <input type='submit' name='cancel' class='btn btn-light btncancelorder link' value='" . $lng_languag["cancel"] . "'></form>";
                } else {
                    $_orderDtl[$row["order_id"]]["action"] = "<form method='post' action='" . _url("orders/action/imei/status/all") . "'>\n                    <input type='hidden' name='cancelorderid' value='" . md5($row["order_id"]) . "'>\n                    <input type='submit' name='cancel' class='btn btn-light btncancelorder link' value='" . $lng_languag["cancel"] . "'></form>";
                }
            } else {
                $_orderDtl[$row["order_id"]]["action"] = $lng_languag["locked"];
            }
        } else {
            if ($row["user_can_c"] == 1 || $row["user_can_c"] == 8) {
                $_orderDtl[$row["order_id"]]["reply"] = $lng_languag["inprocess"];
                $_orderDtl[$row["order_id"]]["status"] = "<span class='textyellow'>" . $lng_languag["inprocess"] . "</span>";
                $_orderDtl[$row["order_id"]]["status_code"] = "1";
                $_orderDtl[$row["order_id"]]["action"] = $lng_languag["locked"];
            } else {
                $_orderDtl[$row["order_id"]]["reply"] = $row["reply"];
                if ($row["user_can_c"] == 3) {
                    $_orderDtl[$row["order_id"]]["status"] = "<span class='textred'>" . $lng_languag["rejected"] . "</span>";
                    $_orderDtl[$row["order_id"]]["status_code"] = "3";
                } else {
                    if ($row["user_can_c"] == 4) {
                        $_orderDtl[$row["order_id"]]["status"] = "<span class='textgreen'>" . $lng_languag["success"] . "</span>";
                        $_orderDtl[$row["order_id"]]["status_code"] = "4";
                    }
                }
                if ($row["verified"] == 0 && $service["verifiable"] && $row["user_can_c"] == 4) {
                    $time_diff = round((time() - $row["reply_time"]) / 60);
                    if (0 < $service["verificationdays"]) {
                        $config["usercan_verify_order_within_min"] = $service["verificationdays"] * 24 * 60;
                    }
                    if ($time_diff <= $config["usercan_verify_order_within_min"] || $config["usercan_verify_order_within_min"] == "") {
                        if (0 < $servicetype) {
                            $_orderDtl[$row["order_id"]]["actionnew"] = "<a data-target=\"#modalverification\" data-toggle=\"modal\" \n             href=\"" . _url("widget/verify/action/newserver/id/" . md5($row["order_id"]) . "") . "\">" . $lng_languag["verify"] . "</a>";
                        } else {
                            $differtime = $config["usercan_verify_order_within_min"] - $time_diff;
                            $timeday = MintoDays($differtime);
                            $_orderDtl[$row["order_id"]]["actionnew"] = "<a data-target=\"#modalverification\" data-toggle=\"modal\" \n             href=\"" . _url("widget/verify/action/imei/id/" . md5($row["order_id"]) . "") . "\">" . $timeday . " to " . $lng_languag["verify"] . "</a>";
                        }
                        $_orderDtl[$row["order_id"]]["action"] = "<form method='post' action='" . _url("orders/?" . $_SERVER[QUERY_STRING]) . "'>\n        <input type='hidden' name='verification' value='" . md5($row["order_id"]) . "'>\n        <input type='submit' name='cancel' class='btncancelorder link' value='" . $lng_languag["verify"] . "'></form>";
                    } else {
                        $_orderDtl[$row["order_id"]]["action"] = "-";
                    }
                } else {
                    if ($row["verified"] == 1) {
                        $_orderDtl[$row["order_id"]]["action"] = $lng_languag["inprocess"];
                    } else {
                        if ($row["verified"] == 2) {
                            $_orderDtl[$row["order_id"]]["action"] = $lng_languag["verified"];
                        } else {
                            $_orderDtl[$row["order_id"]]["action"] = "-";
                        }
                    }
                }
            }
        }
        if ($status == "pending") {
            $_orderDtl[$row["order_id"]]["cancel"] = "<a href=''>" . $lng_languag["cancel"] . "</a>";
        }
        if ($orderid) {
            foreach ($row as $key => $alldetail) {
                if (!$md5) {
                    $_orderDtl[md5($row["order_id"])]["allfield"][$key] = $alldetail;
                }
            }
        }
    }
    return $_orderDtl;
}
function changeUserDiscount($sid, $curprice, $newprice, $changed, $remove, $REM, $update = "")
{
    global $precision;
    $UserArry = [];
    $c = mysqli_fetch_assoc(dquery("SELECT `id`,`code` FROM \n    `tbl_currencies` WHERE `default`='1'"));
    $sql = dquery("select id,default_currency  from tblUsers");
    while ($row = mysqli_fetch_assoc($sql)) {
        $diff = $newprice - ($curprice - getDiscountIMEI($sid, $row["id"]));
        if ($c["id"] == $row["default_currency"]) {
            if ($REM == 1) {
                if ($diff < 0) {
                    dquery("delete from tbl_discount_imei\n                     where user_id='" . $row["id"] . "' and service_id='" . $sid . "'");
                    $UserArry[] = $row["id"];
                } else {
                    $diffs = $newprice - $curprice;
                    dquery("update tbl_discount_imei set \n                    discount=round((discount+" . $diffs . ")," . $precision . "),price='" . $newprice . "' where \n    \t\t\t\tuser_id='" . $row["id"] . "' and service_id='" . $sid . "'");
                    $UserArry[] = $row["id"];
                }
            } else {
                if ($update) {
                    $diffs = $newprice - $curprice;
                    dquery("update tbl_discount_imei set \n                discount=(discount+" . $diffs . "),price='" . $newprice . "' where \n\t\t\t\tuser_id='" . $row["id"] . "' and service_id='" . $sid . "'");
                } else {
                    if (!$update) {
                        $diffs = $newprice - $curprice;
                        dquery("update tbl_discount_imei set \n                discount=round((discount+" . $diffs . ")," . $precision . "),price='" . $newprice . "' where \n\t\t\t\tuser_id='" . $row["id"] . "' and service_id='" . $sid . "'");
                    }
                }
            }
        } else {
            if (!($cur = getIMEIPrice($sid, $row["default_currency"]))) {
                $cur = convertCurrency($curprice, $c["id"], $row["default_currency"]);
                if ($changed[$row["default_currency"]]) {
                    $new = $changed[$row["default_currency"]];
                } else {
                    $new = convertCurrency($newprice, $c["id"], $row["default_currency"]);
                }
                $diff2 = $new - $cur;
                if ($REM == 1) {
                    if (dquery("delete from tbl_discount_imei where user_id='" . $row["id"] . "' and service_id='" . $sid . "'\n\t\t    \t\tand " . $diff2 . "<1")) {
                        $UserArry[] = $row["id"];
                    }
                } else {
                    if (dquery("update tbl_discount_imei set discount=(discount+" . $diff2 . ")\n                    , price='" . $newprice . "'\n\t            \twhere user_id='" . $row["id"] . "' and service_id='" . $sid . "'")) {
                        $UserArry[] = $row["id"];
                    }
                }
            } else {
                if ($changed[$row["default_currency"]]) {
                    $cur = getIMEIPrice($sid, $row["default_currency"]);
                    $diff2 = $changed[$row["default_currency"]] - $cur;
                    if ($REM == 1) {
                        if (dquery("delete from tbl_discount_imei where user_id='" . $row["id"] . "' and service_id='" . $sid . "'\n\t\t\t    \t\tand " . $diff2 . "<1")) {
                            $UserArry[] = $row["id"];
                        }
                    } else {
                        if (dquery("update tbl_discount_imei set discount=(discount+" . $diff2 . "),price='" . $newprice . "'\n\t            \t\twhere user_id='" . $row["id"] . "' and service_id='" . $sid . "'")) {
                            $UserArry[] = $row["id"];
                        }
                    }
                } else {
                    if ($remove[$row["default_currency"]]) {
                        $cur = getIMEIPrice($sid, $row["default_currency"]);
                        $diff2 = convertCurrency($newprice, $c["id"], $row["default_currency"]) - $cur;
                        if ($REM == 1) {
                            if (dquery("delete from tbl_discount_imei \n                        where user_id='" . $row["id"] . "' and service_id='" . $sid . "'\n\t\t\t    \t\tand " . $diff2 . "<1")) {
                                $UserArry[] = $row["id"];
                            }
                        } else {
                            if (dquery("update tbl_discount_imei \n                        set discount=(discount+" . $diff2 . "),price='" . $newprice . "'\n\t            \t\twhere user_id='" . $row["id"] . "' and service_id='" . $sid . "'")) {
                                $UserArry[] = $row["id"];
                            }
                        }
                    }
                }
            }
        }
    }
    $Users = implode(",", $UserArry);
    dquery("update tblUsers set pricechange=1 \n    where id in (" . $Users . ")");
}
function getIMEISearchService($userid, $status = "", $isserver = false)
{
    $WHERE = "";
    if ($status == "pending") {
        $WHERE .= " ( user_can_c='0' OR user_can_c='1' ) ";
    } else {
        if ($status == "available") {
            $WHERE .= " ( user_can_c='4' ) ";
        } else {
            if ($status == "rejected") {
                $WHERE .= " ( user_can_c='3' ) ";
            } else {
                if ($status == "all") {
                    $WHERE .= " user_can_c<5 ";
                }
            }
        }
    }
    if ($isserver) {
        $WHERE .= " and `server`=" . $isserver;
    } else {
        $WHERE .= " and `server`=0";
    }
    $query = dquery("SELECT service_id, (SELECT service_name FROM \n    tbl_services_imei WHERE id = service_id ) AS service  FROM tbl_order_imei\n                 WHERE `user_id` = '" . $userid . "' AND " . $WHERE . " group by service_id ");
    while ($row = mysqli_fetch_assoc($query)) {
        if ($row["service"]) {
            $service[md5($row["service_id"])] = $row["service"];
        }
    }
    return $service;
}
function getIMEIServicePriceByUser($ServiceArray, $UserArray)
{
    global $db;
    $_ServiceID = $ServiceArray[id];
    $_ServiceCredit = $ServiceArray[credit];
    $_UserID = $UserArray[id];
    $_UserGroupID = $UserArray["client_group"];
    $UserDiscount = mysqli_fetch_assoc(dquery("select discount\n    from tbl_discount_imei where service_id='" . $_ServiceID . "' \n    and user_id='" . $_UserID . "'"));
    if ($UserDiscount[discount] != 0) {
        return $_ServiceCredit - $UserDiscount["discount"];
    }
    return getIMEIServicePriceByGroup($ServiceArray, $_UserGroupID);
}
function getIMEIServicePriceByGroup($ServiceArray, $UserGroupID)
{
    global $db;
}
function getIMEIServicePrice($ServiceArray, $UserArray = "")
{
    global $db;
    $_ServiceID = $ServiceArray["id"];
    $_ServiceCredit = $ServiceArray["credit"];
    if (is_array($UserArray)) {
        if ($UserArray["usertype"] != "" || $UserArray["default_currency"] != "" || $UserArray["client_group"] != "") {
            $User = mysqli_fetch_assoc(dquery("select client_group ,default_currency ,usertype\n            from tblUsers where id='" . $UserArray["id"] . "'"));
            $UserArray = $User;
        }
        $_UserTYpe = $UserArray["usertype"];
        if ($_UserTYpe == 0 || $_UserTYpe == 1) {
            if ($Price = getimeiservicepricebyuser($ServiceArray, $UserArray)) {
                return $Price;
            }
        }
    }
}
function getIMEIServicesNew($groupId = "", $serviceId = "", $uid = "", $updateclientdetails = false, $getallservices = false, $reselleruserid = "", $retail = false, $onhome = false, $hot = "", $userprofile = false, $edituser = false, $promotion = false, $limit = "", $sortby = "", $searchkey = "", $affiliate = false, $resellersproduct = false, $model = "", $brand = "", $productpage = false, $serverservice = false, $forstore = false, $orderqnt = "")
{
    global $config;
    global $mysqli_errors;
    global $storeowner;
    global $pagelimit;
    global $next;
    global $config;
    global $precision;
    if ($limit) {
        $newlimit = $limit;
    } else {
        $newlimit = $pagelimit;
    }
    $_Group = [];
    if ($groupId) {
        $_WHERE = "WHERE";
        if (stripos($groupId, ",") !== false) {
            $where = "`id` IN (" . $groupId . ")";
        } else {
            $where = "`id`='" . $groupId . "'";
        }
    }
    if (ADMIN == "1") {
        $gatewaycur = dquery("select distinct gateway,value\n        from tbl_apiservers where setting='currency'");
        while ($rg = mysqli_fetch_assoc($gatewaycur)) {
            $GatewayCurrency[$rg["gateway"]] = $rg["value"];
        }
        unset($gatewaycur);
    }
    if (!$uid && !isset($_SESSION["adminid"]) && !isset($_SESSION["CART"])) {
        $uid = $_SESSION["uid"];
    }
    if ($serviceId) {
        $where_service = " AND md5(id)='" . $serviceId . "' ";
    }
    if ($retail) {
        $retailpurchase = "AND retail=1";
    }
    if ($serverservice != 1 && $serviceId && mysqli_num_rows(dquery("select id from tbl_services_imei\n        where useasserver=1 and md5(id)='" . $serviceId . "'"))) {
        $serverservice = 1;
    }
    if ($serverservice != 2 && $serviceId && mysqli_num_rows(dquery("select id from tbl_services_imei\n        where useasserver=2 and md5(id)='" . $serviceId . "'"))) {
        $serverservice = 2;
    }
    if ($serverservice == 2) {
        $SERVICEFIELD = "remote_services";
        $ALLOWEFIEDL = "alow_remoteservices";
    } else {
        if ($serverservice == 1) {
            $SERVICEFIELD = "newserver_services";
            $ALLOWEFIEDL = "alow_serverlogservices";
        } else {
            $SERVICEFIELD = "imei_services";
            $ALLOWEFIEDL = "alow_imeiservices";
        }
    }
    $ActiveService = [];
    if (!$serviceId && !$uid) {
        $qs = dquery("select serviceid from tbl_service_status \n            where groupid='base' and status='1'");
        while ($rs = mysqli_fetch_assoc($qs)) {
            $ActiveService[$rs["serviceid"]] = $rs["serviceid"];
        }
    }
    if ($uid) {
        if ($updateclientdetails) {
            if (!function_exists(getClientsDetails)) {
                require_once ROOTDIR . "/includes/clients.fun.inc.php";
            }
            $_ClientsDetails = mysqli_fetch_assoc(dquery("select id,username,usertype,reseller_id,\n            client_group,imei_service_access,file_service_access,server_log_access,remote_services,alow_remoteservices,\n            default_currency,(select rate from tbl_currencies where id=default_currency) as rate,\n            imei_services,file_services,server_logs,newserver_services,(select a.client_group from tblUsers as a\n            where a.id=tblUsers.reseller_id) as resellergroup\n            from tblUsers where id='" . $uid . "'"));
            if (!$serviceId) {
                $ClientGroup = $_ClientsDetails["client_group"] ? $_ClientsDetails["client_group"] : "base";
                if (isset($_SESSION["uid"]) && $storeowner["id"]) {
                    $ClientGroup = $_ClientsDetails["resellergroup"] ? $_ClientsDetails["resellergroup"] : "base";
                }
                $qs = dquery("select serviceid from tbl_service_status \n                where groupid='" . $ClientGroup . "' and status='1'");
                while ($rs = mysqli_fetch_assoc($qs)) {
                    $ActiveService[$rs["serviceid"]] = $rs["serviceid"];
                }
            }
            $_ClientsDetails["currency"]["id"] = $_ClientsDetails["default_currency"];
            $_ClientsDetails["currency"]["rate"] = $_ClientsDetails["rate"];
            if ($_ClientsDetails["imei_service_access"] == 1 && $config["default_service_imei"]) {
                $_ClientsDetails["access"]["imeiservice"] = true;
                if (substr($_ClientsDetails["imei_services"], 0, 1) == ",") {
                    $data["imei_services"] = substr_replace($_ClientsDetails["imei_services"], "", 0, 1);
                }
                $_ClientsDetails["access"]["alow_imeiservices"] = $_ClientsDetails["imei_services"];
            }
            if ($_ClientsDetails["server_log_access"] == 1 && $config["default_service_server"]) {
                $_ClientsDetails["access"]["serverlogservice"] = true;
                if (substr($_ClientsDetails["newserver_services"], 0, 1) == ",") {
                    $_ClientsDetails["newserver_services"] = substr_replace($_ClientsDetails["newserver_services"], "", 0, 1);
                }
                $_ClientsDetails["access"]["alow_serverlogservices"] = $_ClientsDetails["newserver_services"];
            }
            if ($_ClientsDetails["alow_remoteservices"] == 1 && $config["default_service_remote"]) {
                $_ClientsDetails["access"]["remoteservice"] = true;
                if (substr($_ClientsDetails["remote_services"], 0, 1) == ",") {
                    $_ClientsDetails["remote_services"] = substr_replace($_ClientsDetails["remote_services"], "", 0, 1);
                }
                $_ClientsDetails["access"]["alow_remoteservices"] = $_ClientsDetails["remote_services"];
            }
            $ClientsDetails = $_ClientsDetails;
            $_servicedtl["username"] = $_ClientsDetails["username"];
        } else {
            global $_ClientsDetails;
        }
        if (!$edituser) {
        }
        if ($serviceId) {
            $where_service .= " AND md5(id)='" . $serviceId . "' ";
        }
    } else {
        if ($storeowner["id"]) {
            if (!function_exists(getClientsDetails)) {
                require_once ROOTDIR . "/includes/clients.fun.inc.php";
            }
            $storeowner = getClientsDetails($storeowner["id"]);
        } else {
            if ($reselleruserid) {
                $reseller = mysqli_fetch_assoc(dquery("select f.id,\n        (SELECT s." . $SERVICEFIELD . "  \n        FROM tblUsers s WHERE s.id=f.reseller_id) \n        AS resellerfile FROM tblUsers f WHERE md5(f.id)='" . $reselleruserid . "'"));
            }
        }
    }
    if ($reselleruserid) {
        $rdet = mysqli_fetch_assoc(dquery("select `id`,`" . $SERVICEFIELD . "` from tblUsers where md5(id)='" . $reselleruserid . "'"));
    }
    if (is_array($serviceId)) {
        $lists = implode(",", $serviceId);
        $where_service = " AND id  IN (" . $lists . " )";
    }
    if (0 < count($ActiveService)) {
        $servicelist = implode(",", $ActiveService);
        $where_service .= " and id in (" . $servicelist . ")";
    }
    if ($serverservice == 5) {
        $where_service .= " and purchasepoint>0";
    }
    if ($affiliate) {
        $where_service .= " AND `affiliate_comission` != ''";
    }
    if (($resellersproduct || $storeowner["id"] != "") && $retail) {
        $retailpurchase .= " And store='1'";
    }
    if ($onhome && !is_array($serviceId)) {
        $retailpurchase .= " AND `show_onhome`='1' ";
    }
    if ($hot) {
        $retailpurchase .= " AND `hot`='1'  ";
        $tmp_next = 0;
        $tmp_pagelimit = 10;
        $orderby = "  RAND() ";
    }
    if ($searchkey) {
        if (isset($_SESSION["adminid"])) {
            $searchkey = " service_name LIKE '%" . $searchkey . "%' ";
        } else {
            $searchkey = " service_name LIKE '" . $searchkey . "%' and retail='1'";
        }
    }
    if ($serverservice == 1) {
        if ($GROUPCHECK) {
            $GROUPCHECK .= " and `server`='1'";
        } else {
            if ($_WHERE == "WHERE") {
                $GROUPCHECK = " and `server`='1'";
            } else {
                $GROUPCHECK = " where `server`='1'";
            }
        }
    } else {
        if ($serverservice == 5) {
            if ($GROUPCHECK) {
                $GROUPCHECK .= " ";
            } else {
                if ($_WHERE == "WHERE") {
                    $GROUPCHECK = " ";
                } else {
                    $GROUPCHECK = " where 1=1";
                }
            }
        } else {
            if ($serverservice == 2) {
                if ($GROUPCHECK) {
                    $GROUPCHECK .= " and `server`='2'";
                } else {
                    if ($_WHERE == "WHERE") {
                        $GROUPCHECK = " and `server`='2'";
                    } else {
                        $GROUPCHECK = " where `server`='2'";
                    }
                }
            } else {
                if (!$serviceId) {
                    if ($GROUPCHECK) {
                        $GROUPCHECK .= " and `server`='0'";
                    } else {
                        if ($_WHERE != "where" && $_WHERE != "WHERE") {
                            $GROUPCHECK = " where `server`='0'";
                        } else {
                            $GROUPCHECK = " and `server`='0'";
                        }
                    }
                } else {
                    $_WHERE = " where 1=1 ";
                }
            }
        }
    }
    if (API == 1) {
        $GROUPCHECK = "";
    }
    if (CLIENT == 1) {
        $GROUPCHECK .= " and active='1'";
        if ($productpage) {
            $GROUPCHECK .= " and hideguest='0'";
        }
    }
    $query = "SELECT id,group_name,`server` FROM `tbl_imei_group` \n    " . $_WHERE . " " . $where . " " . $GROUPCHECK . " ORDER BY `display_order` ASC";
    if ($mysqli_errors) {
        echo $query . "<hr />";
    }
    $query = dquery($query);
    while ($row = mysqli_fetch_assoc($query)) {
        $verGid = $row["id"];
        if ($sortby) {
            if ($sortby == "featured") {
                $sortby1 = " `id` DESC ";
            } else {
                if ($sortby == "namea") {
                    $sortby1 = " `service_name` ASC ";
                } else {
                    if ($sortby == "namez") {
                        $sortby1 = " `service_name` DESC ";
                    } else {
                        if ($sortby == "pricel") {
                            $sortby1 = "  ABS(`credit`)  ASC ";
                        } else {
                            if ($sortby == "priceh") {
                                $sortby1 = "  ABS(`credit`)  DESC ";
                            } else {
                                $sortby1 = "`id`";
                            }
                        }
                    }
                }
            }
        } else {
            $sortby1 = " `sort`,`service_name` ASC";
        }
        if ($storeowner["id"] && $retail) {
            $newquery = " and find_in_set( '" . $storeowner["id"] . "',allowreseller) ";
        } else {
            $newquery = "";
        }
        if ($serverservice && !API) {
            if (0 < $serverservice) {
                $newquery .= " and useasserver='" . $serverservice . "'";
            } else {
                $newquery .= " and useasserver=0";
            }
        }
        $Fields = "*";
        if ($searchkey) {
            $query1 = "SELECT " . $Fields . " FROM tbl_services_imei  WHERE `group_id`='" . $verGid . "' and " . $searchkey . "  " . $where_service . " " . $SERVICECHECK . " " . $newquery . " ORDER BY service_name LIMIT " . $next . "," . $newlimit;
        } else {
            if ($hot) {
                $query1 = "SELECT " . $Fields . " FROM tbl_services_imei  WHERE 1=1 \n                " . $retailpurchase . " " . $newquery . " ORDER BY " . $orderby . " ASC LIMIT " . $tmp_next . "," . $tmp_pagelimit;
            } else {
                if ($model && $brand) {
                    $query1 = "SELECT " . $Fields . " FROM tbl_services_imei  WHERE  \n                active='1'  " . $retailpurchase . " and `group_id`='" . $verGid . "' \n                 and find_in_set(" . $model . ",assigned_model) and find_in_set(" . $brand . ",assigned_brand)\n                 ORDER BY " . $sortby1 . " LIMIT " . $next . "," . $newlimit;
                } else {
                    if ($model) {
                        $query1 = "SELECT " . $Fields . " FROM tbl_services_imei  WHERE `group_id`='" . $verGid . "' and\n                model='1' and find_in_set( '" . $model . "',assigned_model)   LIMIT " . $next . "," . $newlimit;
                    } else {
                        $query1 = "SELECT " . $Fields . " FROM tbl_services_imei\n                WHERE `group_id`='" . $verGid . "'  " . $SERVICECHECK . " \n                " . $where_service . " " . $retailpurchase . " " . $where_profile . " " . $newquery . " ORDER BY " . $sortby1 . " LIMIT " . $next . "," . $newlimit;
                    }
                }
            }
        }
        generatePaginate($query1);
        if ($debugquery) {
            echo $query1 . "<hr />";
        }
        $_Services = [];
        $result1 = dquery($query1);
        if (mysqli_num_rows($result1)) {
            while ($row1 = mysqli_fetch_assoc($result1)) {
                $_servicedtl = $row1;
                $_servicedtl["service_name"] = $row1["service_name"];
                $_servicedtl["id"] = $row1["id"];
                $_servicedtl["useasserver"] = $row1["useasserver"];
                $_servicedtl["maxlength"] = $row1["maxlength"];
                $_servicedtl["producttype"] = "digital";
                $_servicedtl["imeiregex"] = $row1["imeiregex"];
                $_servicedtl["howtoinfo"] = $row1["howtoinfo"];
                $_servicedtl["avgdeliverytime"] = $row1["avgdeliverytime"];
                $_servicedtl["avgexetime"] = $row1["avgexetime"];
                $_servicedtl["qntoptions"] = $row1["qntoptions"];
                $_servicedtl["maxqnt"] = $row1["maxqnt"];
                $_servicedtl["minqnt"] = $row1["minqnt"];
                $_servicedtl["qnt"] = $row1["qnt"];
                $_servicedtl["purchasepoint"] = $row1["purchasepoint"];
                $_servicedtl["reward"] = $row1["reward"];
                $_servicedtl["point"] = $row1["point"];
                $_servicedtl["status"] = $row1["status"];
                $_servicedtl["imei_custom"] = $row1["imei_custom"];
                $_servicedtl["imei_bulk"] = $row1["imei_bulk"];
                $_servicedtl["imei_custom_name"] = $row1["imei_custom_name"];
                $_servicedtl["imei_custom_info"] = $row1["imei_custom_info"];
                $_servicedtl["imei_custom_len"] = $row1["imei_custom_len"];
                $_servicedtl["maxlength"] = $row1["maxlength"];
                $_servicedtl["isalpha"] = $row1["isalpha"];
                $_servicedtl["rejectqnt"] = $row1["rejectqnt"];
                $_servicedtl["key_selling"] = $row1["key_selling"];
                if ($row1["service_type"]) {
                    $sv = mysqli_fetch_assoc(dquery("select `type` from \n                    tbl_service_type where id='" . $row1["service_type"] . "'"));
                    $_servicedtl["type"] = $sv["type"];
                }
                if ($row1["useasserver"] == 2) {
                    $_servicedtl["seourl"] = "remote/" . $row["id"] . "/" . $row1["id"] . "/" . str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $row1["service_name"])) . "";
                    $_servicedtl["seourl"] = _url("remote/" . str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $row1["service_name"])) . "?pid=" . $row1["id"]);
                } else {
                    if ($row1["useasserver"] == 1) {
                        $_servicedtl["seourl"] = "server/" . $row["id"] . "/" . $row1["id"] . "/" . str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $row1["service_name"])) . "";
                        $_servicedtl["seourl"] = _url("server/" . str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $row1["service_name"])) . "?pid=" . $row1["id"]);
                    } else {
                        $_servicedtl["seourl"] = "imei/" . $row["id"] . "/" . $row1["id"] . "/" . str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $row1["service_name"])) . "";
                        $_servicedtl["seourl"] = _url("imei/" . str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $row1["service_name"])) . "?pid=" . $row1["id"]);
                    }
                }
                if ($row1["icon_link"] != "" && !$storeowner["id"]) {
                    $_servicedtl["icon"] = "<img src='" . $row1["icon_link"] . "' border='0' class='serviceicon' />";
                }
                $_servicedtl["detaillink"] = _url("resellerpricing/action/getdetail/service/" . $row1["id"]);
                $_servicedtl["newservice"] = 0;
                if ($row1["lastupdatedtime"]) {
                    $current = $row1["lastupdatedtime"] + $config["showimeiupdate"] * 3600;
                    if (time() < $current) {
                        $_servicedtl["newservice"] = 1;
                    }
                }
                $_servicedtl["time"] = $row1["time"];
                $_servicedtl["info"] = $row1["info"];
                $_servicedtl["network"] = $row1["network"];
                $_servicedtl["provider"] = $row1["provider"];
                $_servicedtl["newid"] = $row1["id"];
                $_servicedtl["credit"] = round($row1["credit"], 2);
                $_servicedtl["model"] = $row1["model"];
                $_servicedtl["PIN"] = $row1["PIN"];
                $_servicedtl["KBH"] = $row1["KBH"];
                $_servicedtl["mep"] = $row1["mep"];
                $_servicedtl["PRD"] = $row1["PRD"];
                $_servicedtl["locks"] = $row1["locks"];
                $_servicedtl["SN"] = $row1["SN"];
                $_servicedtl["reference"] = $row1["reference"];
                $_servicedtl["SecRO"] = $row1["SecRO"];
                $RetS = mysqli_fetch_assoc(dquery("select status from tbl_service_status\n                    where groupid='retail' and serviceid='" . $row1["id"] . "'"));
                if ($RetS["status"]) {
                    $_servicedtl["retail"] = $RetS["status"];
                    if ($row1["retail_name"] && $retail) {
                        $_servicedtl["service_name"] = $row1["retail_name"];
                    }
                }
                $_servicedtl["credit_admin"] = $row1["credit"];
                $promotion_found = false;
                if ($uid) {
                    if (!$CreditFound) {
                    }
                }
                $ServicePrice = new ServicePrice($row1["id"]);
                $_servicedtl["discount"] = 0;
                if (0 < $_SESSION["currency"]["id"]) {
                    $SystemCurrency = $_SESSION["currency"]["id"];
                } else {
                    $SystemCurrency = $_SESSION["system_default_currency"]["id"];
                }
                $_currencyid = $_ClientsDetails["default_currency"] ? $_ClientsDetails["default_currency"] : $SystemCurrency;
                if ($retail) {
                    $_clientgroup = "retail";
                } else {
                    if ($_ClientsDetails["client_group"]) {
                        $_clientgroup = $_ClientsDetails["client_group"];
                    } else {
                        $_clientgroup = "base";
                    }
                }
                if ($productpage) {
                    $cg = dquery("select * from tbl_client_group where showon=1");
                    while ($rcg = mysqli_fetch_assoc($cg)) {
                        $_servicedtl["cgprice"][$rcg["id"]] = round($ServicePrice->getServicePricing($_currencyid, 1, $rcg["id"], ""), $precision);
                    }
                }
                $priceincrease = "";
                $priceincreaseby = "";
                if ($storeowner[id] && ($_ClientsDetails["reseller_id"] || !isset($_SESSION["uid"]))) {
                    $RCG = mysqli_fetch_assoc(dquery("select client_group,increaseval,increaseby,serverincrease,serverincreaseby,remoteincrease,remoteincreaseby from tblUsers where id='" . $storeowner["id"] . "'"));
                    if ($RCG["client_group"]) {
                        $_clientgroup = $RCG["client_group"];
                    }
                    $uid = $storeowner[id];
                    if ($_servicedtl["useasserver"] == 2) {
                        $priceincrease = $RCG["remoteincrease"];
                        $priceincreaseby = $RCG["remoteincreaseby"];
                    } else {
                        if ($_servicedtl["useasserver"] == 1) {
                            $priceincrease = $RCG["serverincrease"];
                            $priceincreaseby = $RCG["serverincreaseby"];
                        } else {
                            $priceincrease = $RCG["increaseval"];
                            $priceincreaseby = $RCG["increaseby"];
                        }
                    }
                }
                if ($serviceId) {
                    $QntRangeID = [];
                    $_servicedtl["allpricing"] = $ServicePrice->getAllPricingByClient($_currencyid, $_clientgroup);
                    foreach ($_servicedtl["allpricing"] as $qntrangeid => $detil) {
                        $QntRangeID[$qntrangeid] = $qntrangeid;
                    }
                    if (1 < count($QntRangeID)) {
                        $qrange = dquery("select * from tbl_pricing_qnt where pricingqntid in (" . implode(",", $QntRangeID) . ")");
                        $QntRangeIDNEew[0] = ["start" => 1, "end" => "", "price" => $_servicedtl["allpricing"][0]];
                        while ($qrow = mysqli_fetch_assoc($qrange)) {
                            $qrow["price"] = $_servicedtl["allpricing"][$qrow["pricingqntid"]];
                            $QntRangeIDNEew[$qrow["pricingqntid"]] = $qrow;
                        }
                        $_servicedtl["qntrange"] = $QntRangeIDNEew;
                        $_servicedtl["qntrangejson"] = json_encode($QntRangeIDNEew);
                    }
                }
                $_servicedtl["credit"] = round($ServicePrice->getServicePricing($_currencyid, $orderqnt, $_clientgroup, $uid), $precision);
                $_servicedtl["pricingfrom"] = $ServicePrice->pricingfrom;
                if ($storeowner["id"] && ($_ClientsDetails["reseller_id"] || !isset($_SESSION["uid"]))) {
                    $_servicedtl["credit"] = $ServicePrice->getResellersUserPrice($storeowner["id"], $_servicedtl["credit"], "imei", $priceincrease, $priceincreaseby);
                }
                $_servicedtl["discount"] = 0;
                $row1["retail_credit"] = round($ServicePrice->getServicePricing($_currencyid, $orderqnt, $_clientgroup, $uid), $precision);
                $_servicedtl["commission"] = ($row1["retail_credit"] - $row1["discount"]) * $_servicedtl["resellerdisc"] / 100;
                $_servicedtl["percommission"] = $row1["resellerdisc"];
                $_servicedtl["commission"] = round($_servicedtl["commission"], $precision);
                if ($uid) {
                    $ext = explode(",", $row1["allowreseller"]);
                    $flag = false;
                    foreach ($ext as $dt) {
                        if ($dt == $uid) {
                            $flag = true;
                        }
                    }
                    $_servicedtl["allowreseller"] = $flag;
                }
                if ($serviceId && !is_array($serviceId)) {
                    $_servicedtl["listing"] = $row1["listing"];
                    $_servicedtl["reqredfield"]["model"] = $row1["model"];
                    $_servicedtl["reqredfield"]["validateimei"] = $row1["validateimei"];
                    if ($row1["assigned_brand"] != "" && $row1["assigned_brand"] != "ALL") {
                        $_servicedtl["reqredfield"]["assigned_brand"] = $row1["assigned_brand"];
                    }
                    $_servicedtl["reqredfield"]["provider"] = $row1["provider"];
                    if ($row1["assigned_country"] != "" && $row1["assigned_country"] != "ALL") {
                        $_servicedtl["reqredfield"]["assigned_country"] = $row1["assigned_country"];
                    }
                    $_servicedtl["reqredfield"]["mep"] = $row1["mep"];
                    if ($row1["assigned_mep"] != "" && $row1["assigned_mep"] != "ALL") {
                        $_servicedtl["reqredfield"]["assigned_mep"] = $row1["assigned_mep"];
                    }
                    $_servicedtl["useasserver"] = $row1["useasserver"];
                    $_servicedtl["qnt"] = $row1["qnt"];
                    $_servicedtl["reqredfield"]["PIN"] = $row1["PIN"];
                    $_servicedtl["reqredfield"]["KBH"] = $row1["KBH"];
                    $_servicedtl["reqredfield"]["PRD"] = $row1["PRD"];
                    $_servicedtl["reqredfield"]["SN"] = $row1["SN"];
                    $_servicedtl["reqredfield"]["SecRO"] = $row1["SecRO"];
                    $_servicedtl["reqredfield"]["isalpha"] = $row1["isalpha"];
                    $_servicedtl["reqredfield"]["type"] = $row1["Type"];
                    $_servicedtl["reqredfield"]["reference"] = $row1["Reference"];
                    $_servicedtl["reqredfield"]["locks"] = $row1["Locks"];
                    $_servicedtl["reqredfield"]["imei_single"] = $row1["imei_single"];
                    $_servicedtl["reqredfield"]["imei_bulk"] = $row1["imei_bulk"];
                    $_servicedtl["reqredfield"]["imei_custom"] = $row1["imei_custom"];
                    $_servicedtl["reqredfield"]["imei_custom_len"] = $row1["imei_custom_len"];
                    $_servicedtl["reqredfield"]["maxlength"] = $row1["maxlength"];
                    $_servicedtl["reqredfield"]["imeiregex"] = $row1["imeiregex"];
                    $_servicedtl["reqredfield"]["imei_custom_name"] = $row1["imei_custom_name"];
                    $_servicedtl["reqredfield"]["imei_custom_info"] = $row1["imei_custom_info"];
                    $_servicedtl["purchase_cost"] = $row1["purchase_cost"];
                    $_servicedtl["notification_mail"] = $row1["notification_mail"];
                    global $getservice_detailsby_api;
                    if (API == "1" && $getservice_detailsby_api) {
                        $_servicedtl["purchase_cost"] = "";
                        $_servicedtl["API"] = $_servicedtl["purchase_cost"];
                        $_servicedtl["ebay_code"] = $_servicedtl["API"];
                        $_servicedtl["status"] = $_servicedtl["ebay_code"];
                        $_servicedtl["seo_description"] = $_servicedtl["status"];
                    }
                    $_servicedtl["credit"] = round($_servicedtl["credit"], $precision);
                    return $_servicedtl;
                }
                $_Services[md5($row1["id"])] = $_servicedtl;
            }
            $_Group[$row["group_name"]] = $_Services;
            unset($_Services);
        }
        mysqli_free_result($result1);
    }
    return $_Group;
}
function getIMEIServices($groupId = "", $serviceId = "", $uid = "", $updateclientdetails = false, $getallservices = false, $reselleruserid = "", $retail = false, $onhome = false, $hot = false, $userprofile = false, $edituser = false, $promotion = false, $limit = "", $sortby = "", $searchkey = "", $affiliate = false, $resellersproduct = false, $model = "", $brand = "", $productpage = false, $serverservice = false, $forstore = false, $orderqnt = "")
{
    return getimeiservicesnew($groupId, $serviceId, $uid, $updateclientdetails, $getallservices, $reselleruserid, $retail, $onhome, $hot, $userprofile, $edituser, $promotion, $limit, $sortby, $searchkey, $affiliate, $resellersproduct, $model, $brand, $productpage, $serverservice, $forstore, $orderqnt);
}
function getIMEIPrice($serviceid, $currencyid, $retail = false)
{
    $sql = mysqli_fetch_assoc(dquery("SELECT `credit` FROM `tbl_imei_credit`\n     WHERE `service_id`='" . $serviceid . "' AND `currency_id`='" . $currencyid . "'"));
    if ($sql["credit"]) {
        return $sql["credit"];
    }
    return false;
}
function getIMEIServiceGroup($server = "")
{
    $_Group = [];
    if (isset($_SESSION["adminid"])) {
        $GROUPCHECK = "and 1=1";
    } else {
        $GROUPCHECK = "and active=1";
    }
    if ($server) {
        $GROUPCHECK .= " and `server`='" . $server . "'";
    } else {
        $GROUPCHECK .= " and server=0";
    }
    $query = "SELECT `id`,`group_name`,description,imagelink,active \n    FROM `tbl_imei_group` WHERE `group_name`<>''\n     " . $GROUPCHECK . " ORDER BY `display_order` ASC";
    $result = dquery($query);
    $tot_result = mysqli_num_rows($result);
    while ($row = mysqli_fetch_assoc($result)) {
        $verGid = $row["id"];
        $_Group[$row["id"]]["name"] = $row["group_name"];
        $_Group[$row["id"]]["image"] = $row["imagelink"];
        $_Group[$row["id"]]["description"] = $row["description"];
        $_Group[$row["id"]]["active"] = $row["active"];
    }
    return $_Group;
}
function getDiscountIMEI($ServiceId, $uid)
{
    if ($data = mysqli_fetch_assoc(dquery("SELECT discount FROM \n    `tbl_discount_imei` WHERE `user_id`='" . $uid . "' \n    AND `service_id`='" . $ServiceId . "'"))) {
        return $data["discount"];
    }
}
function getServiceCreditIMEI($ServiceId, $currencyId)
{
}
function placeOrderIMEIvalidation($required, $login = true, $alertmessage = false, $allservice = "", $point = false)
{
    global $config;
    global $lng_languag;
    $return = NULL;
    global $imei_placed;
    $imei_placed = [];
    global $customfield;
    $time = time();
    global $id;
    global $response;
    global $pin;
    global $no;
    global $otherno;
    global $qnt;
    global $_ClientsDetails;
    if ($response && !preg_match("/^([a-zA-Z0-9])+([\\.a-zA-Z0-9+_-])*@([a-zA-Z0-9_-])+(\\.[a-zA-Z0-9_-]+)*\\.([a-zA-Z]{2,6})\$/", $response)) {
        $return .= "<li>" . $lng_languag["clientareaerroremailinvalid"];
    }
    if (!$id) {
        $return .= "<li>" . $lng_languag["selectservice"] . "</li>";
    } else {
        $serv = checkServiceStatus($_ClientsDetails, $allservice["id"]);
        if (!$serv) {
            if (API) {
                $return .= "Service Not Active ";
            } else {
                $return .= "<li>" . $lng_languag["servicenotactive"] . " </li>";
            }
        }
    }
    if ($no == 2 && ($otherno == "" || preg_replace("/[0-9 .\\-()]/", "", $otherno))) {
        $return .= "<li>" . $lng_languag["clientareaerrorphonenumber2"] . "</li>";
    }
    if ($allservice["useasserver"] == 2) {
        $SERVICEFIELD = "remote_services";
        $ALLOWFIELD = "alow_remoteservices";
    } else {
        if ($allservice["useasserver"] == 1) {
            $SERVICEFIELD = "newserver_services";
            $ALLOWFIELD = "alow_serverlogservices";
        } else {
            $SERVICEFIELD = "imei_services";
            $ALLOWFIELD = "alow_imeiservices";
        }
    }
    if ($login) {
        global $_ClientsDetails;
        if ($config["masterpin"] && !defined("API")) {
            $pin = enc((string) $pin, "9486");
            $checkpin = mysqli_num_rows(dquery("SELECT * FROM tblUsers \n            WHERE master_pin='" . $pin . "' AND id='" . $_ClientsDetails["id"] . "'"));
            if (!$checkpin) {
                $return .= $lng_languag["wrongmasterpin"];
            }
        }
        if (!$point) {
            $diff = ($time - $_ClientsDetails["credit_date"]) / 86400;
            if ($_ClientsDetails["credit_validity"] != 0 && $_ClientsDetails["credit_validity"] < $diff) {
                $return .= "<li>" . $lng_languag["creditvalidityexp"] . "</li>";
            }
        }
        if ($flag) {
            if (API) {
                $return .= "Service Not Active ";
            } else {
                $return .= "<li>" . $lng_languag["servicenotallowed"] . "</li>";
            }
        }
    }
    if (!function_exists(checkCustomFields)) {
        require_once "customfield.fun.inc.php";
    }
    if ($error = checkCustomFields($customfield)) {
        $return .= (string) $error;
    }
    if ($allservice["useasserver"]) {
        global $imei_custom;
        $success++;
        $imei_placed[] = $imei_custom;
        if ($allservice["qntoptions"]) {
            $range = explode(",", $allservice["qntoptions"]);
            $flag = false;
            foreach ($range as $rqnt) {
                if ($rqnt == $qnt) {
                    $flag = true;
                }
            }
            if (!$flag) {
                $return .= "<li>" . $lng_languag["wrong"] . " " . $lng_languag["qnt"] . " option " . $allservice["qntoptions"] . "</li>";
            }
        } else {
            if ($allservice["minqnt"] && $allservice["maxqnt"]) {
                if (!($allservice["minqnt"] <= $qnt && $qnt <= $allservice["maxqnt"])) {
                    $return .= "<li>" . $lng_languag["wrong"] . " " . $lng_languag["qnt"] . " range</li>";
                }
            }
        }
    } else {
        if ($required["imei_custom"]) {
            global $imei_custom;
            $imei_custom = str_replace("\r\n", ",", $imei_custom);
            $imei_custom = str_replace("\n", ",", $imei_custom);
            $imei_custom = str_replace("-", "", $imei_custom);
            $imei_custom = str_replace(";", ",", $imei_custom);
            $imei_custom = explode(",", $imei_custom);
            $success = 0;
            foreach ($imei_custom as $imei) {
                if ($required["isalpha"] || 1) {
                    $imei = filter_var($imei, FILTER_SANITIZE_STRING);
                    if ($required["imeiregex"] && !preg_match($required["imeiregex"], $imei)) {
                        $imei = "";
                    }
                    if ($required["maxlength"] && $required["imei_custom_len"]) {
                        if ($required["imei_custom_len"] <= strlen($imei) && strlen($imei) <= $required["maxlength"]) {
                            $success++;
                            $imei_placed[] = $imei;
                        }
                    } else {
                        if (strlen($imei) == $required["imei_custom_len"]) {
                            $success++;
                            $imei_placed[] = $imei;
                        } else {
                            $return .= "<li> " . $lng_languag["invalidimei"] . "</li>";
                        }
                    }
                } else {
                    $imei = preg_replace("/[^0-9]/i", "", $imei);
                    if ($required["imeiregex"] && !preg_match($required["imeiregex"], $imei)) {
                        $imei = "";
                    }
                    if ($required["maxlength"] && $required["imei_custom_len"]) {
                        if ($required["imei_custom_len"] <= strlen($imei) && strlen($imei) <= $required["maxlength"]) {
                            $success++;
                            $imei_placed[] = $imei;
                        }
                    } else {
                        if (strlen($imei) == $required["imei_custom_len"] && is_numeric($imei)) {
                            $success++;
                            $imei_placed[] = $imei;
                        } else {
                            $return .= "<li>  " . $lng_languag["invalidimei"] . $imei . "</li>";
                        }
                    }
                }
            }
            if ($success == 0) {
                if ($required["imei_custom_name"]) {
                    $return = "<li>" . $required["imei_custom_name"] . " " . $lng_languag["required"] . " or Invalid</li>";
                } else {
                    $return .= "<li> " . $lng_languag["requiredimei"] . " </li>";
                }
            }
        } else {
            global $imei_bulk;
            global $imei_mobile;
            global $imei1;
            global $imei2;
            if (($required["imei_single"] && $required["imei_bulk"] == 0 || $imei_bulk == "" && $imei1 != "") && !$imei_mobile) {
                $imei = $imei1 . $imei2;
                if (strlen($imei) != 15 || !is_numeric($imei)) {
                    $return .= "<li>" . $lng_languag["requiredimei"] . "</li>";
                } else {
                    $imei_placed[] = $imei;
                }
            } else {
                if ($imei_mobile) {
                    $imei_bulk = $imei_mobile;
                }
                $imei_bulk = str_replace("\r\n", ",", $imei_bulk);
                $imei_bulk = str_replace("\n", ",", $imei_bulk);
                $imei_bulk = str_replace("-", "", $imei_bulk);
                $imei_bulk = str_replace(";", ",", $imei_bulk);
                $imei_bulk = explode(",", $imei_bulk);
                $success = 0;
                $imei_bulk = array_unique($imei_bulk);
                foreach ($imei_bulk as $imei) {
                    $imei = preg_replace("/[^0-9]/i", "", $imei);
                    if (!validate_imei(trim($imei))) {
                        $return .= "<li>" . $lng_languag["invalidimei"] . $imei . "</li>";
                        $return .= "<li>" . $lng_languag["invalidimei"] . $imei . "</li>";
                    }
                    if (strlen($imei) == 15 && is_numeric($imei)) {
                        $success++;
                        $imei_placed[] = $imei;
                    } else {
                        $return .= "<li>" . $lng_languag["invalidimei"] . $imei . "</li>";
                    }
                }
                if ($success == 0) {
                    $return .= "<li>" . $lng_languag["requiredimei"] . "</li>";
                }
            }
        }
    }
    global $model_id;
    if ($required["model"] && !$model_id) {
        $return .= "<li>" . $lng_languag["requiredmodel"] . "</li>";
    }
    global $provider_id;
    if ($required["provider"] && !$provider_id) {
        $return .= "<li>" . $lng_languag["requiredprovider"] . "</li>";
    }
    global $network_id;
    if ($required["network"] && !$network_id) {
        $return .= "<li>" . $lng_languag["requirednetwork"] . "</li>";
    }
    global $mep;
    if ($required["mep"] && !$mep) {
        $return .= "<li>" . $lng_languag["requiredmep"] . "</li>";
    }
    global $PIN;
    if ($required["PIN"] && !$PIN) {
        $return .= "<li>" . $lng_languag["requiredpin"] . "</li>";
    }
    global $KBH;
    if ($required["KBH"] && !$KBH) {
        $return .= "<li>" . $lng_languag["requiredkbh"] . "</li>";
    }
    global $PRD;
    if ($required["PRD"] && !$PRD) {
        $return .= "<li>" . $lng_languag["requiredprd"] . "</li>";
    }
    global $SN;
    if ($required["SN"] && !$SN) {
        $return .= "<li>" . $lng_languag["requiredsn"] . "</li>";
    }
    global $SecRO;
    if ($required["SecRO"] && !$SecRO) {
        $return .= "<li>" . $lng_languag["requiredsecro"] . "</li>";
    }
    global $Type;
    if ($required["Type"] && !$Type) {
        $return .= "<li>" . $lng_languag["requiredtype"] . "</li>";
    }
    global $Reference;
    if ($required["Reference"] && !$Reference) {
        $return .= "<li>" . $lng_languag["requiredreference"] . "</li>";
    }
    global $Locks;
    if ($required["locks"] && !$Locks) {
        $return .= "<li>" . $lng_languag["requiredlocks"] . "</li>";
    }
    foreach ($imei_placed as $imei) {
        $imei = trim($imei);
        if (mysqli_num_rows(dquery("select id from tbl_blacklist_imei\n        where (imei='" . $imei . "' and service_id=0) or (imei='" . $imei . "' and md5(service_id)='" . $id . "')"))) {
            return "error: This " . $imei . " is blacklisted";
        }
    }
    if ($allservice["useasserver"] && $allservice["rejectqnt"] && $allservice["key_selling"]) {
        include_once ROOTDIR . "/includes/keyselling.fun.php";
        if (!processKey($allservice["key_selling"], 999999, "server", $qnt, true)) {
            return "error:  Out of Stock please try after sometime";
        }
    }
    if ($config["duplicateimei"] && $login && $alertmessage == "" && !$allservice["useasserver"]) {
        $otherimeiarray = [];
        foreach ($imei_placed as $imei) {
            if (!in_array($imei, $otherimeiarray)) {
                $otherimeiarray[$imei] = $imei;
                if (checkRepeatIMEI($_SESSION["uid"], $imei, $allservice["id"])) {
                    $return .= "<li>" . $lng_languag["duplicateimeientry"] . "  #" . $imei . "</li>";
                } else {
                    $sql = "SELECT * from `tbl_order_imei` where `user_id`='" . $_SESSION["uid"] . "' AND `imei`='" . $imei . "' AND service_id='" . $allservice["id"] . "' AND  (`user_can_c`=3 OR `user_can_c`=4 )";
                    $countRows = dquery($sql);
                    if (mysqli_num_rows($countRows) && !API) {
                        return "alert: This " . $imei . " already Placed by you Do you want to re-order";
                    }
                }
            } else {
                $return .= "<li>" . $lng_languag["duplicateimeientry"] . "  #" . $imei . "</li>";
            }
        }
    }
    if ($return) {
        return "error:" . $return;
    }
}
function duplicateIMEIReply($order, $imei)
{
    $serv = mysqli_fetch_assoc(dquery("select service_id from tbl_order_imei\n    where order_id='" . $order . "'"));
    $sql = "SELECT * from `tbl_order_imei` where `imei`='" . $imei . "' AND `user_can_c`=4\n    and service_id='" . $serv["service_id"] . "' and (select autoreply from tbl_services_imei \n    where id=service_id)=1 and order_id!='" . $order . "'";
    $countRows = dquery($sql);
    if (mysqli_num_rows($countRows)) {
        $data = mysqli_fetch_assoc($countRows);
        $note = "Duplicate IMEI Reply Copied from Order: " . $data["order_id"];
        if ($data["reply"]) {
            dquery("UPDATE tbl_order_imei SET user_can_c=1,reply='" . $data["reply"] . "',adminnote='" . $note . "' \n            WHERE order_id='" . $order . "'");
        }
        return true;
    }
    $sql = "SELECT * from `tbl_order_imei` where `imei`='" . $imei . "' AND `user_can_c`=4\n    and service_id='" . $serv["service_id"] . "' and (select autoreplycompleted from tbl_services_imei \n    where id=service_id)=1 and order_id!='" . $order . "'";
    $countRows = dquery($sql);
    if (mysqli_num_rows($countRows)) {
        $data = mysqli_fetch_assoc($countRows);
        $note = "Duplicate IMEI Reply Copied from Order: " . $data["order_id"];
        if ($data["reply"]) {
            replySuccessIMEI(md5($order), $data["reply"], "", "", "", "", "", $order);
            dquery("UPDATE tbl_order_imei set adminnote='" . $note . "'\n            where order_id='" . $order . "'");
        }
        return true;
    }
    $sql = "SELECT * from `tbl_order_imei` where `imei`='" . $imei . "' AND (`user_can_c`=0 or `user_can_c`=1)    and service_id='" . $serv["service_id"] . "' and (select autorejectduplicate from tbl_services_imei \n    where id=service_id)=1 and order_id!='" . $order . "'";
    $countRows = dquery($sql);
    if (mysqli_num_rows($countRows)) {
        $data = mysqli_fetch_assoc($countRows);
        $note = "Auto Reject Duplicate Order: " . $data["order_id"];
        rejectIMEI(md5($order), $note, "", "", "", "", $order);
        dquery("UPDATE tbl_order_imei set adminnote='" . $note . "'\n            where order_id='" . $order . "'");
        return true;
    }
}
function checkRepeatIMEI($userid, $imei, $serviceid = "")
{
    $sql = "SELECT * from `tbl_order_imei` where `user_id`='" . $userid . "'\n     AND `imei`='" . $imei . "' AND  (`user_can_c`=0 OR `user_can_c`=1 )";
    if ($serviceid) {
        $sql .= " and service_id='" . $serviceid . "'";
    }
    $countRows = dquery($sql);
    if (mysqli_num_rows($countRows) == 0) {
        return false;
    }
    return true;
}
function replySuccessIMEI($orderid, $reply, $adminid = "", $suplierid = "", $apiid = "", $apilogreferenceid = "", $changestatus = "", $nomd5 = "", $replyarr = [])
{
    include_once ROOTDIR . "/includes/mail.fun.php";
    global $config;
    global $db;
    global $lng_languag;
    global $imeiuniqueid;
    global $email_merge_fields;
    global $fromcron;
    global $precision;
    $status = NULL;
    $reply = str_replace(";", " ", $reply);
    $reply = str_replace("?", " ", $reply);
    $reply = preg_replace("/<script\\b[^>]*>(.*?)<\\/script>/is", "", $reply);
    if ($nomd5) {
        $WHERE = "order_id='" . $nomd5 . "'";
    } else {
        $WHERE = "md5(order_id)='" . $orderid . "'";
    }
    $OrderDtl = mysqli_fetch_assoc(dquery("SELECT `order_id`,`qnt`,`reseller_id`,`subscribe`,`user_can_c`,`credit`,`imei`,`responseno`,\n    `discount`,`reseller_credit`,`reseller_discount`,`encnum`,`user_id`,`retail_shop`,`service_id`,`comments`,`response_email` \n    FROM `tbl_order_imei` WHERE " . $WHERE));
    if (!$OrderDtl["qnt"]) {
        $OrderDtl["qnt"] = 1;
    }
    if ($reply != "" && $OrderDtl["user_can_c"] == 4) {
        dquery("UPDATE `tbl_order_imei` SET `reply`='" . $reply . "' WHERE md5(order_id)='" . $orderid . "'");
    }
    if ($reply == "" && $changestatus == "" || $OrderDtl["user_can_c"] == 4) {
        return $status = [false, ""];
    }
    if ($OrderDtl["user_can_c"] != 3 && $changestatus != "") {
        return $status = [false, ""];
    }
    $credit = round($OrderDtl["credit"] - $OrderDtl["discount"], $precision);
    $credit = $credit * $OrderDtl["qnt"];
    $rcredit = $OrderDtl["reseller_credit"] - $OrderDtl["reseller_discount"];
    $rcredit = $rcredit * $OrderDtl["qnt"];
    if (!function_exists(getClientsDetails)) {
        require_once ROOTDIR . "/includes/clients.fun.inc.php";
    }
    $ClientsDetails = getClientsDetails($OrderDtl["user_id"]);
    if ($OrderDtl["user_can_c"] == 3) {
        if ($ClientsDetails["usertype"] == 0) {
            if ($ClientsDetails["credit"]["credit"] < $credit && (!$config["allowoverdrive"] || !$ClientsDetails["allowoverdrive"] || $ClientsDetails["overdrive"] != 0 && $ClientsDetails["credit"]["credit"] - $credit + $ClientsDetails["overdrive"] < 0)) {
                return $status = [false, $lng_languag["younotenoughcredit"]];
            }
            if ($OrderDtl["retail_shop"]) {
                dquery("UPDATE `tblUsers` SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . ")\n                    WHERE `id`='" . $ClientsDetails["id"] . "'");
            } else {
                if ($changestatus == "new" || $changestatus == "accept") {
                    dquery("UPDATE `tblUsers` SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . "),\n                        `credit_used`=`credit_used`+'" . $credit . "',\n                        `credit_inprocess`=`credit_inprocess`+'" . $credit . "'\n                         WHERE `id`='" . $ClientsDetails["id"] . "'");
                } else {
                    dquery("UPDATE `tblUsers` SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . "),\n                        `credit_used`=`credit_used`+'" . $credit . "'\n                        WHERE `id`='" . $ClientsDetails["id"] . "'");
                }
            }
            if ($changestatus == "new") {
                addStatementuser($ClientsDetails["id"], "Order Set back to New", "DR", $credit, $OrderDtl["order_id"], "imei");
            } else {
                if ($changestatus == "accept") {
                    addStatementuser($ClientsDetails["id"], "Order Set back to Accepted", "DR", $credit, $OrderDtl["order_id"], "imei");
                } else {
                    addStatementuser($ClientsDetails["id"], "Order Set back to Replied", "DR", $credit, $OrderDtl["order_id"], "imei");
                }
            }
        } else {
            if ($ClientsDetails["usertype"] == 1) {
                if (($ClientsDetails["credit"]["credit"] < $credit || $ClientsDetails["credit"]["selling_limit"] < $credit) && (!$config["allowoverdrive"] || !$ClientsDetails["allowoverdrive"] || $ClientsDetails["overdrive"] != 0 && $ClientsDetails["credit"]["credit"] - $credit + $ClientsDetails["overdrive"] < 0)) {
                    return $status = [false, $lng_languag["younotenoughcredit"]];
                }
                if ($OrderDtl["retail_shop"]) {
                    dquery("UPDATE `tblUsers`\n                     SET `credit_left`=`credit_left`-'" . $credit . "'\n                     WHERE `id`='" . $ClientsDetails["id"] . "'");
                } else {
                    if ($changestatus == "new" || $changestatus == "accept") {
                        dquery("UPDATE `tblUsers`\n                         SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . "),\n                        `credit_used`=`credit_used`+'" . $credit . "',`credit_inprocess`=`credit_inprocess`+'" . $credit . "',                    \n                        `sell_credit_limit`=round(sell_credit_limit-'" . $credit . "'," . $precision . ")\n                         WHERE `id`='" . $ClientsDetails["id"] . "'");
                    } else {
                        dquery("UPDATE `tblUsers`\n                         SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . "),\n                        `credit_used`=`credit_used`+'" . $credit . "',                    \n                        `sell_credit_limit`=round(sell_credit_limit-'" . $credit . "'," . $precision . ")\n                         WHERE `id`='" . $ClientsDetails["id"] . "'");
                    }
                }
                if ($changestatus == "new") {
                    addStatementuser($ClientsDetails["id"], "Order Set back to New", "DR", $credit, $OrderDtl["order_id"], "imei", 1);
                } else {
                    if ($changestatus == "accept") {
                        addStatementuser($ClientsDetails["id"], "Order Set back to Accepted", "DR", $credit, $OrderDtl["order_id"], "imei", 1);
                    } else {
                        addStatementuser($ClientsDetails["id"], "Order Set back to Replied", "DR", $credit, $OrderDtl["order_id"], "imei", 1);
                    }
                }
            } else {
                $RClientsDetails = getClientsDetails($ClientsDetails["reseller_id"]);
                if ($ClientsDetails["credit"]["credit"] < $credit || $RClientsDetails["credit"]["credit"] < $rcredit || $RClientsDetails["credit"]["selling_limit"] < $rcredit) {
                    return $status = [false, $lng_languag["younotenoughcredit"]];
                }
                if ($OrderDtl["retail_shop"]) {
                    dquery("UPDATE `tblUsers`\n                     SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . ")\n                     WHERE `id`='" . $ClientsDetails["id"] . "'");
                } else {
                    if ($changestatus == "new" || $changestatus == "accept") {
                        dquery("UPDATE `tblUsers`\n                         SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . "),\n                        `credit_used`=`credit_used`+'" . $credit . "',\n                        `credit_inprocess`=`credit_inprocess`+'" . $credit . "'              \n                         WHERE `id`='" . $ClientsDetails["id"] . "'");
                        dquery("UPDATE `tblUsers`\n                         SET `credit_left`=round(credit_left-'" . $rcredit . "'," . $precision . "),\n                        `credit_used`=`credit_used`+'" . $rcredit . "',\n                        `credit_inprocess`=`credit_inprocess`+'" . $credit . "',\n                        `sell_credit_limit`=`sell_credit_limit`+(" . $credit . "-" . $rcredit . ")\n                         WHERE `id`='" . $RClientsDetails["id"] . "'");
                        resellerState($RClientsDetails["id"], $ClientsDetails["id"], "imei", $OrderDtl["service_id"], $credit - $rcredit);
                    } else {
                        dquery("UPDATE `tblUsers`\n         SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . "),\n        `credit_used`=`credit_used`+'" . $credit . "'\n         WHERE `id`='" . $ClientsDetails["id"] . "'");
                        dquery("UPDATE `tblUsers`\n         SET `credit_left`=round(credit_left-'" . $rcredit . "'," . $precision . "),\n        `credit_used`=`credit_used`+'" . $rcredit . "',\n        `sell_credit_limit`=`sell_credit_limit`+(" . $credit . "-" . $rcredit . ")\n         WHERE `id`='" . $RClientsDetails["id"] . "'");
                        resellerState($RClientsDetails["id"], $ClientsDetails["id"], "imei", $OrderDtl["service_id"], $credit - $rcredit);
                    }
                }
                if ($changestatus == "new") {
                    addStatementuser($ClientsDetails["id"], "Order Set back to New", "DR", $credit, $OrderDtl["order_id"], "imei");
                    addStatementuser($RClientsDetails["id"], "Order Set back to New", "DR", $credit, $OrderDtl["order_id"], "imei");
                } else {
                    if ($changestatus == "accept") {
                        addStatementuser($ClientsDetails["id"], "Order Set back to Accepted", "DR", $credit, $OrderDtl["order_id"], "imei");
                        addStatementuser($RClientsDetails["id"], "Order Set back to Accepted", "DR", $credit, $OrderDtl["order_id"], "imei");
                    } else {
                        addStatementuser($ClientsDetails["id"], "Order Set back to Replied", "DR", $credit, $OrderDtl["order_id"], "imei");
                        addStatementuser($RClientsDetails["id"], "Order Set back to Replied", "DR", $credit, $OrderDtl["order_id"], "imei");
                    }
                }
            }
        }
        if ($changestatus == "new" || $changestatus == "accept") {
            $data = NULL;
            $data["user_can_c"] = $changestatus == "new" ? 0 : 1;
            $data["reply_time"] = "";
            $data["reply_date"] = "";
            $data["apilogreferenceid"] = "";
            $db->update("tbl_order_imei", $data, "order_id=" . $OrderDtl["order_id"]);
            $data = NULL;
            return $status = [true, $lng_languag["orderreplied"]];
        }
        $service = mysqli_fetch_assoc(dquery("select `service_name`,`useasserver`,\n        `template_id1` from `tbl_services_imei` where `id`='" . $OrderDtl["service_id"] . "'"));
        if ($service["useasserver"] == 2) {
            $email_merge_fields["servicetype"] = "Remote";
        } else {
            if ($service["useasserver"] == 1) {
                $email_merge_fields["servicetype"] = "Server";
            } else {
                $email_merge_fields["servicetype"] = "IMEI";
            }
        }
        include_once ROOTDIR . "/includes/customfield.fun.inc.php";
        $customs = getCustomFields("serviceimei", $OrderDtl["service_id"], $OrderDtl["order_id"], "on");
        $email_merge_fields["custom"] = $customs;
        $email_merge_fields["orderid"] = $OrderDtl["encnum"] ? $OrderDtl["encnum"] : $OrderDtl["order_id"];
        $email_merge_fields["service"] = $service["service_name"];
        $email_merge_fields["reply"] = $reply;
        $email_merge_fields["comments"] = $OrderDtl["comments"];
        $email_merge_fields["feedbacklink"] = _url("feedback/u/i/o/" . $orderid, true);
        if ($service["template_id1"] != 0) {
            if ($service["useasserver"] && $service["template_id1"] == 14) {
                $service["template_id1"] = 17;
            }
            sendMail($service["template_id1"], $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true);
        } else {
            if ($service["useasserver"] == 2) {
                sendMail(84, $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true, "", "", "", "", "", "", "", "", "", "", "remoteorder");
            } else {
                if ($service["useasserver"] == 1) {
                    sendMail(17, $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true, "", "", "", "", "", "", "", "", "", "", "imeiorder");
                } else {
                    sendMail(14, $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true);
                }
            }
        }
        $data = NULL;
        $data["user_can_c"] = 4;
        $data["reply"] = $reply;
        if (count($replyarr)) {
            $data["verifydata"] = json_encode($replyarr);
        }
        $data["reply_time"] = time();
        $data["reply_date"] = date("Y-m-d");
        $data["apilogreferenceid"] = $apilogreferenceid;
        if ($adminid == 99999 && isset($_SESSION["adminid"])) {
            $data["reply_by_admin"] = $_SESSION["adminid"];
        } else {
            $data["reply_by_admin"] = $adminid;
        }
        if ($suplierid) {
            $data["reply_by_sup"] = $suplierid;
        } else {
            if ($apiid) {
                $data["reply_by_api"] = $apiid;
            }
        }
        $db->update("tbl_order_imei", $data, "order_id=" . $OrderDtl["order_id"]);
        if ($OrderDtl["responseno"]) {
            $error = sendSMS($OrderDtl["responseno"], 1, "", ["ORDER" => $OrderDtl["imei"], "REPLY" => $reply], $OrderDtl["user_id"]);
        }
        $sql = dquery("select reseller_id,reseller_discount,\n        (select store from tbl_services_imei where id=service_id) as stor\n        from tbl_order_imei where " . $WHERE . " AND retail_shop=1");
        if ($ClientsDetails["messengerid"]) {
            $emoticons = "✅";
            $Status = json_decode("\"" . $emoticons . "\"");
            $sendmessage = $Status . "<b>" . ($OrderDtl[imei] ? $OrderDtl[imei] : $OrderDtl[order_id]) . (!$OrderDtl[imei] ? " x " . $OrderDtl[qnt] : "") . "</b>\n<pre>" . strip_tags(br2nl($reply)) . "</pre>\n<i>" . $service["service_name"] . "</i>";
            foreach ($customs as $fielddetail) {
                $sendmessage .= "\n" . $fielddetail["name"] . " " . $fielddetail["value"];
            }
            sendTelegramMessage(urlencode($sendmessage), $ClientsDetails["messengerid"]);
        }
        if (mysqli_num_rows($sql)) {
            $disc = mysqli_fetch_assoc($sql);
            if ($disc["stor"]) {
                $user = mysqli_fetch_assoc(dquery("select default_currency from tblUsers where id='" . $userid . "'"));
                $resell = mysqli_fetch_assoc(dquery("select default_currency from tblUsers where id='" . $disc["reseller_id"] . "'"));
                if ($user["default_currency"] != $resell["default_currency"]) {
                    $disc["reseller_discount"] = round(convertCurrency($disc["reseller_discount"], $user["default_currency"], $resell["default_currency"]), $precision);
                } else {
                    $disc["reseller_discount"] = round($disc["reseller_discount"], $precision);
                }
                if (0 < $disc["reseller_discount"]) {
                    $query3 = "UPDATE tblUsers SET \n                    credit_left=credit_left+" . $disc["reseller_discount"] . " \n                    WHERE id='" . $disc["reseller_id"] . "'";
                    full_query($query3);
                    addStatementuser($disc["reseller_id"], "Reseller Store Commision (invoice #" . $invoiceid . ")", "CR", $disc["reseller_discount"], $invoiceid);
                    include_once ROOTDIR . "/includes/mail.fun.php";
                    sendMail(59, $disc["reseller_id"], "", ["amount" => $disc["reseller_discount"]]);
                }
            }
        }
        updateRetailOrderStatusbyOrderID($OrderDtl[order_id]);
    } else {
        if ($OrderDtl["user_can_c"] == 0 || $OrderDtl["user_can_c"] == 1 || $OrderDtl["user_can_c"] == 8) {
            if (!$OrderDtl["retail_shop"]) {
                dquery("UPDATE `tblUsers` SET \n            `credit_inprocess`=round(credit_inprocess-'" . $credit . "'," . $precision . ")\n             WHERE `id`='" . $ClientsDetails["id"] . "'");
            }
            if ($ClientsDetails["usertype"] == 3) {
                $resellerDetails = getClientsDetails($ClientsDetails["reseller_id"]);
                if (!$OrderDtl["retail_shop"]) {
                    dquery("UPDATE `tblUsers` SET \n                `credit_inprocess`=round(credit_inprocess-'" . $rcredit . "'," . $precision . ")\n                WHERE `id`='" . $resellerDetails["id"] . "'");
                }
            }
            $data = NULL;
            $data["user_can_c"] = 4;
            $data["reply"] = $reply;
            if (count($replyarr)) {
                $data["verifydata"] = json_encode($replyarr);
            }
            $data["reply_time"] = time();
            $data["reply_date"] = date("Y-m-d");
            $data["apilogreferenceid"] = $apilogreferenceid;
            if ($adminid) {
                if ($adminid == 99999 && isset($_SESSION["adminid"])) {
                    $data["reply_by_admin"] = $_SESSION["adminid"];
                } else {
                    $data["reply_by_admin"] = $adminid;
                }
            } else {
                if ($suplierid) {
                    $data["reply_by_sup"] = $suplierid;
                } else {
                    if ($apiid) {
                        $data["reply_by_api"] = $apiid;
                    }
                }
            }
            $db->update("tbl_order_imei", $data, "order_id=" . $OrderDtl["order_id"]);
            $service = mysqli_fetch_assoc(dquery("select `service_name`,useasserver,\n        `template_id1` from `tbl_services_imei` where \n        `id`='" . $OrderDtl["service_id"] . "'"));
            include_once ROOTDIR . "/includes/customfield.fun.inc.php";
            $customs = getCustomFields("serviceimei", $OrderDtl["service_id"], $OrderDtl["order_id"], "on");
            $email_merge_fields["custom"] = $customs;
            if ($service["template_id1"] == 0) {
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["servicetype"] = "IMEI";
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["orderid"] = $OrderDtl["order_id"];
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["service"] = $service["service_name"];
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["reply"] = $reply;
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["comments"] = $OrderDtl["comments"];
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["imei"] = $OrderDtl["imei"];
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["notes"] = $OrderDtl["note"];
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["ordercredit"] = $OrderDtl["credit"] - $OrderDtl["discount"];
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["pin"] = $OrderDtl["PIN"];
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["kbh"] = $OrderDtl["KBH"];
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["prd"] = $OrderDtl["PRD"];
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["type"] = $OrderDtl["Type"];
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["reference"] = $OrderDtl["Reference"];
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["locks"] = $OrderDtl["Locks"];
                $models = mysqli_fetch_assoc(dquery("SELECT `Name` FROM \n            tbl_mobile WHERE ID='" . $OrderDtl["model_id"] . "'"));
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["model"] = $models["Name"];
                $models = mysqli_fetch_assoc(dquery("SELECT Name FROM \n            tbl_provider WHERE ID='" . $OrderDtl["provider_id"] . "'"));
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["provider"] = $models["Name"];
                $models = mysqli_fetch_assoc(dquery("SELECT mep FROM \n            tbl_mep WHERE ID='" . $OrderDtl["mep"] . "'"));
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["mep"] = $models["mep"];
                include_once ROOTDIR . "/includes/customfield.fun.inc.php";
                $customs = getCustomFields("serviceimei", $OrderDtl["service_id"], $OrderDtl["order_id"], "on");
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["custom"] = $customs;
                $email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]["templateid"] = $service["template_id1"];
                if (!$fromcron && ($adminid == 99999 || $apiid)) {
                    if ($service["useasserver"] == 2) {
                        sendMail(84, $OrderDtl["user_id"], $OrderDtl["order_id"], $email_merge_fields, true, "", "", "", "", "", "", "", "", "", "", "imeiorder");
                    } else {
                        if ($service["useasserver"] == 1) {
                            sendMail(17, $OrderDtl["user_id"], $OrderDtl["order_id"], $email_merge_fields, true, "", "", "", "", "", "", "", "", "", "", "imeiorder");
                        } else {
                            sendMail(14, $OrderDtl["user_id"], $OrderDtl["order_id"], $email_merge_fields, true);
                        }
                    }
                }
            }
            if ($ClientsDetails["messengerid"]) {
                $emoticons = "✅";
                $Status = json_decode("\"" . $emoticons . "\"");
                $sendmessage = $Status . "<b>" . ($OrderDtl[imei] ? $OrderDtl[imei] : $OrderDtl[order_id]) . (!$OrderDtl[imei] ? " x " . $OrderDtl[qnt] : "") . "</b>\n<pre>" . strip_tags(br2nl($reply)) . "</pre>\n<i>" . $service["service_name"] . "</i>";
                foreach ($customs as $fielddetail) {
                    $sendmessage .= "\n" . $fielddetail["name"] . " " . $fielddetail["value"];
                }
                sendTelegramMessage(urlencode($sendmessage), $ClientsDetails["messengerid"]);
            }
            if ($service["template_id1"] != 0) {
                $email_merge_fields2["reply"] = $reply;
                $email_merge_fields2["feedbacklink"] = _url("feedback/u/i/o/" . $orderid, true);
                $email_merge_fields2["service"] = $service["service_name"];
                sendMail($service["template_id1"], $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields2, true);
                unset($email_merge_fields[$ClientsDetails["id"]][$OrderDtl["order_id"]]);
            }
            if ($OrderDtl["responseno"]) {
                $error = sendSMS($OrderDtl["responseno"], 1, "", ["ORDER" => $OrderDtl["imei"], "REPLY" => $reply], $OrderDtl["user_id"]);
            }
            updateRetailOrderStatusbyOrderID($OrderDtl[order_id]);
        }
    }
    if ($OrderDtl["retail_shop"]) {
    }
    return $status = [true, $lng_languag["orderreplied"]];
}
function replyRejectIMEI_sendmail()
{
    global $email_merge_fieldsnew;
    global $OrderDtl;
    include_once ROOTDIR . "/includes/mail.fun.php";
    if (is_array($email_merge_fieldsnew)) {
        foreach ($email_merge_fieldsnew as $k => $v) {
            if (is_array($v)) {
                $MailArr = [];
                foreach ($v as $oid => $details) {
                    $MailArr["service"][$oid] = $details["service"];
                    $MailArr["reason"][$oid] = $details["reason"];
                    $MailArr["imei"][$oid] = $details["imei"];
                    $MailArr["username"] = $details["username"];
                    $MailArr["orders"][$oid] = $details["orders"];
                }
                sendMail(83, $k, $OrderDtl["order_id"], $MailArr, true);
            }
        }
    }
}
function replySuccessIMEI_sendmail()
{
    global $email_merge_fields;
    global $OrderDtl;
    include_once ROOTDIR . "/includes/mail.fun.php";
    if (is_array($email_merge_fields)) {
        foreach ($email_merge_fields as $k => $v) {
            if (is_array($v)) {
                $v["replyarry"] = $v;
                sendMail(64, $k, $OrderDtl["order_id"], $v, true);
            }
        }
    }
}
function rejectIMEI($orderid, $reply, $adminid = "", $suplierid = "", $apiid = "", $apilogreferenceid = "", $nomd5 = "", $nomail = true)
{
    include_once ROOTDIR . "/includes/mail.fun.php";
    global $config;
    global $db;
    global $lng_languag;
    global $email_merge_fieldsnew;
    global $precision;
    $status = NULL;
    if ($nomd5) {
        $WHERE = "order_id='" . $nomd5 . "'";
    } else {
        $WHERE = "md5(order_id)='" . $orderid . "'";
    }
    $reply = filter_var($reply, FILTER_SANITIZE_STRING);
    $OrderDtl = mysqli_fetch_assoc(dquery("SELECT `order_id`,`qnt`,`subscribe`,\n    `imei`,`reseller_id`,`user_can_c`,`credit`,points,`responseno`,(select point from tbl_services_imei\n    where tbl_services_imei.id=service_id) as reward,\n    `discount`,`reseller_credit`,`reseller_discount`,\n    `user_id`,`retail_shop`,`service_id`,`comments` \n    FROM `tbl_order_imei` WHERE " . $WHERE));
    if ($OrderDtl["user_can_c"] == 8) {
        $OrderDtl["user_can_c"] = 1;
    }
    if (!$OrderDtl["qnt"]) {
        $OrderDtl["qnt"] = 1;
    }
    if ($OrderDtl["user_can_c"] == 4) {
        if (!(isset($_SESSION["rejectorderbyadmin"]) && $_SESSION["rejectorderbyadmin"] == 1)) {
            return $status = [false, "You are not allowed to Reject Order"];
        }
    }
    if ($OrderDtl["user_can_c"] == 3) {
        return $status = [false, ""];
    }
    $data = NULL;
    $data["user_can_c"] = 3;
    $rejectstatus = $db->update("tbl_order_imei", $data, "order_id='" . $OrderDtl["order_id"] . "'");
    $data = NULL;
    if ($OrderDtl["reward"]) {
        $Points = mysqli_fetch_assoc(dquery("select cr from tbl_statement_points \nwhere uid='" . $OrderDtl["user_id"] . "' and orderid='" . $OrderDtl["order_id"] . "' and cr>0 order by pointid desc"));
        if ($Points["cr"]) {
            processPoints($OrderDtl[user_id], 0, $Points["cr"], $OrderDtl["order_id"]);
        }
    }
    if ($OrderDtl["points"]) {
        processPoints($OrderDtl[user_id], $OrderDtl["points"], 0, $OrderDtl["order_id"]);
    }
    if ($rejectstatus) {
        $credit = round($OrderDtl["credit"] - $OrderDtl["discount"], $precision);
        $rcredit = round($OrderDtl["reseller_credit"] - $OrderDtl["reseller_discount"], $precision);
        $credit = $credit * $OrderDtl["qnt"];
        $rcredit = $rcredit * $OrderDtl["qnt"];
        $ClientsDetails = mysqli_fetch_assoc(dquery("SELECT id,reseller_id,username,usertype,messengerid FROM `tblUsers`\n     WHERE `id`='" . $OrderDtl["user_id"] . "'"));
        if ($OrderDtl["user_can_c"] == 4) {
            if ($ClientsDetails["usertype"] == 0) {
                if ($OrderDtl["retail_shop"]) {
                    dquery("UPDATE `tblUsers` SET `credit_left`=`credit_left`+'" . $credit . "'\n                    WHERE `id`='" . $ClientsDetails["id"] . "'");
                } else {
                    dquery("UPDATE `tblUsers` SET `credit_left`=`credit_left`+'" . $credit . "',\n                  `credit_used`=`credit_used`-'" . $credit . "'\n                   WHERE `id`='" . $ClientsDetails["id"] . "'");
                }
                addStatementuser($ClientsDetails["id"], "Order Set back to Rejected", "CR", $credit, $OrderDtl["order_id"], "imei");
            } else {
                if ($ClientsDetails["usertype"] == 1) {
                    if ($OrderDtl["retail_shop"]) {
                        dquery("UPDATE `tblUsers`\n                    SET `credit_left`=`credit_left`+'" . $credit . "'\n                    WHERE `id`='" . $ClientsDetails["id"] . "'");
                    } else {
                        dquery("UPDATE `tblUsers`\n                     SET `credit_left`=`credit_left`+'" . $credit . "',\n                    `credit_used`=`credit_used`-'" . $credit . "',                    \n                    `sell_credit_limit`=`sell_credit_limit`+'" . $credit . "'\n                     WHERE `id`='" . $ClientsDetails["id"] . "'");
                    }
                    addStatementuser($ClientsDetails["id"], "Order Set back to Rejected", "CR", $credit, $OrderDtl["order_id"], "imei", 1);
                } else {
                    $RClientsDetails = mysqli_fetch_assoc(dquery("SELECT id,reseller_id,username,usertype,messengerid FROM `tblUsers`\n     WHERE `id`='" . $ClientsDetails["reseller_id"] . "'"));
                    if ($OrderDtl["retail_shop"]) {
                        dquery("UPDATE `tblUsers`\n                     SET `credit_left`=`credit_left`+'" . $credit . "'\n                     WHERE `id`='" . $ClientsDetails["id"] . "'");
                    } else {
                        dquery("UPDATE `tblUsers`\n                     SET `credit_left`=`credit_left`+'" . $credit . "',\n                    `credit_used`=round(credit_used-'" . $credit . "'," . $precision . ")\n                     WHERE `id`='" . $ClientsDetails["id"] . "'");
                        dquery("UPDATE `tblUsers`\n                     SET `credit_left`=`credit_left`+'" . $rcredit . "',\n                    `credit_used`=round(credit_used-'" . $rcredit . "'," . $precision . "),\n                    `sell_credit_limit`=`sell_credit_limit`-(" . $credit . "-" . $rcredit . ")\n                     WHERE `id`='" . $RClientsDetails["id"] . "'");
                        resellerState($RClientsDetails["id"], $ClientsDetails["id"], "imei", $OrderDtl["service_id"], "-" . ($credit - $rcredit));
                    }
                    addStatementuser($ClientsDetails["id"], "Order Set back to Rejected", "CR", $credit, $OrderDtl["order_id"], "imei");
                    addStatementuser($RClientsDetails["id"], "Order Set back to Rejected", "CR", $rcredit, $OrderDtl["order_id"], "imei");
                }
            }
            $service = mysqli_fetch_assoc(dquery("select `service_name`,useasserver,\n        `template_id2` from `tbl_services_imei` where `id`='" . $OrderDtl["service_id"] . "'"));
            $email_merge_fields["username"] = $ClientsDetails["username"];
            $email_merge_fields["service"] = $service["service_name"];
            $email_merge_fields["reason"] = $reply;
            if ($service["template_id2"] != 0) {
                sendMail($service["template_id2"], $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true);
            } else {
                if ($service["useasserver"] == 2) {
                    sendMail(85, $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true, "", "", "", "", "", "", "", "", "", "", "imeiorder");
                } else {
                    if ($service["useasserver"] == 1) {
                        sendMail(45, $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true, "", "", "", "", "", "", "", "", "", "", "imeiorder");
                    } else {
                        sendMail(6, $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true);
                    }
                }
            }
            $data = NULL;
            $data["user_can_c"] = 3;
            $data["reply"] = $reply;
            $data["reply_time"] = time();
            $data["reply_date"] = date("Y-m-d");
            $data["apilogreferenceid"] = $apilogreferenceid;
            if ($adminid) {
                $data["reply_by_admin"] = $adminid;
            } else {
                if ($suplierid) {
                    $data["reply_by_sup"] = $suplierid;
                } else {
                    if ($apiid) {
                        $data["reply_by_api"] = $apiid;
                    }
                }
            }
            $db->update("tbl_order_imei", $data, "order_id='" . $OrderDtl["order_id"] . "'");
            if ($OrderDtl["responseno"]) {
                sendSMS($OrderDtl["responseno"], 1, "", ["ORDER" => $OrderDtl["imei"], "REPLY" => $reply], $OrderDtl["user_id"]);
            }
            if ($OrderDtl["subscribe"]) {
                dquery("UPDATE tbl_subscribers set used=used-1 WHERE service_id='" . $OrderDtl["service_id"] . "' AND user_id='" . $OrderDtl["user_id"] . "'\n    \t\t    AND `type`='tbl_services_imei'");
            }
            $pr = mysqli_fetch_assoc(dquery("select reseller_id,invoiceid,(select username \n            from tblUsers where id=user_id) as user,\n            reseller_discount,order_id,(select store from tbl_services_imei where id=service_id) as stor\n            from tbl_order_imei where md5(order_id)='" . $orderid . "' AND retail_shop=1"));
            if ($pr["stor"] && $pr["reseller_discount"] && $pr["reseller_id"]) {
                dquery("UPDATE tblUsers SET credit_left=round((credit_left-" . $pr["reseller_discount"] . ")," . $precision . ") \n                                        WHERE id='" . $pr["reseller_id"] . "'");
                addStatementuser($pr["reseller_id"], "Reseller Store Commision Rebate IMEI (Order ID #" . $pr["order_id"] . ")", "DR", $pr["reseller_discount"], $pr["invoiceid"]);
                $date = date("Y-m-d H:i:s");
                $desc = "Order ID : " . $pr["order_id"] . " \n                        Commision : " . $pr["reseller_discount"] . "\n                        ReselerID : " . $pr["reseller_id"] . "\n                       Invoice Id : " . $pr["invoiceid"] . "\n                             Page : " . $_SERVER["REQUEST_URI"];
                $user = $pr["user"];
                dquery("INSERT INTO tbl_system_activity \n                (date,description,user) values('" . $date . "','" . $desc . "','" . $user . "')");
            }
            if ($ClientsDetails["messengerid"]) {
                $emoticons = "❌";
                $Status = json_decode("\"" . $emoticons . "\"");
                sendTelegramMessage(urlencode($Status . "<b>" . ($OrderDtl[imei] ? $OrderDtl[imei] : $OrderDtl[order_id]) . "</b>\n<pre>" . strip_tags(br2nl($reply)) . "</pre>\n<i>" . $service["service_name"] . "</i>"), $ClientsDetails["messengerid"]);
            }
            updateRetailOrderStatusbyOrderID($OrderDtl[order_id]);
            return $status = [true, $lng_languag["orderrejected"]];
        }
        if ($OrderDtl["user_can_c"] == 0 || $OrderDtl["user_can_c"] == 1) {
            if ($ClientsDetails["usertype"] == 0) {
                if ($OrderDtl["retail_shop"]) {
                    dquery("UPDATE `tblUsers` SET `credit_left`=`credit_left`+'" . $credit . "'\n                    WHERE `id`='" . $ClientsDetails["id"] . "'");
                } else {
                    dquery("UPDATE `tblUsers` SET `credit_left`=`credit_left`+'" . $credit . "',\n                    `credit_inprocess`=round(credit_inprocess-'" . $credit . "'," . $precision . "),\n                    `credit_used`=round(credit_used-'" . $credit . "'," . $precision . ")\n                     WHERE `id`='" . $ClientsDetails["id"] . "'");
                }
                addStatementuser($ClientsDetails["id"], "Order Rejected", "CR", $credit, $OrderDtl["order_id"], "imei");
            } else {
                if ($ClientsDetails["usertype"] == 1) {
                    if ($OrderDtl["retail_shop"]) {
                        dquery("UPDATE `tblUsers`\n                     SET `credit_left`=`credit_left`+'" . $credit . "'\n                     WHERE `id`='" . $ClientsDetails["id"] . "'");
                    } else {
                        dquery("UPDATE `tblUsers`\n                    SET `credit_left`=`credit_left`+'" . $credit . "',\n                    `credit_inprocess`=round(credit_inprocess-'" . $credit . "'," . $precision . "),\n                    `credit_used`=round(credit_used-'" . $credit . "'," . $precision . "),                    \n                    `sell_credit_limit`=`sell_credit_limit`+'" . $credit . "'\n                     WHERE `id`='" . $ClientsDetails["id"] . "'");
                    }
                    addStatementuser($ClientsDetails["id"], "Order Rejected", "CR", $credit, $OrderDtl["order_id"], "imei", 1);
                } else {
                    if (!function_exists(getClientsDetails)) {
                        require_once ROOTDIR . "/includes/clients.fun.inc.php";
                    }
                    $RClientsDetails = getClientsDetails($ClientsDetails["reseller_id"]);
                    if ($OrderDtl["retail_shop"]) {
                        dquery("UPDATE `tblUsers`\n                     SET `credit_left`=`credit_left`+'" . $credit . "'\n                     WHERE `id`='" . $ClientsDetails["id"] . "'");
                    } else {
                        dquery("UPDATE `tblUsers`\n                 SET `credit_left`=`credit_left`+'" . $credit . "',\n                 `credit_inprocess`=round(credit_inprocess-'" . $credit . "'," . $precision . "),\n                 `credit_used`=round(credit_used-'" . $credit . "'," . $precision . ")\n                 WHERE `id`='" . $ClientsDetails["id"] . "'");
                        dquery("UPDATE `tblUsers`\n                 SET `credit_left`=`credit_left`+'" . $rcredit . "',\n                 `credit_inprocess`=round(credit_inprocess-'" . $rcredit . "'," . $precision . "),\n                 `sell_credit_limit`=`sell_credit_limit`-(" . $credit . "-" . $rcredit . "),\n                 `credit_used`=round(credit_used-'" . $rcredit . "'," . $precision . ")\n                 WHERE `id`='" . $RClientsDetails["id"] . "'");
                        resellerState($RClientsDetails["id"], $ClientsDetails["id"], "imei", $OrderDtl["service_id"], "-" . ($credit - $rcredit));
                    }
                    addStatementuser($ClientsDetails["id"], "Order Rejected", "CR", $credit, $OrderDtl["order_id"], "imei");
                    addStatementuser($RClientsDetails["id"], "Order Rejected", "CR", $rcredit, $OrderDtl["order_id"], "imei");
                }
            }
            $data = NULL;
            $data["user_can_c"] = 3;
            $data["reply"] = $reply;
            $data["reply_time"] = time();
            $data["reply_date"] = date("Y-m-d");
            $data["apilogreferenceid"] = $apilogreferenceid;
            if ($adminid) {
                $data["reply_by_admin"] = $adminid;
            } else {
                if ($suplierid) {
                    $data["reply_by_sup"] = $suplierid;
                } else {
                    if ($apiid) {
                        $data["reply_by_api"] = $apiid;
                    }
                }
            }
            $db->update("tbl_order_imei", $data, "order_id='" . $OrderDtl["order_id"] . "'");
            $service = mysqli_fetch_assoc(dquery("select `service_name`,useasserver,`template_id2`,`stock_allow` from `tbl_services_imei` where `id`='" . $OrderDtl["service_id"] . "'"));
            $email_merge_fields["username"] = $ClientsDetails["username"];
            $email_merge_fields["service"] = $service["service_name"];
            $email_merge_fields["reason"] = $reply;
            if ($service["template_id2"] != 0) {
                sendMail($service["template_id2"], $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true);
            } else {
                $email_merge_fieldsnew[$ClientsDetails["id"]][$OrderDtl["order_id"]]["custom"] = $customs;
                $email_merge_fieldsnew[$ClientsDetails["id"]][$OrderDtl["order_id"]]["reason"] = $reply;
                $email_merge_fieldsnew[$ClientsDetails["id"]][$OrderDtl["order_id"]]["imei"] = $OrderDtl["imei"];
                $email_merge_fieldsnew[$ClientsDetails["id"]][$OrderDtl["order_id"]]["service"] = $service["service_name"];
                $email_merge_fieldsnew[$ClientsDetails["id"]][$OrderDtl["order_id"]]["username"] = $ClientsDetails["username"];
                $email_merge_fieldsnew[$ClientsDetails["id"]][$OrderDtl["order_id"]]["orders"] = $OrderDtl["order_id"];
                if ($nomail) {
                    if ($service["useasserver"] == 2) {
                        sendMail(85, $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true, "", "", "", "", "", "", "", "", "", "", "imeiorder");
                    } else {
                        if ($service["useasserver"] == 1) {
                            sendMail(45, $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true, "", "", "", "", "", "", "", "", "", "", "imeiorder");
                        } else {
                            sendMail(6, $ClientsDetails["id"], $OrderDtl["order_id"], $email_merge_fields, true);
                        }
                    }
                }
            }
            if ($service["stock_allow"]) {
                dquery("UPDATE `tbl_services_imei` SET `stock`=`stock`+1 where id='" . $OrderDtl["service_id"] . "'");
            }
            if ($OrderDtl["responseno"]) {
                $error = sendSMS($OrderDtl["responseno"], 1, "", ["ORDER" => $OrderDtl["imei"], "REPLY" => $reply], $OrderDtl["user_id"]);
            }
            if ($OrderDtl["subscribe"]) {
                dquery("UPDATE tbl_subscribers set used=used-1 WHERE service_id='" . $OrderDtl["service_id"] . "' AND user_id='" . $OrderDtl["user_id"] . "'\n    \t\tAND type='tbl_services_imei'");
            }
            $pr = mysqli_fetch_assoc(dquery("select reseller_id,invoiceid,(select username \n from tblUsers where id=user_id) as user,\n reseller_discount,order_id,(select store from tbl_services_imei where id=service_id) as stor\n  from tbl_order_imei where md5(order_id)='" . $orderid . "' AND retail_shop='1'"));
            if ($pr["stor"] && $pr["reseller_discount"] && $pr["reseller_id"]) {
                dquery("UPDATE tblUsers SET credit_left=round((credit_left-" . $pr["reseller_discount"] . ")," . $precision . ") \n                                        WHERE id='" . $pr["reseller_id"] . "'");
                addStatementuser($pr["reseller_id"], "Reseller Store Commision Rebate IMEI (Order ID #" . $pr["order_id"] . ")", "DR", $pr["reseller_discount"], $pr["invoiceid"]);
            }
            if ($ClientsDetails["messengerid"]) {
                $emoticons = "❌";
                $Status = json_decode("\"" . $emoticons . "\"");
                sendTelegramMessage(urlencode($Status . "<b>" . ($OrderDtl[imei] ? $OrderDtl[imei] : $OrderDtl[order_id]) . "</b>\n<pre>" . strip_tags(br2nl($reply)) . "</pre>\n<i>" . $service["service_name"] . "</i>"), $ClientsDetails["messengerid"]);
            }
            updateRetailOrderStatusbyOrderID($OrderDtl[order_id]);
            return $status = [true, $lng_languag["orderrejected"]];
        }
    } else {
        dquery("UPDATE tbl_order_imei set user_can_c='" . $OrderDtl["user_can_c"] . "'\n        where order_id='" . $OrderDtl["order_id"] . "'");
        $data = NULL;
        $data["user_can_c"] = $OrderDtl["user_can_c"];
        $db->update("tbl_order_imei", $data, "order_id='" . $OrderDtl["order_id"] . "'");
        $data = NULL;
        updateRetailOrderStatusbyOrderID($OrderDtl[order_id]);
    }
}
function creditProcessIMEI($_ClientsDetails, $serviceDetails, $direct = "", $point = false)
{
    include_once ROOTDIR . "/includes/mail.fun.php";
    global $lng_languag;
    global $imei_placed;
    global $config;
    global $remote_ip;
    global $qnt;
    global $orderfrom;
    global $customfield;
    $return = NULL;
    $placed = 0;
    if (!function_exists(getClientsDetails)) {
        require_once ROOTDIR . "/includes/clients.fun.inc.php";
    }
    if ($config["idverification"]) {
        $cgid = $_ClientsDetails["client_group"];
        if ($cgid) {
            if (mysqli_num_rows(dquery("select id from tbl_client_group\n where idverification=1 and id='" . $cgid . "'")) && !$_ClientsDetails["idverification"]) {
                if (API == "1") {
                    return "ID Verification/KYC is required";
                }
                return "error:" . "<li>" . $lng_languag["idverifkyc"] . ". <a href='" . _url("settings/action/idverification") . "'>Click here to process.</a> </li>";
            }
        } else {
            if ($config["defaultgroupverification"] && !$_ClientsDetails["idverification"]) {
                if (API == "1") {
                    return "ID Verification/KYC is required";
                }
                return "error:" . "<li>" . $lng_languag["idverifkyc"] . ". <a href='" . _url("settings/action/idverification") . "'>Click here to process.</a> </li>";
            }
        }
    }
    if ($serviceDetails["id"]) {
        $time = time();
        $day = 86400;
        if ($serviceDetails["avgexetime"] + $day < $time) {
            $calcilate = mysqli_fetch_assoc(dquery("select \n            sum(reply_time-time) as avgs from tbl_order_imei\n            where user_can_c=4  and service_id='" . $serviceDetails["id"] . "'\n            and time>'" . $serviceDetails["avgexetime"] . "'\n            order by order_id desc limit 10"));
            if ($calcilate["avgs"]) {
                dquery("update tbl_services_imei set avgdeliverytime='" . $calcilate["avgs"] . "',avgexetime='" . $time . "'\n            WHERE id='" . $serviceDetails["id"] . "'");
            }
        }
    }
    if (!$point && $serviceDetails["credit"] == 0 && !$serviceDetails["free"]) {
        if (API == "1") {
            return "Internal System Error Contact Us";
        }
        return "error:<li>Internal System Error Contact Us</li>";
    }
    if ($direct) {
        $wql = mysqli_fetch_assoc(dquery("select qnt \n        from tbl_private_order where email='" . $_ClientsDetails["email"] . "' \n        and sid='" . $serviceDetails["id"] . "' and qnt>0 and CONCAT(MD5(SHA1(uid)))='" . $_SESSION["unqid"] . "'"));
        if ($wql["qnt"] < count($imei_placed)) {
            return "error: <li>Exceed order than limit</li>";
        }
        foreach ($imei_placed as $imei) {
            $serviceDetails = getimeiservices("", md5($serviceDetails["id"]), "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", $qnt);
            $return = creditProcessIMEIDirect($_ClientsDetails, $serviceDetails, $imei, $direct);
            if ($return[0]) {
                $placed++;
            }
            $_SESSION["directorder"]++;
        }
    } else {
        if (!$point) {
            if ($_ClientsDetails["usertype"] == 0) {
                foreach ($imei_placed as $imei) {
                    $_ClientsDetails = getClientsDetails($_ClientsDetails["id"]);
                    $serviceDetails = getimeiservices("", md5($serviceDetails["id"]), $_SESSION["uid"], true, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", $qnt);
                    $return = creditProcessUser($_ClientsDetails, $serviceDetails, $imei);
                    if ($return[0]) {
                        $placed++;
                    }
                }
            } else {
                if ($_ClientsDetails["usertype"] == 1) {
                    foreach ($imei_placed as $imei) {
                        $_ClientsDetails = getClientsDetails($_ClientsDetails["id"]);
                        $serviceDetails = getimeiservices("", md5($serviceDetails["id"]), $_SESSION["uid"], true, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", $qnt);
                        $return = creditProcessReseller($_ClientsDetails, $serviceDetails, $imei);
                        if ($return[0]) {
                            $placed++;
                        }
                    }
                } else {
                    if ($_ClientsDetails["usertype"] == 3) {
                        foreach ($imei_placed as $imei) {
                            $_ClientsDetails = getClientsDetails($_ClientsDetails["id"]);
                            $serviceDetails = getimeiservices("", md5($serviceDetails["id"]), $_SESSION["uid"], true, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", $qnt);
                            $return = creditProcessResellersUser($_ClientsDetails, $serviceDetails, $imei);
                            if ($return[0]) {
                                $placed++;
                            }
                        }
                        $reseller = mysqli_fetch_assoc(dquery("SELECT `email`,`reseller_can_setupstore` FROM `tblUsers` WHERE `id`='" . $_ClientsDetails["reseller_id"] . "'"));
                        if ($return[0] && $config["reseller_can_setup_store"] && $reseller["reseller_can_setupstore"] && $config["SENDMAIL_newordernotificationtoreseller"]) {
                            $serviceDetails["notification_mail"] .= ", " . $reseller["email"];
                        }
                    }
                }
            }
        } else {
            foreach ($imei_placed as $imei) {
                $Available = getRewardPoint($_SESSION["uid"]);
                if ($qnt * $serviceDetails["purchasepoint"] < $Available) {
                    $return = creditProcessUser($_ClientsDetails, $serviceDetails, $imei, $point);
                    if ($return[0]) {
                        $UsedPOint = $serviceDetails["purchasepoint"];
                        dquery("update tbl_order_imei set credit='0',discount='0',points='" . $UsedPOint . "' where order_id='" . $return[2] . "'");
                        $placed++;
                    }
                }
            }
        }
    }
    if (0 < $serviceDetails["point"]) {
        processPoints($_SESSION["uid"], $serviceDetails["point"], 0, $return[2]);
    }
    if ($return[0]) {
        if ($return[2]) {
            $order = mysqli_fetch_assoc(dquery("select \n            credit,qnt,discount,(select value from tbl_apiservers where gateway=(select API\n            from tbl_services_imei where id=service_id) AND setting = 'name') as apiname\n            from tbl_order_imei where order_id='" . $return[2] . "'"));
        }
        $ArrayForCustomField = [];
        foreach ($customfield as $cid => $cvalue) {
            $cname = mysqli_fetch_assoc(dquery("select * from tbl_customfields where id='" . $cid . "'"));
            $ArrayForCustomField[] = $cname["fieldname"] . " : " . $cvalue;
        }
        if ($serviceDetails["useasserver"]) {
            $SERVICEFIELD = "newserver_services";
            $adminmessage = "Service Name: " . $serviceDetails["service_name"] . "<br><Br>Server:<br><br> ";
            if ($config["slack_serverordernotification"]) {
                $_cols[0]["titel"] = $serviceDetails["service_name"];
                $_cols[0]["text"] = $serviceDetails["useasserver"] == 1 ? "SERVER :" : ($serviceDetails["useasserver"] == 2 ? " Remote :" : " IMEI:");
                foreach ($imei_placed as $imei) {
                    $_cols[0]["text"] .= $imei . " ";
                }
                $_cols[1]["titel"] = $_ClientsDetails["username"];
                $_cols[1]["text"] = $order["credit"] - $order["discount"] . "" . $_ClientsDetails["currency"]["code"];
                $_cols[2]["titel"] = "Qty:";
                $_cols[2]["text"] = $order["qnt"];
                $callwithout[100]["titel"] = "";
                $callwithout[100]["text"] = implode("\n", $ArrayForCustomField);
                SlackSendMsg($config["slack_serverordernotification"], ($serviceDetails["useasserver"] == 1 ? "SERVER" : ($serviceDetails["useasserver"] == 2 ? "Remote" : "IMEI")) . " New Order Placed #" . $return[2], $serviceDetails["colortag"] ? $serviceDetails["colortag"] : "good", $_cols, false, "", $callwithout);
            } else {
                if ($serviceDetails["orderslack"]) {
                    $_cols[0]["titel"] = $serviceDetails["service_name"];
                    foreach ($imei_placed as $imei) {
                        $_cols[0]["text"] .= $imei . " ";
                    }
                    $_cols[1]["titel"] = $_ClientsDetails["username"];
                    $_cols[1]["text"] = $order["credit"] - $order["discount"] . "" . $_ClientsDetails["currency"]["code"];
                    $_cols[2]["titel"] = "Qty:";
                    $_cols[2]["text"] = $order["qnt"];
                    $callwithout[100]["titel"] = "";
                    $callwithout[100]["text"] = implode("\n", $ArrayForCustomField);
                    SlackSendMsg($serviceDetails["orderslack"], ($serviceDetails["useasserver"] == 1 ? "SERVER" : ($serviceDetails["useasserver"] == 2 ? "Remote" : "IMEI")) . " New Order Placed #" . $return[2], $serviceDetails["colortag"] ? $serviceDetails["colortag"] : "good", $_cols, false, "", $callwithout);
                }
            }
        } else {
            $SERVICEFIELD = "imei_services";
            $adminmessage = "Service Name: " . $serviceDetails["service_name"] . "<br><Br>IMEI List:<br><br> ";
            if ($config["slack_ordernotification"]) {
                $_cols[0]["titel"] = $serviceDetails["service_name"];
                $_cols[0]["text"] = $serviceDetails["useasserver"] == 1 ? "SERVER :" : ($serviceDetails["useasserver"] == 2 ? "Remote :" : "IMEI: ");
                foreach ($imei_placed as $imei) {
                    $_cols[0]["text"] .= $imei . " ";
                }
                $_cols[1]["titel"] = $_ClientsDetails["username"];
                $_cols[1]["text"] = $order["credit"] - $order["discount"] . "" . $_ClientsDetails["currency"]["code"];
                $callwithout[100]["titel"] = "";
                $callwithout[100]["text"] = implode("\n", $ArrayForCustomField);
                SlackSendMsg($config["slack_ordernotification"], ($serviceDetails["useasserver"] == 1 ? "SERVER" : ($serviceDetails["useasserver"] == 2 ? "Remote" : "IMEI")) . " New Order Placed #" . $return[2], $serviceDetails["colortag"] ? $serviceDetails["colortag"] : "good", $_cols, false, "", $callwithout);
            } else {
                if ($serviceDetails["orderslack"]) {
                    $_cols[0]["titel"] = $serviceDetails["service_name"];
                    foreach ($imei_placed as $imei) {
                        $_cols[0]["text"] .= $imei . " ";
                    }
                    $_cols[1]["titel"] = $_ClientsDetails["username"];
                    $_cols[1]["text"] = $order["credit"] - $order["discount"] . "" . $_ClientsDetails["currency"]["code"];
                    $callwithout[100]["titel"] = "";
                    $callwithout[100]["text"] = implode("\n", $ArrayForCustomField);
                    SlackSendMsg($serviceDetails["orderslack"], ($serviceDetails["useasserver"] == 1 ? "SERVER" : ($serviceDetails["useasserver"] == 2 ? "REMOTE" : "IMEI")) . " New Order Placed #" . $return[2], $serviceDetails["colortag"] ? $serviceDetails["colortag"] : "good", $_cols, false, "", $callwithout);
                }
            }
        }
        $Qnts = 0;
        foreach ($imei_placed as $imei) {
            $Qnts++;
            $adminmessage .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . trim($imei) . "<br />";
        }
        $sql = dquery("SELECT first_name, last_name,email FROM tbl_supplier \n        WHERE find_in_set('" . $serviceDetails["id"] . "'," . $SERVICEFIELD . ")\n        AND imei_service_access = '1'");
        while ($r = mysqli_fetch_assoc($sql)) {
            $mailto = [$r["email"]];
            sendNotification("supplier", $serviceDetails["useasserver"] == 1 ? "New Server Order" : ($serviceDetails["useasserver"] == 2 ? "New remote order" : "New IMEI Order"), $adminmessage, $mailto, $config["config_admin_name"]);
            $mailto = NULL;
        }
        $SiteAddress = $config["site_address"];
        if ($config["config_ssl_allow"]) {
            $SiteAddress = $config["config_ssl_allow"];
        }
        if (!$serviceDetails["notificationemail"]) {
            $userlink = "<a href='" . $SiteAddress . "/" . $config["admin_directory"] . "/main.php?pageurl=" . base64_encode("edituser&id=" . $_ClientsDetails["id"]) . "&title=" . base64_encode("Edit User") . "'>" . $_ClientsDetails["username"] . "</a>";
            $adminmessage .= "<br /> Username : " . $userlink;
            if ($serviceDetails["useasserver"] == 2) {
                $here = "<a href='" . $SiteAddress . "/" . $config["admin_directory"] . "/main.php?pageurl=" . base64_encode("imeiorder") . "&stype=remote&title=" . base64_encode("New Remote Order") . "'>here</a>";
            } else {
                if ($serviceDetails["useasserver"] == 1) {
                    $here = "<a href='" . $SiteAddress . "/" . $config["admin_directory"] . "/main.php?pageurl=" . base64_encode("imeiorder") . "&stype=server&title=" . base64_encode("New IMEI Order") . "'>here</a>";
                } else {
                    $here = "<a href='" . $SiteAddress . "/" . $config["admin_directory"] . "/main.php?pageurl=" . base64_encode("imeiorder") . "&title=" . base64_encode("New IMEI Order") . "'>here</a>";
                }
            }
            if ($order["credit"]) {
                $adminmessage .= "<br /> Price : " . ($order["credit"] - $order["discount"]);
            }
            if ($serviceDetails["useasserver"] == 0) {
                $adminmessage .= "<br /> Qnt : " . $Qnts;
            }
            $adminmessage .= "<br /> Order ID : " . $return[2];
            if ($order["qnt"] && $serviceDetails["useasserver"]) {
                $adminmessage .= "<br /> Qnt : " . $order["qnt"];
            }
            if ($order["apiname"]) {
                $adminmessage .= "<br /> API       : " . $order["apiname"] . "<br> ";
            }
            foreach ($customfield as $cid => $cvalue) {
                $cname = mysqli_fetch_assoc(dquery("select * from tbl_customfields\nwhere id='" . $cid . "'"));
                $adminmessage .= "<br /> " . $cname["fieldname"] . "       : " . $cvalue;
            }
            $adminmessage .= "<br /> IP        : <a href='" . $config["ip_location"] . $remote_ip . "' target='_blank' >" . $remote_ip . "</a> <br> ";
            $adminmessage .= "<br /><br /> You can view Order from " . $here;
            if ($config["adminotice_neworder"] && $config["adminnotice"]) {
                if ($direct) {
                    sendNotification("system", "Direct IMEI Order Placed", $adminmessage, $mailto);
                } else {
                    if ($serviceDetails["useasserver"] == 2) {
                        sendNotification("system", "New Remote Order", $adminmessage, $mailto);
                    } else {
                        if ($serviceDetails["useasserver"] == 1) {
                            sendNotification("system", "New Server Order", $adminmessage, $mailto);
                        } else {
                            sendNotification("system", "New IMEI Order", $adminmessage, $mailto);
                        }
                    }
                }
            }
        }
        if ($serviceDetails["notification_mail"]) {
            $adminmessage = "";
            $adminmessage = "Service Name: " . $serviceDetails["service_name"] . "<br>";
            foreach ($imei_placed as $imei) {
                $adminmessage .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . $imei . "<br>";
            }
            $mailto = [$serviceDetails["notification_mail"]];
            $userlink = "<a href='" . $config["site_address"] . "/" . $config["admin_directory"] . "/main.php?pageurl=" . base64_encode("edituser&id=" . $_ClientsDetails["id"]) . "&title=" . base64_encode("Edit User") . "'>" . $_ClientsDetails["username"] . "</a>";
            $adminmessage .= "<br /> Username : " . $userlink;
            if ($order["credit"]) {
                $adminmessage .= "<br /> Price : " . ($order["credit"] - $order["discount"]);
            }
            if ($order["qnt"]) {
                $adminmessage .= "<br /> Qnt : " . $order["qnt"];
            }
            if ($order["apiname"]) {
                $adminmessage .= "<br /> API       : " . $order["apiname"] . "<br> ";
            }
            foreach ($customfield as $cid => $cvalue) {
                $cname = mysqli_fetch_assoc(dquery("select * from tbl_customfields\nwhere id='" . $cid . "'"));
                $adminmessage .= "<br /> " . $cname["fieldname"] . "       : " . $cvalue;
            }
            if ($serviceDetails["useasserver"] == 2) {
                sendNotification("notforsystem", "New Remote Order", $adminmessage, $mailto);
            } else {
                if ($serviceDetails["useasserver"] == 1) {
                    sendNotification("notforsystem", "New Server Order", $adminmessage, $mailto);
                } else {
                    sendNotification("notforsystem", "New IMEI Order", $adminmessage, $mailto);
                }
            }
        }
        if ($config["smsgateway"] && $serviceDetails["smsnotification"]) {
            $variable["SERVICE"] = $serviceDetails["service_name"];
            sendAdminNotification("system", 4, $variable);
        }
        if ($config["clientorderalert"] || $direct) {
            if (!$serviceDetails["useasserver"]) {
                $order = mysqli_fetch_assoc(dquery("select order_id,\n                credit,qnt,note,date,(select `Name` from tbl_mobile where ID=model_id) as model,\n                (select `Name` from tbl_provider where ID=provider_id) as provider,\n                mep,PIN,KBH,PRD,`Type`,`Reference`,discount,(select value from tbl_apiservers where gateway=(select API\n                from tbl_services_imei where id=service_id) AND setting = 'name') as apiname\n                from tbl_order_imei where order_id='" . $return[2] . "'"));
                $imeilist = "";
                foreach ($imei_placed as $imei) {
                    $imeilist .= $imei . "<br />\n ";
                }
                $email_merge_fields["imeilist"] = $imeilist;
                $email_merge_fields["service"] = $serviceDetails["service_name"];
                $email_merge_fields["credit"] = $order["credit"] - $order["discount"];
                $email_merge_fields["note"] = $order["note"];
                $email_merge_fields["date"] = $order["date"];
                $email_merge_fields["order"] = $order["order_id"];
                $email_merge_fields["model"] = $order["model"];
                $email_merge_fields["provider"] = $order["provider"];
                $email_merge_fields["mep"] = $order["mep"];
                $email_merge_fields["pin"] = $order["PIN"];
                $email_merge_fields["kbh"] = $order["KBH"];
                $email_merge_fields["prd"] = $order["PRD"];
                $email_merge_fields["type"] = $order["Type"];
                $email_merge_fields["reference"] = $order["Reference"];
                sendMail(76, $_ClientsDetails["id"], $return[2], $email_merge_fields, true);
                $email_merge_fields = NULL;
            } else {
                if ($serviceDetails["useasserver"] == 2) {
                    $order = mysqli_fetch_assoc(dquery("select order_id,\n                credit,qnt,note,date,(select `Name` from tbl_mobile where ID=model_id) as model,\n                (select `Name` from tbl_provider where ID=provider_id) as provider,\n                mep,PIN,KBH,PRD,`Type`,`Reference`,discount,(select value from tbl_apiservers where gateway=(select API\n                from tbl_services_imei where id=service_id) AND setting = 'name') as apiname\n                from tbl_order_imei where order_id='" . $return[2] . "'"));
                    $email_merge_fields["service"] = $serviceDetails["service_name"];
                    $email_merge_fields["credit"] = $order["credit"] - $order["discount"];
                    $email_merge_fields["note"] = $order["note"];
                    $email_merge_fields["date"] = $order["date"];
                    $email_merge_fields["order"] = $order["order_id"];
                    sendMail(86, $_ClientsDetails["id"], $return[2], $email_merge_fields, true);
                    $email_merge_fields = NULL;
                }
            }
        }
    }
    if ($return[0]) {
        runAction("NewOrderPlaced", [$_ClientsDetails, $serviceDetails, $imei_placed]);
        return "success: " . "<li>" . $placed . " " . $lng_languag["orderplaced"] . "</li> :" . $return[2];
    }
    if ($return[1]) {
        return "error:" . "<li>" . $lng_languag["notstock"] . "</li>";
    }
    if ($point) {
        return "error: You have not enough points";
    }
    return "error: " . "<li>" . $lng_languag["notenoughcredit"] . "</li>";
}
function creditProcessIMEIDirect($_ClientsDetails, $serviceDetails, $imei, $uid = "")
{
    if ($serviceDetails["stock_allow"] && $serviceDetails["stock"] <= 0) {
        return [false, true];
    }
    if ($serviceDetails["stock_allow"]) {
        dquery("UPDATE `tbl_services_imei` SET `stock`=`stock`-1 where id=" . $serviceDetails["id"]);
    }
    global $config;
    global $db;
    global $model_id;
    global $provider_id;
    global $network_id;
    global $mep;
    global $PIN;
    global $KBH;
    global $PRD;
    global $Type;
    global $SN;
    global $SecRO;
    global $Reference;
    global $Locks;
    global $country;
    global $notes;
    global $comments;
    global $response;
    global $no;
    global $otherno;
    global $orderfrom;
    $data = NULL;
    $data["response_email"] = $response;
    $data["service_id"] = $serviceDetails["id"];
    if ($_SESSION["system_default_currency"]["id"] != $_ClientsDetails["currency_id"]) {
        $serviceDetails["purchase_cost"] = getPurchaseCost($_ClientsDetails["currency_id"], $serviceDetails["id"], "imei");
        if (!$serviceDetails["purchase_cost"]) {
            $serviceDetails["purchase_cost"] = convertCurrency($serviceDetails["purchase_cost"], $_SESSION["system_default_currency"]["id"], $_ClientsDetails["currency_id"]);
        }
    }
    $data["purchase_cost"] = 0 - $serviceDetails["credit"];
    $data["profit"] = 0 - $serviceDetails["purchase_cost"];
    $data["user_id"] = $_ClientsDetails["id"];
    $data["ORDERAPI"] = $serviceDetails["API"];
    $data["ORDERAPI_ID"] = $serviceDetails["API_ID"];
    $data["ORDERAPI_TYPEID"] = $serviceDetails["API_TYPEID"];
    $data["imei"] = $imei;
    $data["date"] = date("Y-m-d");
    $data["time"] = time();
    $data["user_can_c"] = 0;
    $data["pass_key"] = md5(time() . $_ClientsDetails["id"] . time());
    $data["model_id"] = $model_id;
    $data["provider_id"] = $provider_id;
    $data["provider_c_id"] = $country;
    $data["network_id"] = $network_id;
    $data["mep"] = $mep;
    $data["KBH"] = $KBH;
    $data["PIN"] = $PIN;
    $data["SN"] = $SN;
    $data["SecRO"] = $SecRO;
    $data["PRD"] = $PRD;
    if ($no == 1) {
        $data["responseno"] = $_ClientsDetails["phonenumber"];
    } else {
        if ($otherno != "") {
            $data["responseno"] = $otherno;
        }
    }
    if ($serviceDetails["subscription"]) {
        $data["subscribe"] = 1;
        dquery("UPDATE tbl_subscribers set used=used+1 WHERE\n        service_id='" . $serviceDetails["id"] . "' AND user_id='" . $_ClientsDetails["id"] . "'\n  \t\tAND type='tbl_services_imei'");
    }
    $data["ip"] = $_SERVER["REMOTE_ADDR"];
    $data["Type"] = $Type;
    $data["ebay"] = $uid;
    $data["currency_id"] = $_ClientsDetails["currency_id"];
    $data["Reference"] = $Reference;
    $data["note"] = htmlspecialchars(strip_tags($notes));
    $data["comments"] = htmlspecialchars(strip_tags($comments));
    if ($Locks) {
        foreach ($Locks as $L) {
            $T .= "," . $L;
        }
        $data["Locks"] = trim($T, ",");
    }
    $data["credit"] = 0;
    $data["discount"] = 0;
    if ($serviceDetails["manualverification"]) {
        $data["autosend"] = 1;
    }
    if ($serviceDetails["useasserver"]) {
        $data["server"] = $serviceDetails["useasserver"];
    }
    $data["placedfrom"] = $orderfrom;
    $data["pricefrom"] = $serviceDetails["pricingfrom"];
    $order = $db->insert("tbl_order_imei", $data);
    orderLog($order, $_SESSION["adminid"], "", 0, "New Order");
    if ($order) {
        duplicateimeireply($order, $imei);
    }
    alphanumeric($order);
    if ($serviceDetails["key_selling"] && !$serviceDetails["manualverification"]) {
        include_once ROOTDIR . "/includes/keyselling.fun.php";
        if ($serviceDetails["useasserver"]) {
            processKey($serviceDetails["key_selling"], $order, "server");
        } else {
            processKey($serviceDetails["key_selling"], $order, "imei");
        }
    }
    unset($data);
    global $customfield;
    saveCustomFields($order, $customfield);
    return [true, true, $order];
}
function creditProcessUser($_ClientsDetails, $serviceDetails, $imei, $point = false)
{
    global $config;
    global $qnt;
    global $precision;
    if (!$point) {
        $credit = round($serviceDetails["credit"] - $serviceDetails["discount"], $precision);
        if (1 < $qnt) {
            $credit = $credit * $qnt;
        }
        if ($serviceDetails["stock_allow"] && $serviceDetails["stock"] <= 0) {
            return [false, true];
        }
        if ($serviceDetails["stock_allow"]) {
            dquery("UPDATE `tbl_services_imei` SET `stock`=`stock`-1\n         where id=" . $serviceDetails["id"]);
        }
        $UserCredit = mysqli_fetch_assoc(dquery("SELECT credit_left FROM\n    tblUsers WHERE id='" . $_ClientsDetails["id"] . "'"));
        if (!($UserCredit["credit_left"] < $credit && $config["allowoverdrive"] && $_ClientsDetails["allowoverdrive"] && ($_ClientsDetails["overdrive"] == 0 || 0 <= $_ClientsDetails["credit"]["credit"] - $credit + $_ClientsDetails["overdrive"]))) {
            if ($UserCredit["credit_left"] < $credit) {
                return [false, false];
            }
        }
    }
    global $db;
    global $model_id;
    global $provider_id;
    global $network_id;
    global $mep;
    global $PIN;
    global $KBH;
    global $PRD;
    global $Type;
    global $SN;
    global $SecRO;
    global $Reference;
    global $Locks;
    global $country;
    global $notes;
    global $comments;
    global $response;
    global $no;
    global $otherno;
    global $orderfrom;
    global $precision;
    $data = NULL;
    $data["response_email"] = $response;
    $data["service_id"] = $serviceDetails["id"];
    if ($_SESSION["system_default_currency"]["id"] != $_ClientsDetails["currency_id"]) {
        $serviceDetails["purchase_cost"] = convertCurrency($serviceDetails["purchase_cost"], $_SESSION["system_default_currency"]["id"], $_ClientsDetails["currency_id"]);
    }
    $data["purchase_cost"] = $serviceDetails["purchase_cost"];
    if (0 < $serviceDetails["purchase_cost"]) {
        $data["profit"] = round($serviceDetails["purchase_cost"] - ($serviceDetails["credit"] - $serviceDetails["discount"]), $precision);
    }
    $data["user_id"] = $_ClientsDetails["id"];
    $data["imei"] = $imei;
    $data["date"] = date("Y-m-d");
    $data["time"] = time();
    $data["user_can_c"] = 0;
    $data["ORDERAPI"] = $serviceDetails["API"];
    $data["ORDERAPI_ID"] = $serviceDetails["API_ID"];
    $data["ORDERAPI_TYPEID"] = $serviceDetails["API_TYPEID"];
    $data["pass_key"] = md5(time() . $_ClientsDetails["id"] . time());
    $data["model_id"] = $model_id;
    $data["provider_id"] = $provider_id;
    $data["provider_c_id"] = $country;
    $data["network_id"] = $network_id;
    $data["mep"] = $mep;
    $data["KBH"] = $KBH;
    $data["PIN"] = $PIN;
    $data["PRD"] = $PRD;
    $data["SN"] = $SN;
    $data["SecRO"] = $SecRO;
    if ($no == 1) {
        $data["responseno"] = $_ClientsDetails["phonenumber"];
    } else {
        if ($otherno != "") {
            $data["responseno"] = $otherno;
        }
    }
    if ($serviceDetails["subscription"]) {
        $data["subscribe"] = 1;
        dquery("UPDATE tbl_subscribers set used=used+1 WHERE\n        \t\t service_id='" . $serviceDetails["id"] . "' AND user_id='" . $_ClientsDetails["id"] . "'\n        \t\tAND type='tbl_services_imei'");
    }
    $data["ip"] = $_SERVER["REMOTE_ADDR"];
    $data["Type"] = $Type;
    $data["currency_id"] = $_ClientsDetails["currency_id"];
    $data["Reference"] = $Reference;
    $data["note"] = htmlspecialchars(strip_tags($notes));
    $data["comments"] = htmlspecialchars(strip_tags($comments));
    $T = "";
    if ($Locks) {
        foreach ($Locks as $L) {
            $T .= "," . $L;
        }
        $data["Locks"] = trim($T, ",");
    }
    $data["credit"] = $serviceDetails["credit"];
    $data["discount"] = $serviceDetails["discount"];
    if ($serviceDetails["manualverification"]) {
        $data["autosend"] = 1;
    }
    if ($serviceDetails["useasserver"]) {
        $data["server"] = $serviceDetails["useasserver"];
    }
    if (1 < $qnt) {
        $data["qnt"] = $qnt;
    } else {
        $data["qnt"] = 1;
    }
    $data["placedfrom"] = $orderfrom;
    if (0 <= $data["credit"] - $data["discount"]) {
        $data["pricefrom"] = $serviceDetails["pricingfrom"];
        $order = $db->insert("tbl_order_imei", $data);
        orderLog($order, $_SESSION["adminid"], "", 0, "New Order");
    }
    if ($order) {
        if (!$point) {
            if ($UserCredit["credit_left"] < $credit && $config["allowoverdrive"] && $_ClientsDetails["allowoverdrive"] && ($_ClientsDetails["overdrive"] == 0 || 0 <= $_ClientsDetails["credit"]["credit"] - $credit + $_ClientsDetails["overdrive"])) {
                dquery("UPDATE `tblUsers` SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . "),\n                `credit_used`=`credit_used`+'" . $credit . "',\n                `credit_inprocess`=`credit_inprocess`+'" . $credit . "'\n                WHERE `id`='" . $_ClientsDetails["id"] . "'");
            } else {
                if ($UserCredit["credit_left"] < $credit) {
                    return [false, false];
                }
                dquery("UPDATE `tblUsers` SET \n                `credit_left`=round(credit_left-'" . $credit . "'," . $precision . "),\n                `credit_used`=`credit_used`+'" . $credit . "',\n                `credit_inprocess`=`credit_inprocess`+'" . $credit . "'\n                 WHERE `id`='" . $_ClientsDetails["id"] . "'");
            }
            if ($order) {
                duplicateimeireply($order, $imei);
            }
            alphanumeric($order);
            if ($serviceDetails["key_selling"] && !$serviceDetails["manualverification"]) {
                include_once ROOTDIR . "/includes/keyselling.fun.php";
                if ($serviceDetails["useasserver"]) {
                    processKey($serviceDetails["key_selling"], $order, "server", $qnt);
                } else {
                    processKey($serviceDetails["key_selling"], $order, "imei", $qnt);
                }
            }
            unset($data);
            addStatementuser($_ClientsDetails["id"], "New Order Placed", "DR", $credit, $order, "imei");
        } else {
            $popoint = $serviceDetails["purchasepoint"] * $qnt;
            processPoints($_SESSION["uid"], 0, $popoint, $order);
            if ($serviceDetails["key_selling"] && !$serviceDetails["manualverification"]) {
                include_once ROOTDIR . "/includes/keyselling.fun.php";
                if ($serviceDetails["useasserver"]) {
                    processKey($serviceDetails["key_selling"], $order, "server", $qnt);
                } else {
                    processKey($serviceDetails["key_selling"], $order, "imei", $qnt);
                }
            }
        }
        global $customfield;
        saveCustomFields($order, $customfield);
        return [true, true, $order];
    }
    return [false, false];
}
function creditProcessReseller($_ClientsDetails, $serviceDetails, $imei)
{
    global $config;
    global $qnt;
    global $precision;
    $credit = round($serviceDetails["credit"] - $serviceDetails["discount"], $precision);
    if (1 < $qnt) {
        $credit = $credit * $qnt;
    }
    if ($serviceDetails["stock_allow"] && $serviceDetails["stock"] <= 0) {
        return [false, true];
    }
    if ($serviceDetails["stock_allow"]) {
        dquery("UPDATE `tbl_services_imei` SET `stock`=`stock`-1 where id=" . $serviceDetails["id"]);
    }
    $UserCredit = mysqli_fetch_assoc(dquery("SELECT credit_left,sell_credit_limit\n     FROM tblUsers WHERE id='" . $_ClientsDetails["id"] . "'"));
    if (!(($UserCredit["credit_left"] < $credit || $UserCredit["sell_credit_limit"] < $credit) && $config["allowoverdrive"] && $_ClientsDetails["allowoverdrive"] && ($_ClientsDetails["overdrive"] == 0 || 0 <= $_ClientsDetails["credit"]["credit"] - $credit + $_ClientsDetails["overdrive"] && 0 <= $_ClientsDetails["credit"]["selling_limit"] - $credit + $_ClientsDetails["overdrive"]))) {
        if ($UserCredit["credit_left"] < $credit || $UserCredit["sell_credit_limit"] < $credit) {
            return [false, false];
        }
    }
    global $db;
    global $model_id;
    global $provider_id;
    global $network_id;
    global $mep;
    global $PIN;
    global $KBH;
    global $PRD;
    global $Type;
    global $SN;
    global $SecRO;
    global $Reference;
    global $Locks;
    global $country;
    global $notes;
    global $comments;
    global $response;
    global $no;
    global $otherno;
    global $orderfrom;
    global $precision;
    $data = NULL;
    $data["response_email"] = $response;
    $data["service_id"] = $serviceDetails["id"];
    $cr = $_SESSION["system_default_currency"]["id"];
    $def = $_ClientsDetails["currency_id"];
    if ($_SESSION["system_default_currency"]["id"] != $_ClientsDetails["currency_id"]) {
        $serviceDetails["purchase_cost"] = convertCurrency($serviceDetails["purchase_cost"], $_SESSION["system_default_currency"]["id"], $_ClientsDetails["currency_id"]);
    }
    $data["purchase_cost"] = $serviceDetails["purchase_cost"];
    if (0 < $serviceDetails["purchase_cost"]) {
        $data["profit"] = round($serviceDetails["purchase_cost"] - ($serviceDetails["credit"] - $serviceDetails["discount"]), $precision);
    }
    $data["user_id"] = $_ClientsDetails["id"];
    $data["imei"] = $imei;
    $data["date"] = date("Y-m-d");
    $data["time"] = time();
    $data["ORDERAPI"] = $serviceDetails["API"];
    $data["ORDERAPI_ID"] = $serviceDetails["API_ID"];
    $data["ORDERAPI_TYPEID"] = $serviceDetails["API_TYPEID"];
    $data["user_can_c"] = 0;
    $data["pass_key"] = md5(time() . $_ClientsDetails["id"] . time());
    $data["model_id"] = $model_id;
    $data["provider_id"] = $provider_id;
    $data["provider_c_id"] = $country;
    $data["network_id"] = $network_id;
    $data["mep"] = $mep;
    $data["KBH"] = $KBH;
    $data["PIN"] = $PIN;
    $data["SN"] = $SN;
    $data["SecRO"] = $SecRO;
    if ($serviceDetails["subscription"]) {
        $data["subscribe"] = 1;
        dquery("UPDATE tbl_subscribers set used=used+1 WHERE\n    \tservice_id='" . $serviceDetails["id"] . "' AND user_id='" . $_ClientsDetails["id"] . "'\n    \tAND type='tbl_services_imei'");
    }
    $data["ip"] = $_SERVER["REMOTE_ADDR"];
    $data["PRD"] = $PRD;
    $data["Type"] = $Type;
    $data["currency_id"] = $_ClientsDetails["currency_id"];
    $data["Reference"] = $Reference;
    $data["note"] = htmlspecialchars(strip_tags($notes));
    $data["comments"] = htmlspecialchars(strip_tags($comments));
    if ($no == 1) {
        $data["responseno"] = $_ClientsDetails["phonenumber"];
    } else {
        if ($otherno != "") {
            $data["responseno"] = $otherno;
        }
    }
    if ($Locks) {
        foreach ($Locks as $L) {
            $T .= "," . $L;
        }
        $data["Locks"] = trim($T, ",");
    }
    $data["credit"] = $serviceDetails["credit"];
    $data["discount"] = $serviceDetails["discount"];
    if ($serviceDetails["manualverification"]) {
        $data["autosend"] = 1;
    }
    if ($serviceDetails["useasserver"]) {
        $data["server"] = $serviceDetails["useasserver"];
    }
    if (1 < $qnt) {
        $data["qnt"] = $qnt;
    } else {
        $data["qnt"] = 1;
    }
    $data["placedfrom"] = $orderfrom;
    if (0 <= $data["credit"] - $data["discount"]) {
        $data["pricefrom"] = $serviceDetails["pricingfrom"];
        $order = $db->insert("tbl_order_imei", $data);
    }
    if ($order) {
        if (($UserCredit["credit_left"] < $credit || $UserCredit["sell_credit_limit"] < $credit) && $config["allowoverdrive"] && $_ClientsDetails["allowoverdrive"] && ($_ClientsDetails["overdrive"] == 0 || 0 <= $_ClientsDetails["credit"]["credit"] - $credit + $_ClientsDetails["overdrive"] && 0 <= $_ClientsDetails["credit"]["selling_limit"] - $credit + $_ClientsDetails["overdrive"])) {
            dquery("UPDATE `tblUsers`\n                 SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . "),\n                `credit_used`=`credit_used`+'" . $credit . "',\n                `credit_inprocess`=`credit_inprocess`+'" . $credit . "',\n                `sell_credit_limit`=round(sell_credit_limit-'" . $credit . "'," . $precision . ")\n                 WHERE `id`='" . $_ClientsDetails["id"] . "'");
            if ($order) {
                duplicateimeireply($order, $imei);
            }
            alphanumeric($order);
            if ($serviceDetails["key_selling"] && !$serviceDetails["manualverification"]) {
                include_once ROOTDIR . "/includes/keyselling.fun.php";
                if ($serviceDetails["useasserver"] == 1) {
                    processKey($serviceDetails["key_selling"], $order, "server", $qnt);
                } else {
                    processKey($serviceDetails["key_selling"], $order, "imei", $qnt);
                }
            }
            unset($data);
            addStatementuser($_ClientsDetails["id"], "New Order Placed", "DR", $credit, $order, "imei", 1);
            global $customfield;
            saveCustomFields($order, $customfield);
            return [true, true, $order];
        }
        if ($UserCredit["credit_left"] < $credit || $UserCredit["sell_credit_limit"] < $credit) {
            return [false, false];
        }
        dquery("UPDATE `tblUsers`\n                 SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . "),\n                `credit_used`=`credit_used`+'" . $credit . "',\n                `credit_inprocess`=`credit_inprocess`+'" . $credit . "',\n                `sell_credit_limit`=round(sell_credit_limit-'" . $credit . "'," . $precision . ")\n                 WHERE `id`='" . $_ClientsDetails["id"] . "'");
        if ($order) {
            duplicateimeireply($order, $imei);
        }
        alphanumeric($order);
        if ($serviceDetails["key_selling"] && !$serviceDetails["manualverification"]) {
            include_once ROOTDIR . "/includes/keyselling.fun.php";
            if ($serviceDetails["useasserver"] == 1) {
                processKey($serviceDetails["key_selling"], $order, "server", $qnt);
            } else {
                processKey($serviceDetails["key_selling"], $order, "imei", $qnt);
            }
        }
        unset($data);
        addStatementuser($_ClientsDetails["id"], "New Order Placed", "DR", $credit, $order, "imei", 1);
        global $customfield;
        saveCustomFields($order, $customfield);
        return [true, true, $order];
    }
    return [false, false];
}
function creditProcessResellersUser($_ClientsDetails, $serviceDetails, $imei)
{
    global $qnt;
    global $precision;
    $credit = round($serviceDetails["credit"] - $serviceDetails["discount"], $precision);
    if (1 < $qnt) {
        $credit = $credit * $qnt;
    }
    if ($serviceDetails["stock_allow"] && $serviceDetails["stock"] <= 0) {
        return [false, true];
    }
    if ($serviceDetails["stock_allow"]) {
        dquery("UPDATE `tbl_services_imei` SET `stock`=`stock`-1 where id=" . $serviceDetails["id"]);
    }
    $_RClientsDetails = getClientsDetails($_ClientsDetails["reseller_id"]);
    $RserviceDetails = getimeiservices("", md5($serviceDetails["id"]), $_ClientsDetails["reseller_id"], true);
    $rcredit = round($RserviceDetails["credit"] - $RserviceDetails["discount"], $precision);
    if (1 < $qnt) {
        $rcredit = $rcredit * $qnt;
    }
    $UserCredit = mysqli_fetch_assoc(dquery("SELECT credit_left FROM tblUsers WHERE id='" . $_ClientsDetails["id"] . "'"));
    if ($UserCredit["credit_left"] < $credit || $_RClientsDetails["credit"]["credit"] < $rcredit) {
        return [false, false];
    }
    global $config;
    global $db;
    global $model_id;
    global $provider_id;
    global $network_id;
    global $mep;
    global $PIN;
    global $KBH;
    global $PRD;
    global $SN;
    global $SecRO;
    global $Type;
    global $Reference;
    global $Locks;
    global $country;
    global $notes;
    global $comments;
    global $response;
    global $no;
    global $otherno;
    global $orderfrom;
    global $precision;
    $data = NULL;
    $data["response_email"] = $response;
    $data["service_id"] = $serviceDetails["id"];
    if ($_SESSION["system_default_currency"]["id"] != $_ClientsDetails["currency_id"]) {
        $serviceDetails["purchase_cost"] = convertCurrency($serviceDetails["purchase_cost"], $_SESSION["system_default_currency"]["id"], $_ClientsDetails["currency_id"]);
    }
    $data["purchase_cost"] = $serviceDetails["purchase_cost"];
    if (0 < $serviceDetails["purchase_cost"]) {
        $data["profit"] = round($serviceDetails["purchase_cost"] - ($serviceDetails["credit"] - $serviceDetails["discount"]), $precision);
    }
    $data["user_id"] = $_ClientsDetails["id"];
    $data["ORDERAPI"] = $serviceDetails["API"];
    $data["ORDERAPI_ID"] = $serviceDetails["API_ID"];
    $data["ORDERAPI_TYPEID"] = $serviceDetails["API_TYEPID"];
    $data["imei"] = $imei;
    $data["date"] = date("Y-m-d");
    $data["time"] = time();
    $data["user_can_c"] = 0;
    $data["pass_key"] = md5(time() . $_ClientsDetails["id"] . time());
    $data["model_id"] = $model_id;
    $data["provider_id"] = $provider_id;
    $data["provider_c_id"] = $country;
    $data["network_id"] = $network_id;
    $data["mep"] = $mep;
    $data["ip"] = $_SERVER["REMOTE_ADDR"];
    $data["KBH"] = $KBH;
    $data["PIN"] = $PIN;
    $data["PRD"] = $PRD;
    $data["SN"] = $SN;
    $data["SecRO"] = $SecRO;
    $data["Type"] = $Type;
    if ($serviceDetails["subscription"]) {
        $data["subscribe"] = 1;
        dquery("UPDATE tbl_subscribers set used=used+1 WHERE\n    \tservice_id='" . $serviceDetails["id"] . "' AND user_id='" . $_ClientsDetails["id"] . "'\n    \tAND type='tbl_services_imei'");
    }
    $data["currency_id"] = $_ClientsDetails["currency_id"];
    $data["Reference"] = $Reference;
    $data["note"] = htmlspecialchars(strip_tags($notes));
    $data["comments"] = htmlspecialchars(strip_tags($comments));
    if ($no == 1) {
        $data["responseno"] = $_ClientsDetails["phonenumber"];
    } else {
        if ($otherno != "") {
            $data["responseno"] = $otherno;
        }
    }
    if ($Locks) {
        foreach ($Locks as $L) {
            $T .= "," . $L;
        }
        $data["Locks"] = trim($T, ",");
    }
    $data["credit"] = $serviceDetails["credit"];
    $data["discount"] = $serviceDetails["discount"];
    $data["reseller_id"] = $_ClientsDetails["reseller_id"];
    $data["reseller_credit"] = $RserviceDetails["credit"];
    $data["reseller_discount"] = $RserviceDetails["discount"];
    if ($serviceDetails["manualverification"]) {
        $data["autosend"] = 1;
    }
    if ($serviceDetails["useasserver"]) {
        $data["server"] = $serviceDetails["useasserver"];
    }
    if (1 < $qnt) {
        $data["qnt"] = $qnt;
    } else {
        $data["qnt"] = 1;
    }
    $data["placedfrom"] = $orderfrom;
    if (0 <= $data["credit"] - $data["discount"]) {
        $data["pricefrom"] = $serviceDetails["pricingfrom"];
        $order = $db->insert("tbl_order_imei", $data);
    }
    if ($order) {
        if ($UserCredit["credit_left"] < $credit || $_RClientsDetails["credit"]["credit"] < $rcredit) {
            return [false, false];
        }
        dquery("UPDATE `tblUsers`\n             SET `credit_left`=round(credit_left-'" . $credit . "'," . $precision . "),\n            `credit_used`=`credit_used`+'" . $credit . "',\n            `credit_inprocess`=`credit_inprocess`+'" . $credit . "'\n             WHERE `id`='" . $_ClientsDetails["id"] . "'");
        dquery("UPDATE `tblUsers`\n            SET `credit_left`=round(credit_left-'" . $rcredit . "'," . $precision . "),\n            `credit_used`=`credit_used`+'" . $rcredit . "',\n            `sell_credit_limit`=`sell_credit_limit`+(" . $credit . "-" . $rcredit . "),\n            `credit_inprocess`=`credit_inprocess`+'" . $rcredit . "'\n            WHERE `id`='" . $_RClientsDetails["id"] . "'");
        resellerState($_RClientsDetails["id"], $_ClientsDetails["id"], "imei", $serviceDetails["id"], $credit - $rcredit);
        if ($order) {
            duplicateimeireply($order, $imei);
        }
        alphanumeric($order);
        if ($serviceDetails["key_selling"] && !$serviceDetails["manualverification"]) {
            include_once ROOTDIR . "/includes/keyselling.fun.php";
            if ($serviceDetails["useasserver"] == 1) {
                processKey($serviceDetails["key_selling"], $order, "server", $qnt);
            } else {
                processKey($serviceDetails["key_selling"], $order, "imei", $qnt);
            }
        }
        unset($data);
        addStatementuser($_ClientsDetails["id"], "New Order Placed", "DR", $credit, $order, "imei");
        addStatementuser($_RClientsDetails["id"], "New Order Placed by : " . $_ClientsDetails["username"], "DR", $rcredit, $order, "imei");
        global $customfield;
        saveCustomFields($order, $customfield);
        return [true, true, $order];
    }
    return [false, false];
}
function cancelOrderIMEI($orderid, $uid = "", $updateclientdetails = false)
{
    global $_ClientsDetails;
    global $config;
    global $db;
    global $lng_languag;
    global $precision;
    $ordersDetails = getordersimei("pending", "", "", $orderid);
    $ordersDetails = $ordersDetails[$orderid]["allfield"];
    if ($uid && $updateclientdetails) {
        if (!function_exists(getClientsDetails)) {
            require_once ROOTDIR . "/includes/clients.fun.inc.php";
        }
        $_ClientsDetails = getClientsDetails($uid);
    } else {
        if (!$_ClientsDetails["id"]) {
            if (!function_exists(getClientsDetails)) {
                require_once ROOTDIR . "/includes/clients.fun.inc.php";
            }
            $_ClientsDetails = getClientsDetails($_SESSION["uid"]);
        }
    }
    $credit = round($ordersDetails["credit"] - $ordersDetails["discount"], $precision);
    if (1 < $ordersDetails["qnt"]) {
        $credit = $credit * $ordersDetails["qnt"];
    }
    if ($ordersDetails["user_can_c"] == 0) {
        $service = mysqli_fetch_assoc(dquery("SELECT `usercan_cancel`,stock_allow FROM `tbl_services_imei` WHERE `id`='" . $ordersDetails["service_id"] . "'"));
        $time_diff = ceil((time() - $ordersDetails["time"]) / 60);
        if ($service["usercan_cancel"] && $time_diff <= $config["usercan_cancel_order_within_min"]) {
            if ($_ClientsDetails["usertype"] == 0) {
                if ($ordersDetails["retail_shop"]) {
                    dquery("UPDATE `tblUsers` SET `credit_left`=`credit_left`+'" . $credit . "'\n                     WHERE `id`='" . $_ClientsDetails["id"] . "'");
                } else {
                    dquery("UPDATE `tblUsers` \n                     SET `credit_left`=`credit_left`+'" . $credit . "',\n                    `credit_used`=`credit_used`-'" . $credit . "',\n                    `credit_inprocess`=`credit_inprocess`-'" . $credit . "'\n                     WHERE `id`='" . $_ClientsDetails["id"] . "'");
                    if ($service["stock_allow"]) {
                        dquery("UPDATE `tbl_services_imei` \n                        SET `stock`=`stock`+1 where id=" . $ordersDetails["service_id"]);
                    }
                }
                $data = NULL;
                $data["user_can_c"] = 3;
                $data["reply"] = "Canceled by user request";
                $db->update("tbl_order_imei", $data, "order_id='" . $ordersDetails["order_id"] . "'");
                addStatementuser($_ClientsDetails["id"], "Order Canceled by user", "CR", $credit, $ordersDetails["order_id"], "imei");
            } else {
                if ($_ClientsDetails["usertype"] == 1) {
                    if ($ordersDetails["retail_shop"]) {
                        dquery("UPDATE `tblUsers`\n                    SET `credit_left`=`credit_left`+'" . $credit . "'\n                    WHERE `id`='" . $_ClientsDetails["id"] . "'");
                    } else {
                        dquery("UPDATE `tblUsers`\n                     SET `credit_left`=`credit_left`+'" . $credit . "',\n                    `credit_used`=`credit_used`-'" . $credit . "',\n                    `credit_inprocess`=`credit_inprocess`-'" . $credit . "',\n                    `sell_credit_limit`=`sell_credit_limit`+'" . $credit . "'\n                     WHERE `id`='" . $_ClientsDetails["id"] . "'");
                        if ($service["stock_allow"]) {
                            dquery("UPDATE `tbl_services_imei` \n                        SET `stock`=`stock`+1 \n                        where id=" . $ordersDetails["service_id"]);
                        }
                    }
                    $data = NULL;
                    $data["user_can_c"] = 3;
                    $data["reply"] = "Canceled by user request";
                    $db->update("tbl_order_imei", $data, "order_id='" . $ordersDetails["order_id"] . "'");
                    addStatementuser($_ClientsDetails["id"], "Order Canceled by user", "CR", $credit, $ordersDetails["order_id"], "imei");
                } else {
                    if ($_ClientsDetails["usertype"] == 3) {
                        if ($ordersDetails["retail_shop"]) {
                            dquery("UPDATE `tblUsers`\n                     SET `credit_left`=`credit_left`+'" . $credit . "'\n                     WHERE `id`='" . $_ClientsDetails["id"] . "'");
                        } else {
                            dquery("UPDATE `tblUsers`\n                    SET `credit_left`=`credit_left`+'" . $credit . "',\n                    `credit_used`=`credit_used`-'" . $credit . "',\n                    `credit_inprocess`=`credit_inprocess`-'" . $credit . "'\n                    WHERE `id`='" . $_ClientsDetails["id"] . "'");
                            $rcredit = $ordersDetails["reseller_credit"] - $ordersDetails["reseller_discount"];
                            if (1 < $ordersDetails["qnt"]) {
                                $rcredit = $rcredit * $ordersDetails["qnt"];
                            }
                            dquery("UPDATE `tblUsers`\n                     SET `credit_left`=`credit_left`+'" . $rcredit . "',\n                    `credit_used`=`credit_used`-'" . $rcredit . "',\n                    `credit_inprocess`=`credit_inprocess`-'" . $rcredit . "',\n                    `sell_credit_limit`=`sell_credit_limit`-(" . $credit . "-" . $rcredit . ")\n                     WHERE `id`='" . $ordersDetails["reseller_id"] . "'");
                            resellerState($ordersDetails["reseller_id"], $_ClientsDetails["id"], "imei", $ordersDetails["service_id"], "-" . ($credit - $rcredit));
                            if ($service["stock_allow"]) {
                                dquery("UPDATE `tbl_services_imei` \n                        SET `stock`=`stock`+1 where \n                        id=" . $ordersDetails["service_id"]);
                            }
                        }
                        $data = NULL;
                        $data["user_can_c"] = 3;
                        $data["reply"] = "Canceled by user request";
                        $db->update("tbl_order_imei", $data, "order_id='" . $ordersDetails["order_id"] . "'");
                        addStatementuser($_ClientsDetails["id"], "Order canceled by user", "CR", $credit, $order, "imei");
                        addStatementuser($ordersDetails["reseller_id"], "Order canceled by : " . $_ClientsDetails["username"], "CR", $rcredit, $order, "imei", 1);
                    }
                }
            }
            if ($config["SENDMAIL_ordercanceledbyuser"]) {
                require_once ROOTDIR . "/includes/mail.fun.php";
                $email_merge_fields["username"] = $_ClientsDetails["username"];
                $email_merge_fields["reason"] = "Canceled by User";
                $email_merge_fields["service"] = "IMEI";
                sendMail(6, $_ClientsDetails["id"], "", $email_merge_fields);
            }
            dquery("UPDATE `tbl_service_imei` SET \n            `stock`=`stock`+1 where id='" . $ordersDetails["service_id"] . "'");
            return true;
        }
        return false;
    }
    return $lng_languag["orderlocked"];
}
function verifyOrderIMEI($orderid, $uid = "", $details = "", $attachment = "")
{
    global $config;
    global $db;
    global $lng_languag;
    if (!$uid) {
        $uid = $_SESSION["uid"];
    }
    $ordersdtl = mysqli_fetch_assoc(dquery("SELECT *,(select value from \n    tbl_apiservers where gateway=(select API\n    from tbl_services_imei where id=service_id) \n    AND setting = 'name') as apiname FROM `tbl_order_imei`\n     WHERE md5(order_id)='" . $orderid . "'"));
    $service = mysqli_fetch_assoc(dquery("SELECT `service_name`,id \n    FROM `tbl_services_imei` WHERE `id`='" . $ordersdtl["service_id"] . "'"));
    if ($ordersdtl["verified"] == 0) {
        $data["verified"] = 1;
        $db->update("tbl_order_imei", $data, "order_id='" . $ordersdtl["order_id"] . "'");
        require_once ROOTDIR . "/includes/mail.fun.php";
        $here = "<a href='" . $config["site_address"] . "/" . $config["admin_directory"] . "/main.php?pageurl=" . base64_encode("edituser.editimeiorder&id=" . $ordersdtl["order_id"]) . "&title=" . base64_encode("Edit IMEI Order") . "'>here</a>";
        $servicelink = "<a href='" . $config["site_address"] . "/" . $config["admin_directory"] . "/main.php?pageurl=" . base64_encode("editimeiservice&id=" . $service["id"]) . "&title=" . base64_encode("Edit IMEI Service") . "'>" . $service["service_name"] . "</a>";
        if ($ordersdtl["server"]) {
            $adminmessage = "New Server Order comes for Verification <br>";
        } else {
            $adminmessage = "New IMEI Order comes for Verification <br>";
        }
        $adminmessage .= "Order Details : <br>";
        $adminmessage .= "Order ID :" . $ordersdtl["order_id"] . " <br>";
        $adminmessage .= "Service  :" . $servicelink . " <br>";
        if (!$ordersdtl["server"]) {
            $adminmessage .= "IMEI     :" . $ordersdtl["imei"] . " <br>";
        }
        if ($details) {
            $adminmessage .= "Details     :" . $details . " <br>";
        }
        if ($ordersdtl["apiname"]) {
            $adminmessage .= "<br /> API       : " . $ordersdtl["apiname"] . "<br> ";
        }
        $adminmessage .= "Reply    :" . $ordersdtl["reply"] . " <br> <br />\n        You can view order details from " . $here;
        $to[0] = $config["config_admin_mail"];
        $Subject = "IMEI order for Verification";
        if ($ordersdtl["server"]) {
            $Subject = "Server Order for Verification";
        }
        if ($config["adminotice_verifyorder"] && $config["adminnotice"]) {
            if ($attachment["name"]) {
                $filename = $attachment["tmp_name"];
                $handle = fopen($filename, "r");
                $contents = fread($handle, filesize($filename));
                fclose($handle);
                sendNotification("system", $Subject, $adminmessage, $to, "", $attachment["name"], $contents);
            } else {
                sendNotification("system", $Subject, $adminmessage, $to);
            }
        }
        return true;
    }
}
function getIMEIhappyhours($serviceId, $promotiondis = false)
{
    $day = date("D", time());
    $time = date("Y-m-d H:i", time());
    if ($promotiondis) {
        $or = "or (happy_hours_start='' and happy_hours_end='' and happy_hours_weekdays=''  and promotiondis!='0' and promotiondis!='')";
    }
    $sql = "select promotiondis,happy_hours_start,happy_hours_end,happy_hours_repetation,happy_hours_weekdays from tbl_services_imei where id='" . $serviceId . "' and (('" . $time . "' between happy_hours_start and happy_hours_end) or (happy_hours_weekdays like '%" . $day . "%') " . $or . ")";
    $happyhours = mysqli_fetch_assoc(dquery($sql));
    return $happyhours;
}
function genEncl($length = 6)
{
    global $config;
    if ($config["orderencleng"]) {
        $length = $config["orderencleng"];
    }
    $characters = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $randomString = "";
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}
function alphanumeric($oid)
{
    $dec = $oid;
    $an = "13579ABCDEFGHIJKLMNPQRSTUVWXYZ";
    $id = "";
    $base = 8;
    while ($base <= $dec) {
        $mod = $dec % $base;
        $id = $an[$mod] . $id;
        $dec = $dec / $base;
    }
    $id = $an[$dec] . $id;
    dquery("update tbl_order_imei set encnum='" . $id . "' where order_id='" . $oid . "'");
}
function addNewService($ServiceArr)
{
    global $db;
    unset($row);
    $row["service_name"] = str_replace("'", "", $ServiceArr["service_name"]);
    $row["newservice"] = 1;
    $row["credit"] = $ServiceArr["credit"];
    $row["group_id"] = $ServiceArr["group_id"];
    $row["status"] = $ServiceArr["status"];
    $row["active"] = $ServiceArr["active"];
    $row["API_ID"] = $ServiceArr["API_ID"];
    $row["API"] = $ServiceArr["API"];
    if ($ServiceArr["gateway"]) {
    }
    $row["qnt"] = $ServiceArr["qnt"];
    $row["apiserverid"] = $ServiceArr["apiserverid"];
    $row["qntoptions"] = $ServiceArr["qntoptions"];
    $row["minqnt"] = $ServiceArr["minqnt"];
    $row["maxqnt"] = $ServiceArr["maxqnt"];
    $row["time"] = $ServiceArr["time"];
    $row["info"] = $ServiceArr["info"];
    $row["maxqnt"] = $ServiceArr["maxqnt"];
    if ($ServiceArr["requires_mobile"] == "Required") {
        $row["model"] = 1;
    } else {
        $row["model"] = 0;
    }
    if ($ServiceArr["requires_provider"] == "Required") {
        $row["provider"] = 1;
    } else {
        $row["provider"] = 0;
    }
    if ($ServiceArr["requires_mep"] == "Required") {
        $row["mep"] = 1;
    } else {
        $row["mep"] = 0;
    }
    if ($ServiceArr["requires_prd"] == "Required") {
        $row["PRD"] = 1;
    } else {
        $row["PRD"] = 0;
    }
    if ($ServiceArr["requires_reference"] == "Required") {
        $row["Reference"] = 1;
    } else {
        $row["Reference"] = 0;
    }
    if ($ServiceArr["requires_kbh"] == "Required") {
        $row["KBH"] = 1;
    } else {
        $row["KBH"] = 0;
    }
    if ($ServiceArr["requires_pin"] == "Required") {
        $row["PIN"] = 1;
    } else {
        $row["PIN"] = 0;
    }
    if ($ServiceArr["requires_type"] == "Required") {
        $row["Type"] = 1;
    } else {
        $row["Type"] = 0;
    }
    if ($ServiceArr["requires_locks"] == "Required") {
        $row["Locks"] = 1;
    } else {
        $row["Locks"] = 0;
    }
    if ($ServiceArr["requires_SN"] == "Required") {
        $row["SN"] = 1;
    } else {
        $row["SN"] = 0;
    }
    if ($ServiceArr["requires_SecRO"] == "Required") {
        $row["SecRO"] = 1;
    } else {
        $row["SecRO"] = 0;
    }
    $row["assigned_country"] = $ServiceArr["assigned_country"];
    $row["assigned_brand"] = $ServiceArr["assigned_brands"];
    $row["assigned_model"] = $ServiceArr["assigned_mobiles"];
    $row["assigned_mep"] = $ServiceArr["assigned_mep"];
    $row["assigned_provider"] = $ServiceArr["assigned_network"];
    $row["listing"] = $ServiceArr["gateway"];
    $row["useasserver"] = $ServiceArr["useasserver"];
    $row["API_TYPEID"] = $ServiceArr["API_TYPEID"];
    $newsid = $db->insert("tbl_services_imei", $row);
    $DATA["groupid"] = "base";
    $DATA["price"] = $ServiceArr["credit"];
    $DATA["serviceid"] = $newsid;
    $DATA["currencyid"] = $_SESSION["system_default_currency"]["id"];
    $db->insert("tbl_service_pricing", $DATA);
    unset($DATA);
    $DATAG["groupid"] = "base";
    $DATAG["serviceid"] = $newsid;
    $DATAG["status"] = 1;
    $db->insert("tbl_service_status", $DATAG);
    unset($DATAG);
    $q = dquery("select * from tbl_client_group");
    while ($r = mysqli_fetch_assoc($q)) {
        $DATAG["groupid"] = $r["id"];
        $DATAG["serviceid"] = $newsid;
        $DATAG["status"] = 1;
        $db->insert("tbl_service_status", $DATAG);
        unset($DATAG);
    }
    return $newsid;
}

?>