<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

namespace SquareConnect\Model;

/**
 * Transaction Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class Transaction implements \ArrayAccess
{
    /**
     * $id The transaction's unique ID, issued by Square payments servers.
     * @var string
     */
    protected $id = NULL;
    /**
     * $location_id The ID of the transaction's associated location.
     * @var string
     */
    protected $location_id = NULL;
    /**
     * $created_at The time when the transaction was created, in RFC 3339 format.
     * @var string
     */
    protected $created_at = NULL;
    /**
     * $tenders The tenders used to pay in the transaction.
     * @var \SquareConnect\Model\Tender[]
     */
    protected $tenders = NULL;
    /**
     * $refunds Refunds that have been applied to any tender in the transaction.
     * @var \SquareConnect\Model\Refund[]
     */
    protected $refunds = NULL;
    /**
     * $reference_id If the transaction was created with the [Charge](#endpoint-transactions-charge) endpoint, this value is the same as the value provided for the `reference_id` parameter in the request to that endpoint. Otherwise, it is not set.
     * @var string
     */
    protected $reference_id = NULL;
    /**
     * $product The Square product that processed the transaction. See [TransactionProduct](#type-transactionproduct) for possible values
     * @var string
     */
    protected $product = NULL;
    /**
     * $client_id If the transaction was created in the Square Point of Sale app, this value is the ID generated for the transaction by Square Point of Sale.  This ID has no relationship to the transaction's canonical `id`, which is generated by Square's backend servers. This value is generated for bookkeeping purposes, in case the transaction cannot immediately be completed (for example, if the transaction is processed in offline mode).  It is not currently possible with the Connect API to perform a transaction lookup by this value.
     * @var string
     */
    protected $client_id = NULL;
    /**
     * $shipping_address The shipping address provided in the request, if any.
     * @var \SquareConnect\Model\Address
     */
    protected $shipping_address = NULL;
    /**
     * $order_id The order_id is an identifier for the order associated with this transaction, if any.
     * @var string
     */
    protected $order_id = NULL;
    /**
     * Array of property to type mappings. Used for (de)serialization 
     * @var string[]
     */
    public static $swaggerTypes = ["id" => "string", "location_id" => "string", "created_at" => "string", "tenders" => "\\SquareConnect\\Model\\Tender[]", "refunds" => "\\SquareConnect\\Model\\Refund[]", "reference_id" => "string", "product" => "string", "client_id" => "string", "shipping_address" => "\\SquareConnect\\Model\\Address", "order_id" => "string"];
    /** 
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[] 
     */
    public static $attributeMap = ["id" => "id", "location_id" => "location_id", "created_at" => "created_at", "tenders" => "tenders", "refunds" => "refunds", "reference_id" => "reference_id", "product" => "product", "client_id" => "client_id", "shipping_address" => "shipping_address", "order_id" => "order_id"];
    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    public static $setters = ["id" => "setId", "location_id" => "setLocationId", "created_at" => "setCreatedAt", "tenders" => "setTenders", "refunds" => "setRefunds", "reference_id" => "setReferenceId", "product" => "setProduct", "client_id" => "setClientId", "shipping_address" => "setShippingAddress", "order_id" => "setOrderId"];
    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    public static $getters = ["id" => "getId", "location_id" => "getLocationId", "created_at" => "getCreatedAt", "tenders" => "getTenders", "refunds" => "getRefunds", "reference_id" => "getReferenceId", "product" => "getProduct", "client_id" => "getClientId", "shipping_address" => "getShippingAddress", "order_id" => "getOrderId"];
    public function __construct($data = NULL)
    {
        if ($data != NULL) {
            if (isset($data["id"])) {
                $this->id = $data["id"];
            } else {
                $this->id = NULL;
            }
            if (isset($data["location_id"])) {
                $this->location_id = $data["location_id"];
            } else {
                $this->location_id = NULL;
            }
            if (isset($data["created_at"])) {
                $this->created_at = $data["created_at"];
            } else {
                $this->created_at = NULL;
            }
            if (isset($data["tenders"])) {
                $this->tenders = $data["tenders"];
            } else {
                $this->tenders = NULL;
            }
            if (isset($data["refunds"])) {
                $this->refunds = $data["refunds"];
            } else {
                $this->refunds = NULL;
            }
            if (isset($data["reference_id"])) {
                $this->reference_id = $data["reference_id"];
            } else {
                $this->reference_id = NULL;
            }
            if (isset($data["product"])) {
                $this->product = $data["product"];
            } else {
                $this->product = NULL;
            }
            if (isset($data["client_id"])) {
                $this->client_id = $data["client_id"];
            } else {
                $this->client_id = NULL;
            }
            if (isset($data["shipping_address"])) {
                $this->shipping_address = $data["shipping_address"];
            } else {
                $this->shipping_address = NULL;
            }
            if (isset($data["order_id"])) {
                $this->order_id = $data["order_id"];
            } else {
                $this->order_id = NULL;
            }
        }
    }
    public function getId()
    {
        return $this->id;
    }
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }
    public function getLocationId()
    {
        return $this->location_id;
    }
    public function setLocationId($location_id)
    {
        $this->location_id = $location_id;
        return $this;
    }
    public function getCreatedAt()
    {
        return $this->created_at;
    }
    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }
    public function getTenders()
    {
        return $this->tenders;
    }
    public function setTenders($tenders)
    {
        $this->tenders = $tenders;
        return $this;
    }
    public function getRefunds()
    {
        return $this->refunds;
    }
    public function setRefunds($refunds)
    {
        $this->refunds = $refunds;
        return $this;
    }
    public function getReferenceId()
    {
        return $this->reference_id;
    }
    public function setReferenceId($reference_id)
    {
        $this->reference_id = $reference_id;
        return $this;
    }
    public function getProduct()
    {
        return $this->product;
    }
    public function setProduct($product)
    {
        $this->product = $product;
        return $this;
    }
    public function getClientId()
    {
        return $this->client_id;
    }
    public function setClientId($client_id)
    {
        $this->client_id = $client_id;
        return $this;
    }
    public function getShippingAddress()
    {
        return $this->shipping_address;
    }
    public function setShippingAddress($shipping_address)
    {
        $this->shipping_address = $shipping_address;
        return $this;
    }
    public function getOrderId()
    {
        return $this->order_id;
    }
    public function setOrderId($order_id)
    {
        $this->order_id = $order_id;
        return $this;
    }
    public function offsetExists($offset)
    {
        return isset($this->{$offset});
    }
    public function offsetGet($offset)
    {
        return $this->{$offset};
    }
    public function offsetSet($offset, $value)
    {
        $this->{$offset} = $value;
    }
    public function offsetUnset($offset)
    {
        unset($this->{$offset});
    }
    public function __toString()
    {
        if (defined("JSON_PRETTY_PRINT")) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }
        return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
    }
}

?>