<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

namespace SquareConnect\Model;

/**
 * Checkout Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class Checkout implements \ArrayAccess
{
    /**
     * $id ID generated by Square Checkout when a new checkout is requested.
     * @var string
     */
    protected $id = NULL;
    /**
     * $checkout_page_url The URL that the buyer's browser should be redirected to after the checkout is completed.
     * @var string
     */
    protected $checkout_page_url = NULL;
    /**
     * $ask_for_shipping_address If `true`, Square Checkout will collect shipping information on your behalf and store that information with the transaction information in your Square Dashboard.  Default: `false`.
     * @var bool
     */
    protected $ask_for_shipping_address = NULL;
    /**
     * $merchant_support_email The email address to display on the Square Checkout confirmation page and confirmation email that the buyer can use to contact the merchant.  If this value is not set, the confirmation page and email will display the primary email address associated with the merchant's Square account.  Default: none; only exists if explicitly set.
     * @var string
     */
    protected $merchant_support_email = NULL;
    /**
     * $pre_populate_buyer_email If provided, the buyer's email is pre-populated on the checkout page as an editable text field.  Default: none; only exists if explicitly set.
     * @var string
     */
    protected $pre_populate_buyer_email = NULL;
    /**
     * $pre_populate_shipping_address If provided, the buyer's shipping info is pre-populated on the checkout page as editable text fields.  Default: none; only exists if explicitly set.
     * @var \SquareConnect\Model\Address
     */
    protected $pre_populate_shipping_address = NULL;
    /**
     * $redirect_url The URL to redirect to after checkout is completed with `checkoutId`, Square's `orderId`, `transactionId`, and `referenceId` appended as URL parameters. For example, if the provided redirect_url is `http://www.example.com/order-complete`, a successful transaction redirects the customer to:  `http://www.example.com/order-complete?checkoutId=xxxxxx&orderId=xxxxxx&referenceId=xxxxxx&transactionId=xxxxxx`  If you do not provide a redirect URL, Square Checkout will display an order confirmation page on your behalf; however Square strongly recommends that you provide a redirect URL so you can verify the transaction results and finalize the order through your existing/normal confirmation workflow.
     * @var string
     */
    protected $redirect_url = NULL;
    /**
     * $order Order to be checked out.
     * @var \SquareConnect\Model\Order
     */
    protected $order = NULL;
    /**
     * $created_at The time when the checkout was created, in RFC 3339 format.
     * @var string
     */
    protected $created_at = NULL;
    /**
     * $additional_recipients Additional recipients (other than the merchant) receiving a portion of this checkout. For example, fees assessed on the purchase by a third party integration.
     * @var \SquareConnect\Model\AdditionalRecipient[]
     */
    protected $additional_recipients = NULL;
    /**
     * Array of property to type mappings. Used for (de)serialization 
     * @var string[]
     */
    public static $swaggerTypes = ["id" => "string", "checkout_page_url" => "string", "ask_for_shipping_address" => "bool", "merchant_support_email" => "string", "pre_populate_buyer_email" => "string", "pre_populate_shipping_address" => "\\SquareConnect\\Model\\Address", "redirect_url" => "string", "order" => "\\SquareConnect\\Model\\Order", "created_at" => "string", "additional_recipients" => "\\SquareConnect\\Model\\AdditionalRecipient[]"];
    /** 
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[] 
     */
    public static $attributeMap = ["id" => "id", "checkout_page_url" => "checkout_page_url", "ask_for_shipping_address" => "ask_for_shipping_address", "merchant_support_email" => "merchant_support_email", "pre_populate_buyer_email" => "pre_populate_buyer_email", "pre_populate_shipping_address" => "pre_populate_shipping_address", "redirect_url" => "redirect_url", "order" => "order", "created_at" => "created_at", "additional_recipients" => "additional_recipients"];
    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    public static $setters = ["id" => "setId", "checkout_page_url" => "setCheckoutPageUrl", "ask_for_shipping_address" => "setAskForShippingAddress", "merchant_support_email" => "setMerchantSupportEmail", "pre_populate_buyer_email" => "setPrePopulateBuyerEmail", "pre_populate_shipping_address" => "setPrePopulateShippingAddress", "redirect_url" => "setRedirectUrl", "order" => "setOrder", "created_at" => "setCreatedAt", "additional_recipients" => "setAdditionalRecipients"];
    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    public static $getters = ["id" => "getId", "checkout_page_url" => "getCheckoutPageUrl", "ask_for_shipping_address" => "getAskForShippingAddress", "merchant_support_email" => "getMerchantSupportEmail", "pre_populate_buyer_email" => "getPrePopulateBuyerEmail", "pre_populate_shipping_address" => "getPrePopulateShippingAddress", "redirect_url" => "getRedirectUrl", "order" => "getOrder", "created_at" => "getCreatedAt", "additional_recipients" => "getAdditionalRecipients"];
    public function __construct($data = NULL)
    {
        if ($data != NULL) {
            if (isset($data["id"])) {
                $this->id = $data["id"];
            } else {
                $this->id = NULL;
            }
            if (isset($data["checkout_page_url"])) {
                $this->checkout_page_url = $data["checkout_page_url"];
            } else {
                $this->checkout_page_url = NULL;
            }
            if (isset($data["ask_for_shipping_address"])) {
                $this->ask_for_shipping_address = $data["ask_for_shipping_address"];
            } else {
                $this->ask_for_shipping_address = NULL;
            }
            if (isset($data["merchant_support_email"])) {
                $this->merchant_support_email = $data["merchant_support_email"];
            } else {
                $this->merchant_support_email = NULL;
            }
            if (isset($data["pre_populate_buyer_email"])) {
                $this->pre_populate_buyer_email = $data["pre_populate_buyer_email"];
            } else {
                $this->pre_populate_buyer_email = NULL;
            }
            if (isset($data["pre_populate_shipping_address"])) {
                $this->pre_populate_shipping_address = $data["pre_populate_shipping_address"];
            } else {
                $this->pre_populate_shipping_address = NULL;
            }
            if (isset($data["redirect_url"])) {
                $this->redirect_url = $data["redirect_url"];
            } else {
                $this->redirect_url = NULL;
            }
            if (isset($data["order"])) {
                $this->order = $data["order"];
            } else {
                $this->order = NULL;
            }
            if (isset($data["created_at"])) {
                $this->created_at = $data["created_at"];
            } else {
                $this->created_at = NULL;
            }
            if (isset($data["additional_recipients"])) {
                $this->additional_recipients = $data["additional_recipients"];
            } else {
                $this->additional_recipients = NULL;
            }
        }
    }
    public function getId()
    {
        return $this->id;
    }
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }
    public function getCheckoutPageUrl()
    {
        return $this->checkout_page_url;
    }
    public function setCheckoutPageUrl($checkout_page_url)
    {
        $this->checkout_page_url = $checkout_page_url;
        return $this;
    }
    public function getAskForShippingAddress()
    {
        return $this->ask_for_shipping_address;
    }
    public function setAskForShippingAddress($ask_for_shipping_address)
    {
        $this->ask_for_shipping_address = $ask_for_shipping_address;
        return $this;
    }
    public function getMerchantSupportEmail()
    {
        return $this->merchant_support_email;
    }
    public function setMerchantSupportEmail($merchant_support_email)
    {
        $this->merchant_support_email = $merchant_support_email;
        return $this;
    }
    public function getPrePopulateBuyerEmail()
    {
        return $this->pre_populate_buyer_email;
    }
    public function setPrePopulateBuyerEmail($pre_populate_buyer_email)
    {
        $this->pre_populate_buyer_email = $pre_populate_buyer_email;
        return $this;
    }
    public function getPrePopulateShippingAddress()
    {
        return $this->pre_populate_shipping_address;
    }
    public function setPrePopulateShippingAddress($pre_populate_shipping_address)
    {
        $this->pre_populate_shipping_address = $pre_populate_shipping_address;
        return $this;
    }
    public function getRedirectUrl()
    {
        return $this->redirect_url;
    }
    public function setRedirectUrl($redirect_url)
    {
        $this->redirect_url = $redirect_url;
        return $this;
    }
    public function getOrder()
    {
        return $this->order;
    }
    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }
    public function getCreatedAt()
    {
        return $this->created_at;
    }
    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }
    public function getAdditionalRecipients()
    {
        return $this->additional_recipients;
    }
    public function setAdditionalRecipients($additional_recipients)
    {
        $this->additional_recipients = $additional_recipients;
        return $this;
    }
    public function offsetExists($offset)
    {
        return isset($this->{$offset});
    }
    public function offsetGet($offset)
    {
        return $this->{$offset};
    }
    public function offsetSet($offset, $value)
    {
        $this->{$offset} = $value;
    }
    public function offsetUnset($offset)
    {
        unset($this->{$offset});
    }
    public function __toString()
    {
        if (defined("JSON_PRETTY_PRINT")) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }
        return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
    }
}

?>