(function(B) {
	var X = {
		topLeft: ["top", "left"],
		top: ["top", "center"],
		topRight: ["top", "right"],
		bottomLeft: ["bottom", "left"],
		bottom: ["bottom", "center"],
		bottomRight: ["bottom", "right"],
		leftTop: ["left", "top"],
		left: ["left", "center"],
		leftBottom: ["left", "bottom"],
		rightTop: ["right", "top"],
		right: ["right", "center"],
		rightBottom: ["right", "bottom"]
	};
	var r = {
		fade: ["vCover", "fade"],
		zoomIn: ["vCover", "zoom"],
		zoomOut: ["vCover", "zoom"],
		coverDown: ["vCover", "sliceDown"],
		coverUp: ["vCover", "sliceUp"],
		coverRight: ["hCover", "sliceRight"],
		coverLeft: ["hCover", "sliceLeft"],
		blockExpandDown: ["blocks", "expand"],
		blockExpandUp: ["blocks", "expand"],
		blockExpandRight: ["blocks", "expand"],
		blockExpandLeft: ["blocks", "expand"],
		diagonalFade: ["blocks", "diagonalFade"],
		reverseDiagonalFade: ["blocks", "diagonalFade"],
		diagonalExpand: ["blocks", "diagonalExpand"],
		reverseDiagonalExpand: ["blocks", "diagonalExpand"],
		diagonalShift: ["blocks", "diagonalShift"],
		reverseDiagonalShift: ["blocks", "diagonalShift"],
		blockRandomFade: ["blocks", "randomEffect"],
		blockRandomExpand: ["blocks", "randomEffect"],
		blockRandomDrop: ["blocks", "randomEffect"],
		zigZagDown: ["blocks", "zigZag"],
		zigZagUp: ["blocks", "zigZag"],
		zigZagRight: ["blocks", "zigZag"],
		zigZagLeft: ["blocks", "zigZag"],
		spiralIn: ["blocks", "spiral"],
		spiralOut: ["blocks", "spiral"],
		sliceDownRight: ["vSlices", "sliceDown"],
		sliceDownLeft: ["vSlices", "sliceDown"],
		sliceDownRandom: ["vSlices", "sliceDown"],
		sliceUpRight: ["vSlices", "sliceUp"],
		sliceUpLeft: ["vSlices", "sliceUp"],
		sliceUpRandom: ["vSlices", "sliceUp"],
		sliceFadeRight: ["vSlices", "fade"],
		sliceFadeLeft: ["vSlices", "fade"],
		verticalRandomFade: ["vSlices", "fade"],
		sliceAltRight: ["vSlices", "sliceAlt"],
		sliceAltLeft: ["vSlices", "sliceAlt"],
		blindsRight: ["vSlices", "blinds"],
		blindsLeft: ["vSlices", "blinds"],
		verticalRandomBlinds: ["vSlices", "blinds"],
		sliceMoveRight: ["vSlices", "move"],
		sliceMoveLeft: ["vSlices", "move"],
		sliceRightDown: ["hSlices", "sliceRight"],
		sliceRightUp: ["hSlices", "sliceRight"],
		sliceRightRandom: ["hSlices", "sliceRight"],
		sliceLeftDown: ["hSlices", "sliceLeft"],
		sliceLeftUp: ["hSlices", "sliceLeft"],
		sliceLeftRandom: ["hSlices", "sliceLeft"],
		sliceFadeDown: ["hSlices", "fade"],
		sliceFadeUp: ["hSlices", "fade"],
		horizontalRandomFade: ["hSlices", "fade"],
		sliceAltDown: ["hSlices", "sliceAlt"],
		sliceAltUp: ["hSlices", "sliceAlt"],
		blindsDown: ["hSlices", "blinds"],
		blindsUp: ["hSlices", "blinds"],
		horizontalRandomBlinds: ["hSlices", "blinds"],
		sliceMoveDown: ["hSlices", "move"],
		sliceMoveUp: ["hSlices", "move"],
		horizontalSlide: ["hSlide", "slide"],
		verticalSlide: ["vSlide", "slide"]
	};
	var V = "ontouchstart" in window;
	var s = a();
	var t = a(6);
	var f = q(2.9);
	var v = J();
	var Q = 500;
	var h = 50;
	var E = "updateThumbnails";
	var b = "resizeControlPanel";
	var d = "updateSize";
	var x = "rotator";
	var e = "rotatorInit";
	var k = "rotatorSlideChange";
	var U = "rotatorSlideComplete";
	var L = "rotatorFirst";
	var z = "rotatorLast";
	var P = "rotatorPlay";
	var w = "rotatorPause";
	var R = "rotatorPrevious";
	var o = "rotatorNext";
	var O = {
		linear: "linear",
		"": "ease",
		swing: "ease",
		ease: "ease",
		"ease-in": "ease-in",
		"ease-out": "ease-out",
		"ease-in-out": "ease-in-out",
		easeInQuad: "cubic-bezier(.55,.085,.68,.53)",
		easeOutQuad: "cubic-bezier(.25,.46,.45,.94)",
		easeInOutQuad: "cubic-bezier(.455,.03,.515,.955)",
		easeInCubic: "cubic-bezier(.55,.055,.675,.19)",
		easeOutCubic: "cubic-bezier(.215,.61,.355,1)",
		easeInOutCubic: "cubic-bezier(.645,.045,.355,1)",
		easeInQuart: "cubic-bezier(.895,.03,.685,.22)",
		easeOutQuart: "cubic-bezier(.165,.84,.44,1)",
		easeInOutQuart: "cubic-bezier(.77,0,.175,1)",
		easeInQuint: "cubic-bezier(.755,.05,.855,.06)",
		easeOutQuint: "cubic-bezier(.23,1,.32,1)",
		easeInOutQuint: "cubic-bezier(.86,0,.07,1)",
		easeInSine: "cubic-bezier(.47,0,.745,.715)",
		easeOutSine: "cubic-bezier(.39,.575,.565,1)",
		easeInOutSine: "cubic-bezier(.445,.05,.55,.95)",
		easeInExpo: "cubic-bezier(.95,.05,.795,.035)",
		easeOutExpo: "cubic-bezier(.19,1,.22,1)",
		easeInOutExpo: "cubic-bezier(1,0,0,1)",
		easeInCirc: "cubic-bezier(.6,.04,.98,.335)",
		easeOutCirc: "cubic-bezier(.075,.82,.165,1)",
		easeInOutCirc: "cubic-bezier(.785,.135,.15,.86)",
		easeInBack: "cubic-bezier(.60,-.28,.735,.045)",
		easeOutBack: "cubic-bezier(.175,.885,.32,1.275)",
		easeInOutBack: "cubic-bezier(.68,-.55,.265,1.55)"
	};
	m("transform");
	m("transition");
	m("backgroundSize");
	m("borderRadius");
	var g;
	var S;
	switch (B.support.transition) {
	case "WebkitTransition":
		g = "-webkit-transition";
		S = "webkitTransitionEnd";
		break;
	case "MozTransition":
		g = "-moz-transition";
		S = "transitionend";
		break;
	case "OTransition":
		g = "-o-transition";
		S = "oTransitionEnd";
		break;
	default:
		g = "transition";
		S = "transitionend";
		break
	}
	function y(Z, ab) {
		this._$timer = B("<div></div>").addClass("br-bar-timer");
		var aa = H(X[ab], X.top);
		this._$timer.addClass("bottom" === aa[0] ? "br-bottom" : "br-top");
		Z.append(this._$timer)
	}
	y.prototype = {
		start: function(Z) {
			this._$timer.animate({
				width: "101%"
			}, {
				duration: Z,
				easing: "linear",
				queue: false
			})
		},
		stop: function() {
			this._$timer.stop().width(0)
		},
		pause: function() {
			this._$timer.stop()
		}
	};
	function Y(Z, ab) {
		this._$timer = B('<div class="br-pie-timer">							<div class="br-rside"><div class="br-rotate"></div></div>							<div class="br-lside"><div class="br-rotate"></div></div>						  </div>');
		var aa = H(X[ab], X.topRight);
		this._$timer.css(aa[0], 0).css(aa[1], 0).addClass("br-opacity-transition");
		this._$left = this._$timer.find(">.br-lside .br-rotate");
		this._$right = this._$timer.find(">.br-rside .br-rotate");
		this._elapsed = this._delay = 0;
		this._startTime;
		Z.append(this._$timer)
	}
	Y.prototype = {
		start: function(Z) {
			if (0 === this._delay) {
				this._delay = Z;
				this._$timer.addClass("br-opacity");
				this._$left.add(this._$right).stopTransition(true).css({
					transform: "rotateZ(0deg)"
				})
			}
			var aa = this._delay / 2;
			this._startTime = (new Date()).getTime();
			this._$right.transition({
				transform: "rotateZ(180deg)"
			}, Math.max(aa - this._elapsed, 0), "linear", B.proxy(function() {
				var ab = Math.max(aa - Math.max(this._elapsed - aa, 0), 0);
				this._$left.transition({
					transform: "rotateZ(180deg)"
				}, ab, "linear")
			}, this))
		},
		stop: function() {
			this._elapsed = this._delay = 0;
			this._$left.add(this._$right).stopTransition(true).css({
				transform: "rotateZ(180deg)"
			});
			this._$timer.removeClass("br-opacity")
		},
		pause: function() {
			this._$left.add(this._$right).stopTransition(true);
			this._elapsed += (new Date()).getTime() - this._startTime;
			var aa = this._elapsed / this._delay,
				Z = aa * 360;
			if (aa <= 0.5) {
				this._$right.css({
					transform: "rotateZ(" + Z + "deg)"
				})
			} else {
				this._$left.css({
					transform: "rotateZ(" + (Z - 180) + "deg)"
				})
			}
		}
	};
	function n(aa, Z) {
		this._parent = aa;
		this._intervalId = null;
		this._delay = Z
	}
	n.prototype = {
		create: function(Z) {
			var aa = this._total,
				ab = "",
				ac = this._parent._$screen.find(">.br-effects");
			while (aa--) {
				ab += '<div class="' + Z + '"></div>'
			}
			ac.append(ab);
			$el = ac.children("." + Z).slice(-this._total);
			$el.css({
				backgroundColor: this._parent._$screen.css("backgroundColor")
			});
			if (f) {
				$el.css("backface-visibility", "visible")
			}
			return $el
		},
		clear: function() {
			clearInterval(this._intervalId);
			this._$el.stopTransition(true, false).css({
				visibility: "hidden"
			});
			this._parent._inProgress = false
		},
		resize: function(Z) {
			this.clear();
			this._width = Math.ceil(this._$el.data("width") * Z);
			this._height = Math.ceil(this._$el.data("height") * Z)
		},
		setImage: function(Z, aa) {
			Z.find(">img").remove();
			Z.append(B('<img src="' + aa.attr("src") + '" alt=""/>').css({
				top: aa.css("top"),
				left: aa.css("left"),
				width: aa.width(),
				height: aa.height()
			}))
		},
		setBgImage: function(Z, aa) {
			Z.css({
				backgroundImage: "url(" + aa.attr("src") + ")",
				backgroundSize: aa.css("width") + " " + aa.css("height"),
				backgroundPosition: aa.css("left") + " " + aa.css("top")
			})
		},
		animate: function(ad, aa, ac, ae) {
			var Z = 0,
				ab = this._total - 1;
			this._intervalId = setInterval(B.proxy(function() {
				if (Z !== ab) {
					B(ad[Z]).transition(aa, ac, ae)
				} else {
					B(ad[Z]).transition(aa, ac, ae, B.proxy(function() {
						this._parent.displayCurrent();
						this._$el.css({
							visibility: "hidden"
						})
					}, this))
				}
				if (++Z == this._total) {
					clearInterval(this._intervalId)
				}
			}, this), this._delay)
		}
	};
	N.prototype = new n();
	N.prototype.constructor = N;
	function N(ab, Z) {
		n.call(this, ab, 0);
		this._cssTransform = this._parent._cssTransform;
		this._orientation = Z;
		this._total = 1;
		var aa;
		if ("vertical" === this._orientation) {
			this._position = "top";
			aa = "br-vslide"
		} else {
			this._position = "left";
			aa = "br-hslide"
		}
		this._$el = this.create(aa).append("<div></div><div></div>");
		this._$slides = this._$el.children()
	}
	N.prototype.slide = function(ag, ai, ac, ad) {
		var Z, af, ae = {},
			ab = this._parent._$prevItem.find(">img.br-main-img"),
			ah, aa;
		if ("vertical" === this._orientation) {
			ah = -this._$slides.height();
			aa = "translateY"
		} else {
			ah = -this._$slides.width();
			aa = "translateX"
		}
		if (this._parent._backward) {
			af = this._$slides.first();
			Z = this._$slides.last();
			if (this._cssTransform) {
				this._$el.css({
					transform: aa + "(" + ah + "px)"
				});
				ae.transform = aa + "(0)"
			} else {
				this._$el.css(this._position, ah);
				ae[this._position] = 0
			}
		} else {
			af = this._$slides.last();
			Z = this._$slides.first();
			if (this._cssTransform) {
				this._$el.css({
					transform: aa + "(0)"
				});
				ae.transform = aa + "(" + ah + "px)"
			} else {
				this._$el.css(this._position, 0);
				ae[this._position] = ah
			}
		}
		if (B.support.backgroundSize) {
			this.setBgImage(Z, ab);
			this.setBgImage(af, ag)
		} else {
			this.setImage(Z, ab);
			this.setImage(af, ag)
		}
		if (v) {
			setTimeout(B.proxy(function() {
				this._$el.css({
					visibility: "visible"
				});
				this._parent._$items.css({
					visibility: "hidden"
				});
				this.animate(this._$el.toArray(), ae, ac, ad)
			}, this), 1)
		} else {
			this._$el.css({
				visibility: "visible"
			});
			this._parent._$items.css({
				visibility: "hidden"
			});
			this.animate(this._$el.toArray(), ae, ac, ad)
		}
	};
	W.prototype = new n();
	W.prototype.constructor = W;
	function W(aa, ab, Z) {
		n.call(this, aa, Z);
		this._cssTransform = this._parent._cssTransform;
		this._total = ab;
		this._width = Math.ceil(this._parent._stageWidth / this._total);
		this._$el = this.create("br-vslice").data({
			width: this._width
		})
	}
	W.prototype.sliceDown = function(Z, aa, ab, ad) {
		var ac = this._$el.toArray();
		if ("sliceDownLeft" === aa) {
			ac.reverse()
		} else {
			if ("sliceDownRandom" === aa) {
				p(ac)
			}
		}
		if (this._cssTransform) {
			this.set(Z, {
				transform: "translateY(-100%)"
			});
			this.animate(ac, {
				transform: "translateY(0)"
			}, ab, ad)
		} else {
			this.set(Z, {
				top: -this._$el.height()
			});
			this.animate(ac, {
				top: 0
			}, ab, ad)
		}
	};
	W.prototype.sliceUp = function(Z, aa, ab, ad) {
		var ac = this._$el.toArray();
		if ("sliceUpLeft" === aa) {
			ac.reverse()
		} else {
			if ("sliceUpRandom" === aa) {
				p(ac)
			}
		}
		if (this._cssTransform) {
			this.set(Z, {
				transform: "translateY(100%)"
			});
			this.animate(ac, {
				transform: "translateY(0)"
			}, ab, ad)
		} else {
			this.set(Z, {
				top: this._$el.height()
			});
			this.animate(ac, {
				top: 0
			}, ab, ad)
		}
	};
	W.prototype.sliceAlt = function(Z, aa, ab, ad) {
		var ac = this._$el.toArray();
		if ("sliceAltLeft" === aa) {
			ac.reverse()
		}
		if (this._cssTransform) {
			this.set(Z, {
				transform: "translateY(-100%)"
			});
			this._$el.filter(":odd").css({
				transform: "translateY(100%)"
			});
			this.animate(ac, {
				transform: "translateY(0)"
			}, ab, ad)
		} else {
			this.set(Z, {
				top: -this._$el.height()
			});
			this._$el.filter(":odd").css({
				top: this._$el.height()
			});
			this.animate(ac, {
				top: 0
			}, ab, ad)
		}
	};
	W.prototype.blinds = function(Z, aa, ab, ad) {
		this.set(Z, {
			width: 0
		});
		var ac = this._$el.toArray();
		if ("blindsLeft" === aa) {
			ac.reverse()
		} else {
			if ("verticalRandomBlinds" === aa) {
				p(ac)
			}
		}
		this.animate(ac, {
			width: this._width + "px"
		}, ab, ad)
	};
	W.prototype.fade = function(Z, aa, ab, ad) {
		this.set(Z, {
			opacity: 0
		});
		var ac = this._$el.toArray();
		if ("sliceFadeLeft" === aa) {
			ac.reverse()
		} else {
			if ("verticalRandomFade" === aa) {
				p(ac)
			}
		}
		this.animate(ac, {
			opacity: 1
		}, ab, ad)
	};
	W.prototype.move = function(Z, ab, ac, ae) {
		var ad = this._$el.toArray(),
			aa = this._$el.parent().width();
		if ("sliceMoveRight" === ab) {
			ad.reverse();
			aa *= -1
		}
		if (this._cssTransform) {
			this.set(Z, {
				transform: "translateX(" + aa + "px)"
			});
			this.animate(ad, {
				transform: "translateX(0)"
			}, ac, ae)
		} else {
			this.set(Z, {
				left: "+=" + aa
			});
			this.animate(ad, {
				left: "-=" + aa
			}, ac, ae)
		}
	};
	W.prototype.zoom = function(Z, aa, ab, ac) {
		if (this._cssTransform) {
			this.set(Z, "zoomOut" === aa ? {
				transform: "scale(2)"
			} : {
				transform: "scale(0)"
			});
			this.animate(this._$el.toArray(), {
				transform: "scale(1)"
			}, ab, ac)
		} else {
			this.fade(Z, aa, ab, ac)
		}
	};
	W.prototype.set = function(aa, Z) {
		var ab = aa.position().left;
		if (B.support.backgroundSize) {
			this.setBgImage(this._$el, aa)
		} else {
			this.setImage(this._$el, aa)
		}
		var ac = this._$el.parent().width();
		this._$el.each(B.proxy(function(ah, af) {
			var ae = Math.min(this._width, ac),
				ag = ah * this._width,
				ad = (ab - ag) + "px";
			B(af).css({
				left: ag,
				width: ae
			});
			if (B.support.backgroundSize) {
				B(af).css({
					backgroundPosition: ad + " " + aa.css("top")
				})
			} else {
				B(af).find(">img").css({
					left: ad
				})
			}
			ac -= ae
		}, this));
		this._$el.css(B.extend({
			opacity: 1,
			top: 0,
			visibility: "visible",
			transform: "none"
		}, Z))
	};
	T.prototype = new n();
	T.prototype.constructor = T;
	function T(aa, ab, Z) {
		n.call(this, aa, Z);
		this._cssTransform = this._parent._cssTransform;
		this._total = ab;
		this._height = Math.ceil(this._parent._stageHeight / this._total);
		this._$el = this.create("br-hslice").data({
			height: this._height
		})
	}
	T.prototype.sliceRight = function(Z, aa, ab, ad) {
		var ac = this._$el.toArray();
		if ("sliceRightUp" === aa) {
			ac.reverse()
		} else {
			if ("sliceRightRandom" === aa) {
				p(ac)
			}
		}
		if (this._cssTransform) {
			this.set(Z, {
				transform: "translateX(-100%)"
			});
			this.animate(ac, {
				transform: "translateX(0)"
			}, ab, ad)
		} else {
			this.set(Z, {
				left: -this._$el.width()
			});
			this.animate(ac, {
				left: 0
			}, ab, ad)
		}
	};
	T.prototype.sliceLeft = function(Z, aa, ab, ad) {
		var ac = this._$el.toArray();
		if ("sliceLeftUp" === aa) {
			ac.reverse()
		} else {
			if ("sliceLeftRandom" === aa) {
				p(ac)
			}
		}
		if (this._cssTransform) {
			this.set(Z, {
				transform: "translateX(100%)"
			});
			this.animate(ac, {
				transform: "translateX(0)"
			}, ab, ad)
		} else {
			this.set(Z, {
				left: this._$el.width()
			});
			this.animate(ac, {
				left: 0
			}, ab, ad)
		}
	};
	T.prototype.sliceAlt = function(Z, aa, ab, ad) {
		var ac = this._$el.toArray();
		if ("sliceAltUp" === aa) {
			ac.reverse()
		}
		if (this._cssTransform) {
			this.set(Z, {
				transform: "translateX(-100%)"
			});
			this._$el.filter(":odd").css({
				transform: "translateX(100%)"
			});
			this.animate(ac, {
				transform: "translateX(0)"
			}, ab, ad)
		} else {
			this.set(Z, {
				left: -this._$el.width()
			});
			this._$el.filter(":odd").css({
				left: this._$el.width()
			});
			this.animate(ac, {
				left: 0
			}, ab, ad)
		}
	};
	T.prototype.blinds = function(Z, aa, ab, ad) {
		this.set(Z, {
			height: 0
		});
		var ac = this._$el.toArray();
		if ("blindsUp" === aa) {
			ac.reverse()
		} else {
			if ("horizontalRandomBlinds" === aa) {
				p(ac)
			}
		}
		this.animate(ac, {
			height: this._height + "px"
		}, ab, ad)
	};
	T.prototype.fade = function(Z, aa, ab, ad) {
		this.set(Z, {
			opacity: 0
		});
		var ac = this._$el.toArray();
		if ("sliceFadeUp" === aa) {
			ac.reverse()
		} else {
			if ("horizontalRandomFade" === aa) {
				p(ac)
			}
		}
		this.animate(ac, {
			opacity: 1
		}, ab, ad)
	};
	T.prototype.move = function(aa, ab, ac, ae) {
		var ad = this._$el.toArray(),
			Z = this._$el.parent().height();
		if ("sliceMoveDown" === ab) {
			ad.reverse();
			Z *= -1
		}
		if (this._cssTransform) {
			this.set(aa, {
				transform: "translateY(" + Z + "px)"
			});
			this.animate(ad, {
				transform: "translateY(0)"
			}, ac, ae)
		} else {
			this.set(aa, {
				top: "+=" + Z
			});
			this.animate(ad, {
				top: "-=" + Z
			}, ac, ae)
		}
	};
	T.prototype.set = function(ac, ab) {
		var aa = ac.position().top;
		if (B.support.backgroundSize) {
			this.setBgImage(this._$el, ac)
		} else {
			this.setImage(this._$el, ac)
		}
		var Z = this._$el.parent().height();
		this._$el.each(B.proxy(function(ah, ae) {
			var ad = Math.min(this._height, Z),
				af = ah * this._height,
				ag = (aa - af) + "px";
			B(ae).css({
				top: af,
				height: ad
			});
			if (B.support.backgroundSize) {
				B(ae).css({
					backgroundPosition: ac.css("left") + " " + ag
				})
			} else {
				B(ae).find(">img").css({
					top: ag
				})
			}
			Z -= ad
		}, this));
		this._$el.css(B.extend({
			opacity: 1,
			left: 0,
			visibility: "visible",
			transform: "none"
		}, ab))
	};
	u.prototype = new n();
	u.prototype.constructor = u;
	function u(ad, ae, af, ab) {
		n.call(this, ad, ab);
		this._cssTransform = this._parent._cssTransform;
		this._blockArray;
		this._numRows = ae;
		this._numCols = af;
		this._width = Math.ceil(this._parent._stageWidth / this._numCols);
		this._height = Math.ceil(this._parent._stageHeight / this._numRows);
		this._total = this._numRows * this._numCols;
		this._$el = this.create("br-block").data({
			width: this._width,
			height: this._height
		});
		var Z = 0;
		this._blockArray = [];
		for (var ac = 0; ac < this._numRows; ac++) {
			this._blockArray[ac] = [];
			for (var aa = 0; aa < this._numCols; aa++) {
				this._blockArray[ac][aa] = this._$el.eq(Z++)
			}
		}
	}
	u.prototype.diagonalFade = function(Z, aa, ab, ad) {
		this.set(Z, {
			opacity: 0
		});
		var ac = this.getDiagonalArray();
		if ("reverseDiagonalFade" === aa) {
			ac.reverse()
		}
		this.animate(ac, {
			opacity: 1
		}, ab, ad)
	};
	u.prototype.diagonalExpand = function(Z, ab, ac, ae) {
		var ad = this.getDiagonalArray(),
			aa = this.getExpandCSS();
		this.set(Z, aa.from);
		if ("reverseDiagonalExpand" === ab) {
			ad.reverse()
		}
		this.animate(ad, aa.to, ac, ae)
	};
	u.prototype.diagonalShift = function(aa, ac, ad, af) {
		var ae = this.getDiagonalArray(),
			Z = this._width,
			ab = this._height;
		if ("reverseDiagonalShift" === ac) {
			ae.reverse();
			Z *= -1;
			ab *= -1
		}
		if (this._cssTransform) {
			this.set(aa, {
				opacity: 0,
				transform: "translate(" + Z + "px, " + ab + "px)"
			});
			this.animate(ae, {
				opacity: 1,
				transform: "translate(0, 0)"
			}, ad, af)
		} else {
			this.set(aa, {
				opacity: 0,
				left: "+=" + Z,
				top: "+=" + ab
			});
			this.animate(ae, {
				opacity: 1,
				left: "-=" + Z,
				top: "-=" + ab
			}, ad, af)
		}
	};
	u.prototype.randomEffect = function(Z, ah, aa, ac) {
		var ab = this._$el.toArray();
		p(ab);
		var ae, af;
		if ("blockRandomDrop" === ah) {
			var ag = this._$el.parent().height();
			if (this._cssTransform) {
				ae = {
					transform: "translateY(" + -ag + "px)"
				};
				af = {
					transform: "translateY(0)"
				}
			} else {
				ae = {
					top: "-=" + ag
				};
				af = {
					top: "+=" + ag
				}
			}
		} else {
			if ("blockRandomExpand" === ah) {
				var ad = this.getExpandCSS();
				ae = ad.from;
				af = ad.to
			} else {
				ae = {
					opacity: 0
				};
				af = {
					opacity: 1
				}
			}
		}
		this.set(Z, ae);
		this.animate(ab, af, aa, ac)
	};
	u.prototype.zigZag = function(Z, aa, ab, ad) {
		this.set(Z, {
			opacity: 0
		});
		var ac = this.getZigZagArray(aa);
		if ("zigZagLeft" === aa || "zigZagUp" === aa) {
			ac.reverse()
		}
		this.animate(ac, {
			opacity: 1
		}, ab, ad)
	};
	u.prototype.spiral = function(Z, aa, ab, ad) {
		this.set(Z, {
			opacity: 0
		});
		var ac = this.getSpiralArray();
		if ("spiralOut" === aa) {
			ac.reverse()
		}
		this.animate(ac, {
			opacity: 1
		}, ab, ad)
	};
	u.prototype.expand = function(Z, ab, ac, ad) {
		var aa = this.getExpandCSS();
		this.set(Z, aa.from);
		this.animate(this.getDirectionalArray(ab), aa.to, ac, ad)
	};
	u.prototype.getExpandCSS = function() {
		if (this._cssTransform) {
			return {
				from: {
					transform: "scale(0)"
				},
				to: {
					transform: "scale(1)"
				}
			}
		} else {
			return {
				from: {
					width: 0,
					height: 0
				},
				to: {
					width: this._width + "px",
					height: this._height + "px"
				}
			}
		}
	};
	u.prototype.set = function(Z, af) {
		var ag = Z.position().top,
			am = Z.position().left;
		if (B.support.backgroundSize) {
			this.setBgImage(this._$el, Z)
		} else {
			this.setImage(this._$el, Z)
		}
		var an = this._$el.parent(),
			al = an.height();
		for (var ad = 0; ad < this._numRows; ad++) {
			var ae = an.width(),
				ak = Math.min(this._height, al);
			al -= ak;
			for (var ac = 0; ac < this._numCols; ac++) {
				var aa = Math.min(this._width, ae),
					ai = ad * this._height,
					ab = ac * this._width,
					aj = (am - ab),
					ah = (ag - ai),
					ao = this._blockArray[ad][ac];
				ao.css({
					top: ai,
					left: ab,
					width: aa,
					height: ak
				});
				if (B.support.backgroundSize) {
					ao.css({
						backgroundPosition: aj + "px " + ah + "px"
					})
				} else {
					ao.find(">img").css({
						left: aj,
						top: ah
					})
				}
				ae -= aa
			}
		}
		this._$el.css(B.extend({
			opacity: 1,
			visibility: "visible",
			transform: "none"
		}, af))
	};
	u.prototype.getDiagonalArray = function() {
		var aa = [];
		var ab = 0,
			Z = (this._numRows - 1) + (this._numCols - 1) + 1;
		while (ab != Z) {
			i = Math.min(this._numRows - 1, ab);
			while (i >= 0) {
				j = Math.abs(i - ab);
				if (j >= this._numCols) {
					break
				}
				aa.push(this._blockArray[i][j]);
				i--
			}
			ab++
		}
		return aa
	};
	u.prototype.getZigZagArray = function(ac) {
		var ab = 0,
			Z = 0,
			aa = true;
		var ae = [];
		if ("zigZagUp" === ac || "zigZagDown" === ac) {
			for (var ad = 0; ad < this._total; ad++) {
				ae[ad] = this._blockArray[ab][Z];
				aa ? Z++ : Z--;
				if (Z == this._numCols || Z < 0) {
					aa = !aa;
					Z = (aa ? 0 : this._numCols - 1);
					ab++
				}
			}
		} else {
			for (var ad = 0; ad < this._total; ad++) {
				ae[ad] = this._blockArray[ab][Z];
				aa ? ab++ : ab--;
				if (ab == this._numRows || ab < 0) {
					aa = !aa;
					ab = (aa ? 0 : this._numRows - 1);
					Z++
				}
			}
		}
		return ae
	};
	u.prototype.getDirectionalArray = function(ab) {
		var ac = [];
		switch (ab) {
		case "blockExpandRight":
			for (var Z = 0; Z < this._numCols; Z++) {
				for (var aa = 0; aa < this._numRows; aa++) {
					ac.push(this._blockArray[aa][Z])
				}
			}
			break;
		case "blockExpandLeft":
			for (var Z = this._numCols - 1; Z >= 0; Z--) {
				for (var aa = 0; aa < this._numRows; aa++) {
					ac.push(this._blockArray[aa][Z])
				}
			}
			break;
		case "blockExpandUp":
			for (var aa = this._numRows - 1; aa >= 0; aa--) {
				for (var Z = 0; Z < this._numCols; Z++) {
					ac.push(this._blockArray[aa][Z])
				}
			}
			break;
		default:
			ac = this._$el.toArray();
			break
		}
		return ac
	};
	u.prototype.getSpiralArray = function() {
		var ad = 0,
			ac = 0;
		var aa = this._numRows - 1;
		var af = this._numCols - 1;
		var ab = 0;
		var Z = af;
		var ag = [];
		while (aa >= 0 && af >= 0) {
			var ae = 0;
			while (true) {
				ag.push(this._blockArray[ad][ac]);
				if ((++ae) > Z) {
					break
				}
				switch (ab) {
				case 0:
					ac++;
					break;
				case 1:
					ad++;
					break;
				case 2:
					ac--;
					break;
				case 3:
					ad--;
					break
				}
			}
			switch (ab) {
			case 0:
				ab = 1;
				Z = (--aa);
				ad++;
				break;
			case 1:
				ab = 2;
				Z = (--af);
				ac--;
				break;
			case 2:
				ab = 3;
				Z = (--aa);
				ad--;
				break;
			case 3:
				ab = 0;
				Z = (--af);
				ac++;
				break
			}
		}
		return ag
	};
	function I(aa, Z) {
		this._options = Z;
		this._stageWidth = Z.width;
		this._stageHeight = Z.height;
		this._rotate = Z.autoPlay;
		this._cssTransition = B.support.transition && !f ? Z.cssTransition : false;
		this._cssTransform = B.support.transform && this._cssTransition;
		this._numItems;
		this._currIndex;
		this._effects = {};
		this._backward;
		this._verticalCPanel;
		this._timer;
		this._timerId = null;
		this._tooltipId = null;
		this._layerIds = [];
		this._inProgress = false;
		this._start;
		this._delay = 0;
		this._cpAlign;
		this._effectArray;
		this._startX;
		this._startY;
		this._swipeMove;
		this._swipeStart;
		this._touchScrolling;
		this._scrollEasing;
		this._promise;
		this._winWidth;
		this._$rotator = B(aa);
		this._$stage;
		this._$screen;
		this._$layers;
		this._$preloader;
		this._$cpanel;
		this._$cpWrapper;
		this._$extPanel;
		this._$thumbPanel;
		this._$list;
		this._$items;
		this._$thumbList;
		this._$thumbs;
		this._$tooltip;
		this._$currItem;
		this._$prevItem;
		this._namespace = "." + ((typeof this._$rotator.attr("id") !== "undefined") ? this._$rotator.attr("id") : "rotator");
		this.init()
	}
	I.prototype = {
		init: function() {
			if (!this._cssTransition) {
				B.fn.transition = B.fn.animate;
				B.fn.stopTransition = B.fn.stop
			}
			this._$list = this._$rotator.find(">ul");
			if (!this._$list.hasClass("br-slides")) {
				this._$list.addClass("br-slides")
			}
			if (this._options.shuffle) {
				this.shuffleItems(this._$list)
			}
			this._$items = this._$list.children("li").addClass("br-item");
			this._numItems = this._$items.length;
			if ("random" === this._options.startIndex) {
				this._currIndex = Math.floor(Math.random() * this._numItems)
			} else {
				var Z = parseInt(this._options.startIndex, 0);
				this._currIndex = (!isNaN(Z) && 0 <= Z && Z < this._numItems) ? Z : 0
			}
			if (this._numItems <= 1) {
				this._rotate = false
			}
			if (!this._options.responsive) {
				this._$rotator.css({
					width: this._stageWidth,
					height: this._stageHeight
				})
			}
			this.initStage();
			this.initItems();
			this.initCPanel();
			this.initEffects();
			if (this._options.responsive) {
				this.resize();
				B(window).bind("resize" + this._namespace, B.proxy(this.resize, this))
			}
			if (1 < this._numItems) {
				if (this._options.mousewheel) {
					this._$rotator.bind("mousewheel DOMMouseScroll", B.proxy(this.mousescroll, this))
				}
				if (this._options.keyboard) {
					B(document).bind("keyup" + this._namespace, B.proxy(this.keyControl, this))
				}
				if (this._options.pauseOnHover) {
					this._$rotator.hover(B.proxy(this.pause, this), B.proxy(function(aa) {
						if (!this.onTooltip(aa)) {
							this.play()
						}
					}, this))
				}
				if (V && this._options.swipe) {
					this._$rotator.bind("touchstart", B.proxy(this.touchStart, this))
				}
			}
			if (this._numItems) {
				if (!t) {
					this.loadNextImage(this._$items.toArray())
				} else {
					this.loadAllImages()
				}
				this.loadSlide()
			}
		},
		initStage: function() {
			this.initBorder();
			this._$list.wrap('<div class="br-stage"><div class="br-screen"></div></div>');
			this._$screen = this._$list.parent();
			this._$stage = this._$screen.parent();
			this.setBackgroundColor(this._$screen, this._options.backgroundColor);
			this._$screen.append('<div class="br-effects"></div><div class="br-preloader"></div><div class="br-links"></div><div class="br-layers"></div>');
			this._$preloader = this._$screen.find(">.br-preloader");
			if (false !== this._options.timer && "none" !== this._options.timer) {
				if ("pie" === this._options.timer) {
					if (this._cssTransform) {
						this._timer = new Y(this._$screen, this._options.timerAlign)
					}
				} else {
					this._timer = new y(this._$screen, this._options.timerAlign)
				}
			}
			if ("large" === this._options.navButtons && 1 < this._numItems) {
				this.initSideButtons()
			}
		},
		initBorder: function() {
			var ab = ["borderWidth", "borderColor", "borderStyle", "borderRadius"];
			for (var aa = 0; aa < ab.length; aa++) {
				var Z = ab[aa],
					ac = this._options[Z];
				if (typeof ac !== "undefined") {
					this._$rotator.css(Z, ac)
				}
			}
			if (0 < parseInt(this._$rotator.css("borderRightWidth"), 0)) {
				this._$rotator.css({
					backgroundColor: this._$rotator.css("borderRightColor")
				})
			}
		},
		createBorderWrapper: function() {
			var Z = B("<div></div>").addClass("br-wrapper").copyBorder(this._$rotator);
			this._$rotator.css({
				borderWidth: 0,
				borderRadiusTopLeft: 0,
				borderRadiusTopRight: 0,
				borderRadiusBottomLeft: 0,
				borderRadiusBottomRight: 0
			});
			if (!this._options.responsive) {
				Z.css({
					width: this._$rotator.outerWidth(true),
					height: this._$rotator.outerHeight(true)
				})
			}
			this._$rotator.wrap(Z)
		},
		initSideButtons: function() {
			var Z = B("<div><div></div></div>").addClass("br-side-prev").click(B.proxy(this.prevSlide, this));
			var ab = B("<div><div></div></div>").addClass("br-side-next").click(B.proxy(this.nextSlide, this));
			var aa = Z.add(ab).mousedown(F);
			if (!f) {
				aa.find(">div").addClass("br-opacity-transition")
			}
			this._$screen.append(aa);
			if (this._options.navButtonsOnHover) {
				aa.css({
					opacity: 0
				});
				this._$rotator.hover(function() {
					aa.animate({
						opacity: 1
					}, {
						duration: Q,
						queue: false
					})
				}, B.proxy(function(ac) {
					if (!this.onTooltip(ac)) {
						aa.animate({
							opacity: 0
						}, {
							duration: Q,
							queue: false
						})
					}
				}, this))
			}
		},
		initItems: function() {
			for (var ab = 0; ab < this._numItems; ab++) {
				var ag = this._$items.eq(ab),
					aa = ag.children(":first"),
					Z, ac, ai;
				if (aa.is("a")) {
					aa.addClass("br-img-link");
					Z = aa.find(">img");
					if (0 === Z.length) {
						ac = aa.attr("href");
						ai = H(aa.text(), "")
					}
					ag.data("imgurl", aa.attr("href")).append(B('<img alt=""/>').addClass("br-main-img"))
				} else {
					Z = ag.find(">img:not(.tt-img):first").addClass("br-main-img")
				}
				if (Z.length) {
					if (typeof Z.data("thumb") !== "undefined") {
						ac = Z.data("thumb")
					} else {
						ac = Z.attr("src")
					}
					ai = H(Z.attr("title"), "");
					Z.removeAttr("title")
				}
				if ("image" === this._options.tooltip) {
					if (0 === ag.find(">img.tt-img").length) {
						ag.append(B('<img alt=""/>').addClass("tt-img").attr("src", ac))
					}
				}
				var af = ag.data("link");
				if (typeof af !== "undefined" && "" !== B.trim(af)) {
					var ae = B("<a></a>").addClass("br-main-link").attr("href", af),
						ad = ag.data("target");
					if (typeof ad !== "undefined") {
						ae.attr("target", ad)
					}
					if (this._options.pauseOnInteraction) {
						ae.click(B.proxy(this.pause, this))
					}
					this._$screen.find(">.br-links").append(ae);
					ag.data("linkEl", ae)
				}
				this.setShorthandData(ag, "transition", ["effect", "duration", "easing", "delay"]);
				ag.data({
					caption: ai,
					thumburl: ac,
					ready: false,
					effect: H(ag.data("effect"), this._options.effect),
					duration: M(ag.data("duration"), this._options.duration),
					easing: this.checkEasing(H(ag.data("easing"), this._options.easing)),
					delay: M(ag.data("delay"), this._options.delay)
				});
				this.initLayer(ag)
			}
			var ah = this._$screen.find(">.br-layers");
			this._$layers = ah.children();
			if (f) {
				this._$layers.css("backface-visibility", "visible")
			}
			if (this._options.layerOnHover) {
				ah.css({
					opacity: 0
				});
				this._$rotator.hover(function() {
					ah.animate({
						opacity: 1
					}, {
						duration: 300,
						queue: false
					})
				}, function() {
					ah.animate({
						opacity: 0
					}, {
						duration: 300,
						queue: false
					})
				})
			}
		},
		initCPanel: function() {
			this._$cpanel = B("<div></div>").addClass("br-cpanel");
			this._$rotator.append(this._$cpanel);
			this._cpAlign = H(X[this._options.cpanelAlign], X.bottom);
			this._verticalCPanel = ("left" === this._cpAlign[0] || "right" === this._cpAlign[0]);
			this.initThumbnails();
			this.initButtons();
			var ah = this._$cpanel.children();
			if (ah.length) {
				this._$cpanel.wrap('<div class="br-cpanel-wrapper"></div>');
				this._$cpWrapper = this._$cpanel.parent();
				if (this._verticalCPanel) {
					var ac = 0,
						af = Math.max.apply(null, ah.map(function() {
							return B(this).outerWidth(true)
						}).get()),
						ad = 0,
						Z = 0;
					ah.each(function() {
						B(this).css({
							left: Math.floor((af - B(this).outerWidth(true)) / 2)
						});
						var ai = B(this).outerHeight(true);
						if (B(this).data("front")) {
							B(this).css({
								top: ad
							});
							ad += ai
						} else {
							B(this).css({
								bottom: Z
							});
							Z += ai
						}
						ac += ai
					});
					this._$cpanel.css({
						width: af,
						height: ac
					});
					if ("top" === this._cpAlign[1]) {
						this._$cpWrapper.css({
							top: 0
						})
					} else {
						if ("bottom" === this._cpAlign[1]) {
							this._$cpWrapper.css({
								bottom: 0
							})
						} else {
							this._$cpWrapper.css({
								top: "50%"
							});
							this._$cpanel.css({
								top: -this._$cpanel.outerHeight(true) / 2
							})
						}
					}
					if (this._options.cpanelOutside) {
						this.setOutsideVerticalCPanel()
					} else {
						this.setInsideCPanel()
					}
					if (false !== this._options.thumbnails) {
						this._$cpanel.data({
							margin: this._$cpanel.outerHeight(true) - this._$cpanel.height(),
							buttonsSize: this._$cpanel.height() - ah.filter(".br-thumbnails").height()
						});
						if (this._options.responsive) {
							this._$rotator.bind(b, B.proxy(this.resizeVerticalCPanel, this));
							this.initVerticalScroll()
						} else {
							if (this._$cpanel.outerHeight(true) > this._stageHeight) {
								this.resizeVerticalCPanel();
								this.initVerticalScroll()
							}
						}
					}
				} else {
					var ab = 0,
						ag = Math.max.apply(null, ah.map(function() {
							return B(this).outerHeight(true)
						}).get()),
						aa = 0,
						ae = 0;
					ah.each(function() {
						B(this).css({
							top: Math.floor((ag - B(this).outerHeight(true)) / 2)
						});
						var ai = B(this).outerWidth(true);
						if (B(this).data("front")) {
							B(this).css({
								left: aa
							});
							aa += ai
						} else {
							B(this).css({
								right: ae
							});
							ae += ai
						}
						ab += ai
					});
					this._$cpanel.css({
						width: ab,
						height: ag
					});
					if ("left" === this._cpAlign[1]) {
						this._$cpWrapper.css({
							left: 0
						})
					} else {
						if ("right" === this._cpAlign[1]) {
							this._$cpWrapper.css({
								right: 0
							})
						} else {
							this._$cpWrapper.css({
								left: "50%"
							});
							this._$cpanel.css({
								left: -this._$cpanel.outerWidth(true) / 2
							})
						}
					}
					if (this._options.cpanelOutside) {
						this.setOutsideHorizontalCPanel()
					} else {
						this.setInsideCPanel()
					}
					if (false !== this._options.thumbnails) {
						this._$cpanel.data({
							margin: this._$cpanel.outerWidth(true) - this._$cpanel.width(),
							buttonsSize: this._$cpanel.width() - ah.filter(".br-thumbnails").width()
						});
						if (this._options.responsive) {
							this._$rotator.bind(b, B.proxy(this.resizeHorizontalCPanel, this));
							this.initHorizontalScroll()
						} else {
							if (this._$cpanel.outerWidth(true) > this._stageWidth) {
								this.resizeHorizontalCPanel();
								this.initHorizontalScroll()
							}
						}
					}
				}
				this._$cpanel.css({
					visibility: "visible"
				})
			} else {
				this._$cpanel.remove()
			}
		},
		setInsideCPanel: function() {
			this._$cpWrapper.css(this._cpAlign[0], 0);
			if (this._options.cpanelOnHover) {
				this._$cpanel.css({
					opacity: 0
				});
				this._$rotator.hover(B.proxy(function() {
					this._$cpanel.animate({
						opacity: 1
					}, {
						duration: Q,
						queue: false
					})
				}, this), B.proxy(function(Z) {
					if (!this.onTooltip(Z)) {
						this._$cpanel.animate({
							opacity: 0
						}, {
							duration: Q,
							queue: false
						})
					}
				}, this))
			}
		},
		setOutsideHorizontalCPanel: function() {
			this._$cpWrapper.wrap('<div class="br-ext-cp"></div>');
			this._$extPanel = this._$cpWrapper.parent().prepend('<div class="br-ext-bg"></div>');
			var aa = this._$cpWrapper.height(),
				ab, Z;
			if ("top" === this._cpAlign[0]) {
				ab = "marginTop";
				Z = "top"
			} else {
				ab = "marginBottom";
				Z = "bottom"
			}
			this._$rotator.css(ab, aa).css({
				overflow: "visible"
			});
			this._$extPanel.css({
				left: 0,
				width: "100%",
				height: aa
			}).css(Z, -aa);
			this.createBorderWrapper()
		},
		setOutsideVerticalCPanel: function() {
			this._$cpWrapper.wrap('<div class="br-ext-cp"></div>');
			this._$extPanel = this._$cpWrapper.parent().prepend('<div class="br-ext-bg"></div>');
			var aa = this._$cpWrapper.width(),
				ab, Z;
			if ("left" === this._cpAlign[0]) {
				ab = "marginLeft";
				Z = "left"
			} else {
				ab = "marginRight";
				Z = "right"
			}
			this._$rotator.css(ab, aa).css({
				overflow: "visible"
			});
			this._$extPanel.css({
				top: 0,
				width: aa,
				height: "100%"
			}).css(Z, -aa);
			this.createBorderWrapper()
		},
		setBackgroundColor: function(Z, aa) {
			if (typeof aa !== "undefined") {
				if ("" === B.trim(aa)) {
					aa = "transparent"
				}
				Z.css({
					backgroundColor: aa
				})
			}
		},
		initButtons: function() {
			var aa = {
				width: this._options.buttonWidth,
				height: this._options.buttonHeight,
				margin: this._options.buttonMargin
			},
				ab, Z, ac;
			if (this._options.playButton && 1 < this._numItems) {
				ab = B("<div><div></div></div>");
				ab.addClass("br-play-button").css(aa).toggleClass("br-pause", this._rotate).click(B.proxy(this.togglePlay, this)).mousedown(F);
				if (!f) {
					ab.addClass("br-all-color-transition")
				}
				this._$cpanel.prepend(ab)
			}
			if ((true === this._options.navButtons || "small" === this._options.navButtons) && 1 < this._numItems) {
				Z = B("<div><div></div></div>").addClass("br-prev-button").css(aa).toggleClass("br-up", this._verticalCPanel).click(B.proxy(this.prevSlide, this)).mousedown(F);
				ac = B("<div><div></div></div>").addClass("br-next-button").css(aa).toggleClass("br-down", this._verticalCPanel).click(B.proxy(this.nextSlide, this)).mousedown(F);
				if (!f) {
					Z.add(ac).addClass("br-all-color-transition")
				}
				if (typeof ab !== "undefined") {
					ab.before(ac).after(Z)
				} else {
					Z.data("front", true);
					this._$cpanel.append(Z).prepend(ac)
				}
			}
		},
		initThumbnails: function() {
			var ac = (1 < this._numItems ? this._options.thumbnails : false);
			if (false !== ac && "none" !== ac) {
				this._$thumbPanel = B("<div></div>").addClass("br-thumbnails");
				this._$thumbList = B("<ul></ul>");
				this._$thumbPanel.append(this._$thumbList);
				this._$cpanel.append(this._$thumbPanel);
				for (var aa = 0; aa < this._numItems; aa++) {
					if ("number" === ac) {
						this._$thumbList.append("<li>" + (aa + 1) + "</li>")
					} else {
						if ("text" === ac) {
							this._$thumbList.append("<li>" + this._$items.eq(aa).data("caption") + "</li>")
						} else {
							if ("image" === ac) {
								var ab = B("<li></li>").addClass("br-thumb-img"),
									Z = B('<img alt=""/>').css({
										opacity: 0
									});
								if (!t) {
									ab.append("<div></div>");
									if (!f) {
										ab.find(">div").addClass("br-opacity-transition")
									}
								}
								ab.prepend(Z).appendTo(this._$thumbList);
								Z.one("load", B.proxy(function(ad) {
									this.fillContent(B(ad.currentTarget), this._options.thumbWidth, this._options.thumbHeight);
									B(ad.currentTarget).animate({
										opacity: 1
									}, Q)
								}, this)).attr("src", this._$items.eq(aa).data("thumburl"));
								if (Z[0].complete || "complete" === Z[0].readyState) {
									Z.trigger("load")
								}
							} else {
								this._$thumbList.append(B("<li></li>").toggleClass("br-bullet", "bullet" === ac))
							}
						}
					}
				}
				this._$thumbs = this._$thumbList.children("li");
				if (!f) {
					this._$thumbs.addClass("bullet" === ac ? "br-all-transition" : "br-all-color-transition")
				}
				if ("bullet" !== ac) {
					this._$thumbs.css({
						width: this._options.thumbWidth,
						height: this._options.thumbHeight,
						margin: this._options.thumbMargin,
						lineHeight: this._options.thumbHeight + "px"
					})
				}
				if (this._options.selectOnHover) {
					this._$thumbs.mouseenter(B.proxy(this.selectSlide, this))
				} else {
					this._$thumbs.click(B.proxy(this.selectSlide, this)).mousedown(F)
				}
				if (this._verticalCPanel) {
					this._$thumbList.css({
						width: this._$thumbs.outerWidth(true),
						height: this._numItems * this._$thumbs.outerHeight(true)
					})
				} else {
					this._$thumbList.css({
						width: this._numItems * this._$thumbs.outerWidth(true),
						height: this._$thumbs.outerHeight(true)
					})
				}
				this.initTooltip()
			} else {
				this._options.thumbnails = false
			}
		},
		initLayer: function(aa) {
			var Z = aa.children(":not(.tt-html, img.tt-img, img.br-main-img, a.br-img-link)").addClass("br-layer");
			aa.data("layers", Z);
			this._$screen.find(">.br-layers").append(Z);
			Z.each(B.proxy(function(af, ae) {
				var ad = B(ae),
					ab = "marginTop",
					ac = "marginLeft";
				if ("auto" === ad[0].style.width && "auto" === ad[0].style.height) {
					ad.css("white-space", "nowrap")
				}
				if (!isNaN(parseInt(ad[0].style.top, 0))) {
					if (!G(ad[0].style.top)) {
						ad.css({
							top: (c(ad.css("top"), 0) / this._stageHeight * 100) + "%"
						})
					}
					ad.css({
						bottom: "auto"
					})
				} else {
					if (!isNaN(parseInt(ad[0].style.bottom, 0))) {
						if (!G(ad[0].style.bottom)) {
							ad.css({
								bottom: (c(ad.css("bottom"), 0) / this._stageHeight * 100) + "%"
							})
						}
						ad.css({
							top: "auto"
						});
						ab = "marginBottom"
					}
				}
				if (!isNaN(parseInt(ad[0].style.left, 0))) {
					if (!G(ad[0].style.left)) {
						ad.css({
							left: (c(ad.css("left"), 0) / this._stageWidth * 100) + "%"
						})
					}
					ad.css({
						right: "auto"
					})
				} else {
					if (!isNaN(parseInt(ad[0].style.right, 0))) {
						if (!G(ad[0].style.right)) {
							ad.css({
								right: (c(ad.css("right"), 0) / this._stageWidth * 100) + "%"
							})
						}
						ad.css({
							left: "auto"
						});
						ac = "marginRight"
					}
				}
				this.setShorthandData(ad, "transition", ["effect", "duration", "easing", "delay"]);
				this.setShorthandData(ad, "transitionOut", ["effectOut", "durationOut", "easingOut", "delayOut"]);
				ad.data({
					width: "auto" === ad[0].style.width ? "auto" : ad.width(),
					height: "auto" === ad[0].style.height ? "auto" : ad.height(),
					opacity: A(ad.css("opacity"), 1),
					padTop: c(ad.css("paddingTop"), 0),
					padBottom: c(ad.css("paddingBottom"), 0),
					padLeft: c(ad.css("paddingLeft"), 0),
					padRight: c(ad.css("paddingRight"), 0),
					borderTop: c(ad.css("borderTopWidth"), 0),
					borderBottom: c(ad.css("borderBottomWidth"), 0),
					borderLeft: c(ad.css("borderLeftWidth"), 0),
					borderRight: c(ad.css("borderRightWidth"), 0),
					fontSize: parseInt(ad.css("fontSize"), 0),
					lineHeight: parseInt(ad.css("lineHeight"), 0),
					verticalMargin: ab,
					horizontalMargin: ac,
					effect: this.getEffect(H(ad.data("effect"), this._options.layerEffect)),
					duration: M(ad.data("duration"), this._options.layerDuration),
					easing: this.checkEasing(H(ad.data("easing"), this._options.layerEasing)),
					delay: K(ad.data("delay"), this._options.layerDelay),
					effectOut: this.getEffect(H(ad.data("effectOut"), this._options.layerEffectOut)),
					durationOut: M(ad.data("durationOut"), this._options.layerDurationOut),
					easingOut: this.checkEasing(H(ad.data("easingOut"), this._options.layerEasingOut)),
					delayOut: K(ad.data("delayOut"), this._options.layerDelayOut)
				})
			}, this))
		},
		setShorthandData: function(ad, ab, ae) {
			var aa = ad.data(ab);
			if (typeof aa !== "undefined") {
				var Z = aa.split(" ", ae.length);
				for (var ac = 0; ac < ae.length; ac++) {
					if (typeof Z[ac] !== "undefined") {
						ad.data(ae[ac], Z[ac])
					}
				}
				ad.removeData(ab)
			}
		},
		initEffects: function() {
			this._$rotator.one("createEffect.vCover", B.proxy(function() {
				this._effects.vCover = new W(this, 1, 0)
			}, this)).one("createEffect.hCover", B.proxy(function() {
				this._effects.hCover = new T(this, 1, 0)
			}, this)).one("createEffect.blocks", B.proxy(function() {
				this._effects.blocks = new u(this, this._options.blockRows, this._options.blockCols, this._options.blockDelay)
			}, this)).one("createEffect.vSlices", B.proxy(function() {
				this._effects.vSlices = new W(this, this._options.verticalSlices, this._options.verticalSliceDelay)
			}, this)).one("createEffect.hSlices", B.proxy(function() {
				this._effects.hSlices = new T(this, this._options.horizontalSlices, this._options.horizontalSliceDelay)
			}, this)).one("createEffect.vSlide", B.proxy(function() {
				this._effects.vSlide = new N(this, "vertical")
			}, this)).one("createEffect.hSlide", B.proxy(function() {
				this._effects.hSlide = new N(this, "horizontal")
			}, this));
			var ab = this._$items.map(function() {
				return B(this).data("effect")
			}).get();
			ab[ab.length] = this._options.effect;
			for (var Z = 0; Z < ab.length; Z++) {
				var aa = ab[Z];
				if ("random" === aa) {
					this._effectArray = [];
					B.each(r, B.proxy(function(ac, ad) {
						this._effectArray[this._effectArray.length] = ac
					}, this));
					this._$rotator.trigger("createEffect");
					break
				}
				if (typeof r[aa] !== "undefined") {
					this._$rotator.trigger("createEffect." + r[aa][0])
				}
			}
			this._$rotator.unbind("createEffect")
		},
		initTooltip: function() {
			if (false !== this._options.tooltip && "none" !== this._options.tooltip) {
				this._$tooltip = B("<div></div>").addClass("br-tt br-tt-" + this._cpAlign[0]).append('<div class="br-tt-tip"></div><div class="br-tt-content"></div>');
				var Z = this._$tooltip.find(">.br-tt-content").css({
					width: this._options.tooltipWidth,
					height: this._options.tooltipHeight
				});
				B("body").prepend(this._$tooltip);
				if ("image" === this._options.tooltip) {
					this._$items.each(B.proxy(function(ae, ac) {
						var ab = B(ac).find(">img.tt-img"),
							aa = ab.clone();
						Z.append(aa);
						var ad = this._$thumbs.eq(ae);
						ad.hover(B.proxy(function() {
							this._$tooltip.stop(true, true).find("img").hide().eq(ae).show();
							this.displayTooltip(ad)
						}, this), B.proxy(this.hideTooltip, this));
						ab.one("load", B.proxy(function() {
							this.fillContent(ab, this._options.tooltipWidth, this._options.tooltipHeight);
							aa.css({
								visibility: "visible",
								top: ab.css("top"),
								left: ab.css("left"),
								width: ab.width(),
								height: ab.height()
							});
							ab.remove()
						}, this)).attr("src", ab.attr("src"));
						if (ab[0].complete || "complete" === ab[0].readyState) {
							ab.trigger("load")
						}
					}, this))
				} else {
					this._$items.each(B.proxy(function(ag, ae) {
						var ab, ac = B(ae).find(">.tt-html");
						if (ac.length && "" !== ac.html()) {
							ab = ac.html()
						} else {
							ab = B(ae).data("caption")
						}
						if (typeof ab !== "undefined" && "" !== ab) {
							var af = this._$thumbs.eq(ag);
							if ("auto" === this._options.tooltipWidth && "auto" === this._options.tooltipHeight) {
								Z.html(ab);
								var ad = Z.width() + 1,
									aa = Z.height() + 1;
								Z.html("");
								af.bind(d, B.proxy(function() {
									Z.css({
										width: ad,
										height: aa
									})
								}, this))
							}
							af.hover(B.proxy(function() {
								this._$tooltip.stop(true, true);
								af.trigger(d);
								Z.html(ab);
								this.displayTooltip(af)
							}, this), B.proxy(this.hideTooltip, this))
						}
					}, this))
				}
				if (s) {
					this._$tooltip.mouseleave(B.proxy(function(aa) {
						if (document.elementFromPoint && !B(document.elementFromPoint(aa.clientX, aa.clientY)).closest(".banner-rotator").is(this._$rotator)) {
							this._$rotator.trigger("mouseleave")
						}
					}, this))
				}
			}
		},
		displayTooltip: function(ac) {
			var Z = this._options.cpanelOutside ? this._$extPanel : ac,
				ab, aa;
			if (this._verticalCPanel) {
				aa = Z.offset().left;
				if ("left" === this._cpAlign[0]) {
					aa += Z.outerWidth()
				} else {
					aa -= this._$tooltip.outerWidth(true)
				}
				ab = ac.offset().top - (this._$tooltip.outerHeight(true) - ac.outerHeight()) / 2
			} else {
				ab = Z.offset().top;
				if ("top" === this._cpAlign[0]) {
					ab += Z.outerHeight()
				} else {
					ab -= this._$tooltip.outerHeight(true)
				}
				aa = ac.offset().left - (this._$tooltip.outerWidth(true) - ac.outerWidth()) / 2
			}
			this._tooltipId = setTimeout(B.proxy(function() {
				this._$tooltip.css({
					opacity: 0,
					top: ab,
					left: aa
				}).show().animate({
					opacity: 1
				}, Q)
			}, this), this._options.tooltipDelay)
		},
		hideTooltip: function() {
			clearTimeout(this._tooltipId);
			this._$tooltip.stop(true).animate({
				opacity: 0
			}, 400, function() {
				B(this).hide()
			})
		},
		selectSlide: function(aa) {
			if (this._options.pauseOnInteraction) {
				this.pause()
			}
			if (!this._inProgress) {
				var Z = B(aa.currentTarget).index();
				if (Z != this._currIndex) {
					if (this._options.layerOutSync) {
						this.loadDeferred(B.proxy(function() {
							this.select_slide(Z)
						}, this))
					} else {
						this.select_slide(Z)
					}
				}
			}
		},
		select_slide: function(Z) {
			this._backward = Z < this._currIndex;
			this._currIndex = Z;
			this.loadSlide()
		},
		prevSlide: function() {
			if (this._options.pauseOnInteraction) {
				this.pause()
			}
			if (!this._inProgress) {
				if (this._options.layerOutSync) {
					this.loadDeferred(B.proxy(function() {
						this.prev_slide()
					}, this))
				} else {
					this.prev_slide()
				}
			}
		},
		prev_slide: function() {
			this._$rotator.trigger(R);
			this._options.onPrev.call(this);
			this._backward = true;
			this._currIndex = (this._currIndex > 0) ? (this._currIndex - 1) : (this._numItems - 1);
			this.loadSlide()
		},
		nextSlide: function() {
			if (this._options.pauseOnInteraction) {
				this.pause()
			}
			if (!this._inProgress) {
				if (this._options.layerOutSync) {
					this.loadDeferred(B.proxy(function() {
						this.next_slide()
					}, this))
				} else {
					this.next_slide()
				}
			}
		},
		next_slide: function() {
			this._$rotator.trigger(o);
			this._options.onNext.call(this);
			this._backward = false;
			this._currIndex = (this._currIndex < this._numItems - 1) ? (this._currIndex + 1) : 0;
			this.loadSlide()
		},
		rotateSlide: function() {
			if (!this._inProgress) {
				if (this._options.layerOutSync) {
					this.loadDeferred(B.proxy(function() {
						this.rotate_slide()
					}, this))
				} else {
					this.rotate_slide()
				}
			}
		},
		rotate_slide: function() {
			this._backward = false;
			this._currIndex = (this._currIndex < this._numItems - 1) ? (this._currIndex + 1) : 0;
			this.loadSlide()
		},
		togglePlay: function() {
			if (this._rotate) {
				this.pause()
			} else {
				this.play()
			}
		},
		play: function() {
			if (!this._rotate) {
				this._rotate = true;
				this._$cpanel.find(">.br-play-button").addClass("br-pause");
				if (!this._inProgress) {
					this.resumeTimer()
				}
				this._$rotator.trigger(P);
				this._options.onPlay.call(this)
			}
		},
		pause: function() {
			if (this._rotate) {
				this._rotate = false;
				this._$cpanel.find(">.br-play-button").removeClass("br-pause");
				if (!this._inProgress) {
					this.pauseTimer()
				}
				this._$rotator.trigger(w);
				this._options.onPause.call(this)
			}
		},
		displayLayers: function() {
			this.stopLayers();
			this._layerIds = [];
			this._$currItem.data("layers").each(B.proxy(function(aa, Z) {
				this._layerIds.push(setTimeout(B.proxy(function() {
					this.animateLayer(B(Z))
				}, this), B(Z).data("delay")))
			}, this))
		},
		animateLayer: function(Z) {
			Z.stopTransition(true, true);
			var aa = Z.data(),
				ad = {},
				ac = {};
			Z.css({
				opacity: aa.opacity,
				margin: 0,
				transform: "none"
			}).show();
			switch (aa.effect) {
			case "fade":
				ad = {
					opacity: 0
				};
				ac = {
					opacity: aa.opacity
				};
				break;
			case "moveDown":
				var ab = this.getVerticalMoveProp(Z, true);
				ad = ab.from;
				ac = ab.to;
				break;
			case "moveUp":
				var ab = this.getVerticalMoveProp(Z, false);
				ad = ab.from;
				ac = ab.to;
				break;
			case "moveRight":
				var ab = this.getHorizontalMoveProp(Z, true);
				ad = ab.from;
				ac = ab.to;
				break;
			case "moveLeft":
				var ab = this.getHorizontalMoveProp(Z, false);
				ad = ab.from;
				ac = ab.to;
				break;
			case "zoomIn":
				ad = {
					transform: "scale(0)",
					opacity: 0
				};
				ac = {
					transform: "scale(1)",
					opacity: aa.opacity
				};
				break;
			case "zoomOut":
				ad = {
					transform: "scale(2)",
					opacity: 0
				};
				ac = {
					transform: "scale(1)",
					opacity: aa.opacity
				};
				break;
			case "flipDown":
				ad = {
					transform: "perspective(400px) rotateX(90deg)"
				};
				ac = {
					transform: "perspective(400px) rotateX(0deg)"
				};
				break;
			case "flipUp":
				ad = {
					transform: "perspective(400px) rotateX(-90deg)"
				};
				ac = {
					transform: "perspective(400px) rotateX(0deg)"
				};
				break;
			case "flipRight":
				ad = {
					transform: "perspective(400px) rotateY(-90deg)"
				};
				ac = {
					transform: "perspective(400px) rotateY(0deg)"
				};
				break;
			case "flipLeft":
				ad = {
					transform: "perspective(400px) rotateY(90deg)"
				};
				ac = {
					transform: "perspective(400px) rotateY(0deg)"
				};
				break;
			case "slideDown":
			case "slideUp":
			case "slideRight":
			case "slideLeft":
				this.slideEffect(Z, {
					effect: aa.effect,
					duration: aa.duration,
					easing: aa.easing,
					effectOut: false
				});
				this.deferLayerOut(Z);
				return;
			default:
				this.deferLayerOut(Z);
				return
			}
			Z.css(ad).transition(ac, aa.duration, aa.easing);
			this.deferLayerOut(Z)
		},
		deferLayerOut: function(Z) {
			var aa = Z.data("delayOut");
			if (typeof aa !== "undefined" && 0 < aa) {
				Z.promise().done(B.proxy(function() {
					this._layerIds.push(setTimeout(B.proxy(function() {
						this.animateLayerOut(Z)
					}, this), aa))
				}, this))
			}
		},
		animateLayerOut: function(Z) {
			Z.stopTransition(true, true);
			var aa = Z.data(),
				ad = {},
				ac = {};
			switch (aa.effectOut) {
			case "fade":
				ad = {
					opacity: aa.opacity
				};
				ac = {
					opacity: 0
				};
				break;
			case "moveDown":
				var ab = this.getVerticalMoveProp(Z, false);
				ad = ab.to;
				ac = ab.from;
				break;
			case "moveUp":
				var ab = this.getVerticalMoveProp(Z, true);
				ad = ab.to;
				ac = ab.from;
				break;
			case "moveRight":
				var ab = this.getHorizontalMoveProp(Z, false);
				ad = ab.to;
				ac = ab.from;
				break;
			case "moveLeft":
				var ab = this.getHorizontalMoveProp(Z, true);
				ad = ab.to;
				ac = ab.from;
				break;
			case "zoomIn":
				ad = {
					transform: "scale(1)",
					opacity: aa.opacity
				};
				ac = {
					transform: "scale(2)",
					opacity: 0
				};
				break;
			case "zoomOut":
				ad = {
					transform: "scale(1)",
					opacity: aa.opacity
				};
				ac = {
					transform: "scale(0)",
					opacity: 0
				};
				break;
			case "flipDown":
				ad = {
					transform: "perspective(400px) rotateX(0deg)"
				};
				ac = {
					transform: "perspective(400px) rotateX(-90deg)"
				};
				break;
			case "flipUp":
				ad = {
					transform: "perspective(400px) rotateX(0deg)"
				};
				ac = {
					transform: "perspective(400px) rotateX(90deg)"
				};
				break;
			case "flipRight":
				ad = {
					transform: "perspective(400px) rotateY(0deg)"
				};
				ac = {
					transform: "perspective(400px) rotateY(90deg)"
				};
				break;
			case "flipLeft":
				ad = {
					transform: "perspective(400px) rotateY(0deg)"
				};
				ac = {
					transform: "perspective(400px) rotateY(-90deg)"
				};
				break;
			case "slideDown":
			case "slideUp":
			case "slideRight":
			case "slideLeft":
				this.slideEffect(Z, {
					effect: aa.effectOut,
					duration: aa.durationOut,
					easing: aa.easingOut,
					effectOut: true,
					complete: function() {
						B(this).hide()
					}
				});
				Z.data({
					promise: Z.promise()
				});
				return;
			default:
				Z.hide();
				return
			}
			Z.css(ad).transition(ac, aa.durationOut, aa.easingOut, function() {
				B(this).hide()
			}).data({
				promise: Z.promise()
			})
		},
		slideEffect: function(ab, ae) {
			var ac = ae.effect,
				ag = {},
				af = {},
				ad = this,
				Z, aa;
			if ("slideLeft" === ac || "slideRight" === ac) {
				Z = "left";
				aa = ab.outerWidth(true)
			} else {
				Z = "top";
				aa = ab.outerHeight(true)
			}
			if (ae.effectOut) {
				ag[Z] = 0;
				af[Z] = ("slideLeft" === ac || "slideUp" === ac) ? -aa : aa
			} else {
				ag[Z] = ("slideRight" === ac || "slideDown" === ac) ? -aa : aa;
				af[Z] = 0
			}
			this.createWrapper(ab);
			ab.css(ag).transition(af, ae.duration, ae.easing, function() {
				ad.removeWrapper(ab);
				if (B.isFunction(ae.complete)) {
					ae.complete.call(this)
				}
			})
		},
		createWrapper: function(aa) {
			this.saveStyle(aa);
			var Z = {
				width: aa.width(),
				height: aa.height()
			},
				ab = B("<div></div>");
			ab.addClass("br-effect-wrapper").css({
				position: aa.css("position"),
				"float": aa.css("float"),
				width: aa.outerWidth(true),
				height: aa.outerHeight(true),
				zIndex: aa.css("zIndex"),
				top: aa[0].style.top,
				left: aa[0].style.left,
				bottom: aa[0].style.bottom,
				right: aa[0].style.right
			});
			aa.wrap(ab).css({
				display: "block",
				position: "relative",
				top: 0,
				left: 0,
				bottom: "auto",
				right: "auto"
			}).css(Z)
		},
		removeWrapper: function(Z) {
			this.restoreStyle(Z);
			if (Z.parent().is(".br-effect-wrapper")) {
				Z.unwrap()
			}
		},
		saveStyle: function(aa) {
			var ac = {},
				ab = ["display", "position", "top", "left", "bottom", "right", "width", "height"];
			for (var Z = 0; Z < ab.length; Z++) {
				ac[ab[Z]] = aa[0].style[ab[Z]]
			}
			aa.data("effectdata", ac)
		},
		restoreStyle: function(Z) {
			B.each(Z.data("effectdata"), function(aa, ab) {
				if (typeof ab === "undefined") {
					ab = ""
				}
				Z.css(aa, ab)
			})
		},
		stopLayers: function() {
			while (this._layerIds.length) {
				clearTimeout(this._layerIds.pop())
			}
			this._$layers.stopTransition(true, true)
		},
		clearLayers: function(aa) {
			this.stopLayers();
			var Z = this._$layers.filter(":visible");
			if (aa) {
				Z.each(B.proxy(function(ac, ab) {
					this.animateLayerOut(B(ab))
				}, this))
			} else {
				Z.hide()
			}
		},
		loadDeferred: function(ab) {
			if (typeof this._promise === "undefined" || "pending" !== this._promise.state()) {
				this._$items.find(">img.br-main-img").unbind("load.display");
				this.resetTimer();
				while (this._layerIds.length) {
					clearTimeout(this._layerIds.pop())
				}
				var Z = this._$layers.filter(":visible");
				if (Z.length) {
					var aa = [];
					Z.each(B.proxy(function(ae, ad) {
						var ac = B(ad);
						if (typeof ac.data("promise") === "undefined" || "pending" !== ac.data("promise").state()) {
							this.animateLayerOut(ac)
						}
						aa[ae] = ac.data("promise")
					}, this));
					this._promise = B.when.apply(null, aa).done(function() {
						ab.call(this)
					});
					Z.removeData("promise")
				} else {
					ab.call(this)
				}
			}
		},
		loadSlide: function() {
			this._$items.find(">img.br-main-img").unbind("load.display");
			this._$screen.find(">.br-links>a.br-main-link").hide();
			this.resetTimer();
			this.clearLayers(true);
			B.each(this._effects, function(ac, ad) {
				ad.clear()
			});
			if (0 === this._currIndex) {
				this._$rotator.trigger(L);
				this._options.onFirstSlide.call(this)
			}
			if ((this._numItems - 1) === this._currIndex) {
				this._$rotator.trigger(z);
				this._options.onLastSlide.call(this);
				if (this._options.playOnce) {
					this.pause()
				}
			}
			this._$rotator.trigger(k);
			this._options.onSlideChange.call(this);
			if (false !== this._options.thumbnails) {
				this._$thumbs.removeClass("br-curr").eq(this._currIndex).addClass("br-curr");
				this._$rotator.trigger(E)
			}
			var Z = this._$items.eq(this._currIndex);
			if (Z.data("ready")) {
				this.displayContent(Z)
			} else {
				this._$preloader.show();
				var aa = Z.find(">img.br-main-img");
				aa.one("load.display", B.proxy(function() {
					if (!Z.data("ready")) {
						this.processImage(Z)
					}
					this.displayContent(Z)
				}, this));
				var ab = ((typeof aa.attr("src") === "undefined" || "" === aa.attr("src")) ? Z.data("imgurl") : aa.attr("src"));
				aa.attr("src", ab);
				if (aa[0].complete || "complete" === aa[0].readyState) {
					aa.trigger("load")
				}
			}
		},
		displayContent: function(Z) {
			this._$preloader.hide();
			this._inProgress = true;
			this._$prevItem = this._$currItem;
			this._$currItem = Z;
			var ad = this._$currItem.data();
			if (typeof ad.linkEl !== "undefined") {
				ad.linkEl.show()
			}
			if (!this._options.layerSync) {
				this.displayLayers()
			}
			if (typeof this._$prevItem === "undefined" || this._$prevItem.index() == this._$currItem.index()) {
				this.displayCurrent();
				return
			}
			var ac = ad.effect;
			if ("random" === ac) {
				ac = this._effectArray[Math.floor(Math.random() * this._effectArray.length)]
			}
			if (typeof r[ac] !== "undefined") {
				var aa = r[ac][0];
				var ab = r[ac][1];
				this._effects[aa][ab](this._$currItem.find(">img.br-main-img"), ac, ad.duration, ad.easing)
			} else {
				this.displayCurrent()
			}
		},
		displayCurrent: function() {
			this._$rotator.trigger(U);
			this._options.onSlideComplete.call(this);
			if (this._options.layerSync) {
				this.displayLayers()
			}
			this._$items.css({
				visibility: "hidden"
			});
			this._$currItem.css({
				visibility: "visible"
			});
			this.startTimer();
			this._inProgress = false
		},
		loadImage: function(aa) {
			var Z = B.Deferred(),
				ab = aa.find(">img.br-main-img");
			ab.one("load", B.proxy(function() {
				if (!aa.data("ready")) {
					this.processImage(aa)
				}
				Z.resolve()
			}, this)).error(function() {
				Z.reject()
			});
			var ac = ((typeof ab.attr("src") === "undefined" || "" === ab.attr("src")) ? aa.data("imgurl") : ab.attr("src"));
			ab.attr("src", ac);
			if (ab[0].complete || "complete" === ab[0].readyState) {
				ab.trigger("load")
			}
			return Z
		},
		loadNextImage: function(Z, aa) {
			if (Z.length) {
				B.when(this.loadImage(B(Z.pop()))).always(B.proxy(function() {
					this.loadNextImage(Z, aa)
				}, this))
			} else {
				if (B.isFunction(aa)) {
					aa.call(this)
				}
			}
		},
		loadAllImages: function() {
			var Z = 0;
			var aa = setInterval(B.proxy(function() {
				if (Z < this._numItems) {
					var ab = this._$items.eq(Z++),
						ac = ab.find(">img.br-main-img");
					ac.one("load", B.proxy(function() {
						if (!ab.data("ready")) {
							this.processImage(ab)
						}
					}, this));
					var ad = ((typeof ac.attr("src") === "undefined" || "" === ac.attr("src")) ? ab.data("imgurl") : ac.attr("src"));
					ac.attr("src", ad);
					if (ac[0].complete || "complete" === ac[0].readyState) {
						ac.trigger("load")
					}
				} else {
					clearInterval(aa)
				}
			}, this), 100)
		},
		processImage: function(ag) {
			var Z = ag.find(">img.br-main-img"),
				ac = H(ag.data("imagePosition"), this._options.imagePosition),
				ad = (ac + "").split(" ");
			if (2 === ad.length) {
				if (!isNaN(parseInt(ad[0], 0))) {
					Z.css({
						left: ad[0]
					})
				}
				if (!isNaN(parseInt(ad[1], 0))) {
					Z.css({
						top: ad[1]
					})
				}
			} else {
				switch (ac) {
				case "fill":
					this.fillContent(Z, this._stageWidth, this._stageHeight);
					break;
				case "fit":
					this.fitContent(Z, this._stageWidth, this._stageHeight);
					break;
				case "center":
					this.centerContent(Z, this._stageWidth, this._stageHeight);
					break;
				case "stretch":
					this.stretchContent(Z, this._stageWidth, this._stageHeight);
					break
				}
			}            
			var ae = this._$stage.width() / this._stageWidth,
				af = parseInt(Z.css("top"), 0),
				ab = parseInt(Z.css("left"), 0),
				aa = Z.width(),
				ah = Z.height();
			Z.data({
				top: af,
				left: ab,
				width: aa,
				height: ah
			}).css({
				top: Math.round(ae * af),
				left: Math.round(ae * ab),
				width: Math.round(ae * aa),
				height: Math.round(ae * ah)
			});
			ag.data("ready", true)
		},
		centerContent: function(Z, aa, ab) {
			Z.css({
				top: (ab - Z.height()) / 2,
				left: (aa - Z.width()) / 2
			})
		},
		fillContent: function(aa, ac, ae) {
			if ("auto" === ac || "auto" === ae) {
				return
			}
			var ab = aa.width(),
				Z = aa.height(),
				ad = Math.max(ae / Z, ac / ab);
			aa.css({
				width: ab * ad,
				height: Z * ad
			});
			this.centerContent(aa, ac, ae)
		},
		fitContent: function(aa, ae, af) {
			var ac = aa.width(),
				Z = aa.height(),
				ad = ae / af,
				ab = ac / Z;
			if (ad > ab) {
				ac *= af / Z;
				Z = af
			} else {
				Z *= ae / ac;
				ac = ae
			}
			aa.css({
				width: ac,
				height: Z
			});
			this.centerContent(aa, ae, af)
		},
		stretchContent: function(Z, aa, ab) {
			Z.css({
				top: 0,
				left: 0,
				width: aa,
				height: ab
			})
		},
		startTimer: function() {
			this._delay = this._$currItem.data("delay");
			this.resumeTimer()
		},
		resumeTimer: function() {
			if (this._rotate && 0 < this._delay) {
				this._start = new Date();
				this._timerId = setTimeout(B.proxy(this.rotateSlide, this), this._delay);
				if (typeof this._timer !== "undefined") {
					this._timer.start(this._delay)
				}
			}
		},
		resetTimer: function() {
			this._delay = 0;
			clearTimeout(this._timerId);
			if (typeof this._timer !== "undefined") {
				this._timer.stop()
			}
		},
		pauseTimer: function() {
			if (typeof this._start !== "undefined") {
				this._delay -= (new Date() - this._start)
			}
			clearTimeout(this._timerId);
			if (typeof this._timer !== "undefined") {
				this._timer.pause()
			}
		},
		initHorizontalScroll: function() {
			this._scrollEasing = ("easeOutCirc" in B.easing) ? "easeOutCirc" : "linear";
			this._$rotator.bind(E, B.proxy(this.updateHorizontalThumbs, this));
			if (!V) {
				this._$thumbPanel.hover(B.proxy(function() {
					this._$rotator.unbind(E)
				}, this), B.proxy(function() {
					this._$rotator.unbind(E).bind(E, B.proxy(this.updateHorizontalThumbs, this))
				}, this)).mousemove(B.proxy(function(aa) {
					var Z = (aa.pageX - this._$thumbPanel.offset().left) / this._$thumbPanel.width();
					this._$thumbList.animate({
						left: Math.round(this._$thumbPanel.data("range") * Z)
					}, {
						duration: Q,
						easing: this._scrollEasing,
						queue: false
					})
				}, this))
			}
		},
		initVerticalScroll: function() {
			this._scrollEasing = ("easeOutCirc" in B.easing) ? "easeOutCirc" : "linear";
			this._$rotator.bind(E, B.proxy(this.updateVerticalThumbs, this));
			if (!V) {
				this._$thumbPanel.hover(B.proxy(function() {
					this._$rotator.unbind(E)
				}, this), B.proxy(function() {
					this._$rotator.unbind(E).bind(E, B.proxy(this.updateVerticalThumbs, this))
				}, this)).mousemove(B.proxy(function(aa) {
					var Z = (aa.pageY - this._$thumbPanel.offset().top) / this._$thumbPanel.height();
					this._$thumbList.animate({
						top: Math.round(this._$thumbPanel.data("range") * Z)
					}, {
						duration: Q,
						easing: this._scrollEasing,
						queue: false
					})
				}, this))
			}
		},
		updateHorizontalThumbs: function() {
			var aa = this._$thumbs.eq(this._currIndex).offset().left,
				Z = this._$thumbPanel.offset().left;
			if (aa < Z) {
				this._$thumbList.animate({
					left: -this._currIndex * this._$thumbs.outerWidth(true)
				}, {
					duration: Q,
					easing: this._scrollEasing,
					queue: false
				})
			} else {
				if (aa + this._$thumbs.width() > Z + this._$thumbPanel.width()) {
					var ab = (((this._numItems - 1) - this._currIndex) * this._$thumbs.outerWidth(true)) + this._$thumbPanel.data("range");
					this._$thumbList.animate({
						left: ab
					}, {
						duration: Q,
						easing: this._scrollEasing,
						queue: false
					})
				}
			}
		},
		updateVerticalThumbs: function() {
			var aa = this._$thumbs.eq(this._currIndex).offset().top,
				Z = this._$thumbPanel.offset().top;
			if (aa < Z) {
				this._$thumbList.animate({
					top: -this._currIndex * this._$thumbs.outerHeight(true)
				}, {
					duration: Q,
					easing: this._scrollEasing,
					queue: false
				})
			} else {
				if (aa + this._$thumbs.height() > Z + this._$thumbPanel.height()) {
					var ab = (((this._numItems - 1) - this._currIndex) * this._$thumbs.outerHeight(true)) + this._$thumbPanel.data("range");
					this._$thumbList.animate({
						top: ab
					}, {
						duration: Q,
						easing: this._scrollEasing,
						queue: false
					})
				}
			}
		},
		resizeHorizontalCPanel: function() {
			this._$thumbPanel.css({
				width: Math.min(this._$screen.width() - this._$cpanel.data("margin") - this._$cpanel.data("buttonsSize"), this._$thumbList.width())
			});
			this._$cpanel.css({
				width: this._$cpanel.data("buttonsSize") + this._$thumbPanel.width()
			});
			this._$cpWrapper.siblings(".br-ext-bg").css({
				width: this._$screen.width()
			});
			this._$thumbList.stop();
			var Z = this._$thumbPanel.width() - this._$thumbList.width();
			if (this._$thumbList.position().left < Z) {
				this._$thumbList.css({
					left: Z
				})
			}
			this._$thumbPanel.data({
				range: Z
			});
			if ("center" === this._cpAlign[1]) {
				this._$cpanel.css({
					left: -this._$cpanel.outerWidth(true) / 2
				})
			}
		},
		resizeVerticalCPanel: function() {
			this._$thumbPanel.css({
				height: Math.min(this._$screen.height() - this._$cpanel.data("margin") - this._$cpanel.data("buttonsSize"), this._$thumbList.height())
			});
			this._$cpanel.css({
				height: this._$cpanel.data("buttonsSize") + this._$thumbPanel.height()
			});
			this._$rotator.find(">.br-ext-cp").css({
				height: this._$screen.height()
			});
			this._$thumbList.stop();
			var Z = this._$thumbPanel.height() - this._$thumbList.height();
			if (this._$thumbList.position().top < Z) {
				this._$thumbList.css({
					top: Z
				})
			}
			this._$thumbPanel.data({
				range: Z
			});
			if ("center" === this._cpAlign[1]) {
				this._$cpanel.css({
					top: -this._$cpanel.outerHeight(true) / 2
				})
			}
		},
		touchStart: function(Z) {
			this._swipeMove = 0;
			if (1 === Z.originalEvent.touches.length) {
				this._swipeStart = new Date();
				this._startX = Z.originalEvent.touches[0].pageX;
				this._startY = Z.originalEvent.touches[0].pageY;
				this._$rotator.bind("touchmove", B.proxy(this.touchMove, this)).one("touchend", B.proxy(this.touchEnd, this))
			}
		},
		touchMove: function(ab) {
			var Z = this._startX - ab.originalEvent.touches[0].pageX;
			var aa = this._startY - ab.originalEvent.touches[0].pageY;
			if ("verticalSlide" === this._options.effect) {
				this._swipeMove = aa;
				this._touchScrolling = Math.abs(this._swipeMove) < Math.abs(Z)
			} else {
				this._swipeMove = Z;
				this._touchScrolling = Math.abs(this._swipeMove) < Math.abs(aa)
			}
			if (!this._touchScrolling) {
				ab.preventDefault()
			}
		},
		touchEnd: function(Z) {
			this._$rotator.unbind("touchmove");
			if (!this._touchScrolling) {
				if (Math.abs(this._swipeMove) > h) {
					if (this._swipeMove > 0) {
						this.nextSlide()
					} else {
						if (this._swipeMove < 0) {
							this.prevSlide()
						}
					}
				}
			}
		},
		mousescroll: function(Z) {
			Z.preventDefault();
			var aa = (typeof Z.originalEvent.wheelDelta === "undefined") ? -Z.originalEvent.detail : Z.originalEvent.wheelDelta;
			if (aa > 0) {
				this.prevSlide()
			} else {
				this.nextSlide()
			}
		},
		keyControl: function(Z) {
			switch (Z.keyCode) {
			case 37:
				this.prevSlide();
				break;
			case 39:
				this.nextSlide();
				break;
			case 80:
				this.togglePlay();
				break
			}
		},
		resize: function() {
			if (B(window).width() !== this._winWidth) {
				this._winWidth = B(window).width();
				this.resetTimer();
				this.clearLayers(false);
				var Z = this._$stage.width() / this._stageWidth;
				this._$stage.css({
					height: Math.round(Z * this._stageHeight)
				});
				this._$screen.css({
					width: this._$stage.width(),
					height: this._$stage.height()
				});
				B.each(this._effects, function(ab, ac) {
					ac.resize(Z)
				});
				this._$items.each(function() {
					if (B(this).data("ready")) {
						var ab = B(this).find(">img.br-main-img");
						ab.css({
							top: Math.round(Z * ab.data("top")),
							left: Math.round(Z * ab.data("left")),
							width: Math.round(Z * ab.data("width")),
							height: Math.round(Z * ab.data("height"))
						})
					}
				});
				this._$layers.each(function() {
					var ac = B(this).data(),
						ab = {};
					if (!isNaN(ac.width)) {
						ab.width = Math.ceil(Z * ac.width) + "px"
					}
					if (!isNaN(ac.height)) {
						ab.height = Math.ceil(Z * ac.height) + "px"
					}
					B(this).css({
						paddingTop: Math.round(Z * ac.padTop) + "px",
						paddingBottom: Math.round(Z * ac.padBottom) + "px",
						paddingLeft: Math.round(Z * ac.padLeft) + "px",
						paddingRight: Math.round(Z * ac.padRight) + "px",
						borderTopWidth: Math.round(Z * ac.borderTop) + "px",
						borderBottomWidth: Math.round(Z * ac.borderBottom) + "px",
						borderLeftWidth: Math.round(Z * ac.borderLeft) + "px",
						borderRightWidth: Math.round(Z * ac.borderRight) + "px",
						fontSize: Math.floor(Z * ac.fontSize) + "px",
						lineHeight: Math.floor(Z * ac.lineHeight) + "px"
					}).css(ab)
				});
				this._$rotator.trigger(b);
				var aa = this._$items.eq(this._currIndex);
				if (aa.data("ready")) {
					this._$items.css({
						visibility: "hidden"
					});
					aa.css({
						visibility: "visible"
					});
					this.displayLayers();
					this.startTimer()
				}
			}
		},
		getEffect: function(Z) {
			if (!this._cssTransform) {
				if (-1 < B.inArray(Z, ["zoomIn", "zoomOut", "flipDown", "flipUp", "flipRight", "flipLeft"])) {
					Z = "fade"
				}
			}
			return Z
		},
		shuffleItems: function(aa) {
			var Z = aa.children("li").toArray();
			p(Z);
			aa.append(Z)
		},
		checkEasing: function(Z) {
			if (this._cssTransition) {
				if (!(Z in O)) {
					Z = "ease"
				}
			} else {
				if (!(Z in B.easing)) {
					Z = "swing"
				}
			}
			return Z
		},
		onTooltip: function(Z) {
			if (s && document.elementFromPoint) {
				return B(document.elementFromPoint(Z.clientX, Z.clientY)).closest(".br-tt").is(this._$tooltip)
			}
			return false
		},
		getVerticalOffset: function(Z, ab) {
			var aa;
			if ("marginBottom" === Z.data("verticalMargin")) {
				ab = !ab;
				aa = Z[0].style.bottom
			} else {
				aa = Z[0].style.top
			}
			aa = Math.ceil(parseFloat(aa) / 100 * this._$screen.height());
			return ab ? -(aa + Z.outerHeight() + 1) : (this._$screen.height() - aa) + 1
		},
		getHorizontalOffset: function(ab, aa) {
			var Z;
			if ("marginRight" === ab.data("horizontalMargin")) {
				aa = !aa;
				Z = ab[0].style.right
			} else {
				Z = ab[0].style.left
			}
			Z = Math.ceil(parseFloat(Z) / 100 * this._$screen.width());
			return aa ? -(Z + ab.outerWidth() + 1) : (this._$screen.width() - Z) + 1
		},
		getVerticalMoveProp: function(aa, Z) {
			var af = {},
				ae = {};
			if (this._cssTransform) {
				var ac = aa.position().top;
				var ad = (Z ? -(ac + aa.outerHeight()) : (this._$screen.outerHeight() - ac));
				af.transform = "translateY(" + ad + "px)";
				ae.transform = "translateY(0)"
			} else {
				var ab = aa.data();
				af[ab.verticalMargin] = this.getVerticalOffset(aa, Z);
				ae[ab.verticalMargin] = 0
			}
			return {
				from: af,
				to: ae
			}
		},
		getHorizontalMoveProp: function(Z, aa) {
			var af = {},
				ae = {};
			if (this._cssTransform) {
				var ac = Z.position().left;
				var ad = (aa ? -(ac + Z.outerWidth()) : (this._$screen.outerWidth() - ac));
				af.transform = "translateX(" + ad + "px)";
				ae.transform = "translateX(0)"
			} else {
				var ab = Z.data();
				af[ab.horizontalMargin] = this.getHorizontalOffset(Z, aa);
				ae[ab.horizontalMargin] = 0
			}
			return {
				from: af,
				to: ae
			}
		}
	};
	function F(Z) {
		Z.preventDefault()
	}
	function c(Z, aa) {
		return parseInt(Z, 0) || aa
	}
	function M(Z, aa) {
		Z = parseInt(Z, 0);
		return (isNaN(Z) || Z <= 0) ? aa : Z
	}
	function K(Z, aa) {
		Z = parseInt(Z, 0);
		return (isNaN(Z) || Z < 0) ? aa : Z
	}
	function A(Z, aa) {
		return parseFloat(Z) || aa
	}
	function H(Z, aa) {
		return (typeof Z !== "undefined") ? Z : aa
	}
	function G(Z) {
		return (Z.indexOf("%") > 0)
	}
	function m(ag) {
		var ae = ["Webkit", "Moz", "O", "ms"],
			ad = document.body || document.documentElement,
			ab = ad.style,
			aa = false;
		if (typeof ab[ag] !== "undefined") {
			aa = ag
		} else {
			var ac = ag.charAt(0).toUpperCase() + ag.slice(1);
			for (var Z = 0; Z < ae.length; Z++) {
				var af = ae[Z] + ac;
				if (typeof ab[af] !== "undefined") {
					aa = af;
					break
				}
			}
		}
		B.support[ag] = aa;
		return aa
	}
	function a(Z) {
		if (/MSIE (\d+\.\d+);/.test(navigator.userAgent)) {
			var aa = new Number(RegExp.$1);
			if (typeof Z === "undefined" || aa <= Z) {
				return true
			}
		}
		return false
	}
	function q(Z) {
		var ab = navigator.userAgent;
		var aa = ab.indexOf("Android");
		if (aa > -1) {
			if (typeof Z === "undefined" || parseFloat(ab.slice(aa + 8)) <= Z) {
				return true
			}
		}
		return false
	}
	function J() {
		var aa = navigator.userAgent;
		var Z = aa.indexOf("Chrome");
		return (Z > -1)
	}
	function p(Z) {
		var ac = Z.length;
		while (--ac > 0) {
			var aa = Math.floor(Math.random() * (ac + 1)),
				ab = Z[ac];
			Z[ac] = Z[aa];
			Z[aa] = ab
		}
	}
	B.fn.copyBorder = function(ac) {
		var ab = ["top", "bottom", "left", "right"],
			aa = ["width", "style", "color"],
			Z = ["borderRadiusTopLeft", "borderRadiusTopRight", "borderRadiusBottomLeft", "borderRadiusBottomRight"];
		return this.each(function() {
			for (var af = 0; af < ab.length; af++) {
				for (var ae = 0; ae < aa.length; ae++) {
					var ad = "border-" + ab[af] + "-" + aa[ae];
					B(this).css(ad, ac.css(ad))
				}
			}
			for (var ae = 0; ae < Z.length; ae++) {
				B(this).css(Z[ae], ac.css(Z[ae]))
			}
		})
	};
	B.fn.transition = function() {
		var ab = arguments[0],
			ad, ae, aa, Z;
		if (typeof arguments[1] === "object") {
			var ac = arguments[1];
			ad = ac.duration;
			ae = ac.easing;
			aa = ac.complete;
			Z = ac.always
		} else {
			ad = arguments[1];
			ae = arguments[2];
			aa = arguments[3]
		}
		ad = H(ad, 400);
		ae = H(ae, "swing");
		return this.each(function() {
			B(this).queue(function() {
				if (B.isFunction(aa)) {
					B(this).one(S, aa);
					B(this).forceTransitionEnd(ad + 50)
				}
				if (B.isFunction(Z)) {
					B(this).one(S + ".always", Z)
				}
				B(this).one(S, function() {
					B(this).dequeue()
				});
				ab[g] = "all " + ad + "ms " + O[ae];
				B(this).reflow().css(ab)
			})
		})
	};
	B.fn.stopTransition = function(Z, aa) {
		return this.each(function() {
			if (Z) {
				B(this).clearQueue()
			}
			clearTimeout(B(this).data("endId"));
			if (aa) {
				B(this).trigger(S)
			} else {
				B(this).trigger(S + ".always");
				B(this).unbind(S)
			}
			B(this).css(g, "none").css(g + "-duration", "0s").dequeue()
		})
	};
	B.fn.reflow = function() {
		return this.each(function() {
			var Z = this.offsetWidth
		})
	};
	B.fn.forceTransitionEnd = function(Z) {
		return this.each(function() {
			var aa = false;
			B(this).one(S, function() {
				aa = true
			});
			B(this).data("endId", setTimeout(B.proxy(function() {
				if (!aa) {
					B(this).trigger(S)
				}
			}, this), Z))
		})
	};
	if (B.cssHooks && B.support.borderRadius) {
		function l(Z) {
			var aa = ("borderRadius" === B.support.borderRadius) ? "border" : B.support.borderRadius.replace("BorderRadius", "") + "Border";
			if ("MozBorderRadius" === B.support.borderRadius) {
				return "MozBorderRadius" + Z.charAt(0).toUpperCase() + Z.substr(1).toLowerCase()
			} else {
				return aa + Z + "Radius"
			}
		}
		B.each(["TopLeft", "TopRight", "BottomRight", "BottomLeft"], function(aa, Z) {
			B.cssHooks["borderRadius" + Z] = {
				get: function(ad, ac, ab) {
					return B.css(ad, l(Z))
				},
				set: function(ab, ac) {
					ab.style[l(Z)] = ac
				}
			}
		})
	}
	var D = {
		play: function() {
			B(this).data(x).play()
		},
		pause: function() {
			B(this).data(x).pause()
		},
		previous: function() {
			B(this).data(x).prevSlide()
		},
		next: function() {
			B(this).data(x).nextSlide()
		},
		destroy: function() {
			var Z = B(this).data(x);
			Z.pause();
			if (typeof Z._namespace !== "undefined" && "" !== Z._namespace) {
				B(window).add(B(document)).unbind(Z._namespace)
			}
			Z._$rotator.add(B("*", Z._$rotator)).unbind().removeData();
			B(this).removeData(x)
		}
	};
	var C = {
		width: 1000,
		height: 300,
		thumbWidth: 28,
		thumbHeight: 28,
		thumbMargin: 3,
		buttonWidth: 28,
		buttonHeight: 28,
		buttonMargin: 3,
		tooltipWidth: "auto",
		tooltipHeight: "auto",
		backgroundRepeat: "repeat",
		backgroundPosition: "center center",
		startIndex: 0,
		autoPlay: true,
		delay: 6000,
		playOnce: false,
		pauseOnHover: false,
		pauseOnInteraction: false,
		effect: "fade",
		duration: 800,
		easing: "",
		cpanelAlign: "bottom",
		cpanelOutside: false,
		cpanelOnHover: false,
		thumbnails: "number",
		selectOnHover: false,
		tooltip: "text",
		tooltipDelay: 0,
		playButton: true,
		timer: "pie",
		timerAlign: "topRight",
		navButtons: "small",
		navButtonsOnHover: false,
		layerEffect: "fade",
		layerDuration: Q,
		layerEasing: "",
		layerDelay: 0,
		layerEffectOut: "fade",
		layerDurationOut: Q,
		layerEasingOut: "",
		layerDelayOut: -1,
		layerSync: true,
		layerOutSync: true,
		layerOnHover: false,
		imagePosition: "fill",
		blockCols: 12,
		blockRows: 4,
		verticalSlices: 14,
		horizontalSlices: 6,
		blockDelay: 25,
		verticalSliceDelay: 75,
		horizontalSliceDelay: 75,
		shuffle: false,
		mousewheel: false,
		keyboard: true,
		swipe: true,
		cssTransition: true,
		responsive: true,
		onInit: function() {},
		onSlideChange: function() {},
		onSlideComplete: function() {},
		onFirstSlide: function() {},
		onLastSlide: function() {},
		onPlay: function() {},
		onPause: function() {},
		onPrev: function() {},
		onNext: function() {}
	};
	B.fn.bannerRotator = function() {
		var Z = arguments;
		var aa = Z[0];
		return this.each(function(ad, ab) {
			if (D[aa]) {
				if (typeof B(ab).data(x) !== "undefined") {
					D[aa].apply(ab, Array.prototype.slice.call(Z, 1))
				}
			} else {
				if (typeof aa === "object" || !aa) {
					var ac = new I(ab, B.extend({}, C, aa));
					B(ab).data(x, ac);
					ac._$rotator.trigger(e);
					ac._options.onInit.call(ac)
				}
			}
		})
	}
})(jQuery);